/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands;

import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.aesh.io.Resource;
import org.infinispan.cli.commands.CLI;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.logging.Messages;

@CommandDefinition(name="connect", description="Connects to a remote server")
public class Connect
extends CliCommand {
    @Argument(description="The connection string 'http://<host>:<port>")
    String connectionString;
    @Option(shortName=117)
    String username;
    @Option(shortName=112)
    String password;
    @Option(completer=FileOptionCompleter.class, shortName=116, name="truststore", description="A truststore to use when connecting to SSL/TLS-enabled servers")
    Resource truststore;
    @Option(shortName=115, name="truststore-password", description="The password for the truststore")
    String truststorePassword;
    @Option(completer=FileOptionCompleter.class, shortName=107, name="keystore", description="A keystore containing a client certificate to authenticate with the server")
    Resource keystore;
    @Option(shortName=119, name="keystore-password", description="The password for the keystore")
    String keystorePassword;
    @Option(name="provider", description="The security provider used to create the SSL/TLS context")
    String provider;
    @Option(hasValue=false, description="Whether to trust all server certificates", name="trustall")
    boolean trustAll;
    @Option(name="hostname-verifier", description="A regular expression used to match hostnames when connecting to SSL/TLS-enabled servers")
    String hostnameVerifier;
    @Option(name="context-path", description="The context path for the server REST connector. If unspecified, defaults to /rest")
    String contextPath;
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public CommandResult exec(ContextAwareCommandInvocation invocation) {
        try {
            CLI.configureSslContext(invocation.getContext(), this.truststore, this.truststorePassword, this.keystore, this.keystorePassword, this.provider, this.hostnameVerifier, this.trustAll);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            invocation.getShell().writeln(Messages.MSG.keyStoreError(e));
            throw new RuntimeException(e);
        }
        if (this.contextPath != null) {
            invocation.getContext().setProperty("infinispan.client.rest.context_path", this.contextPath);
        }
        if (this.username != null) {
            invocation.getContext().connect(invocation.getShell(), this.connectionString, this.username, this.password);
        } else {
            invocation.getContext().connect(invocation.getShell(), this.connectionString);
        }
        return invocation.getContext().isConnected() ? CommandResult.SUCCESS : CommandResult.FAILURE;
    }
}

