/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.resources;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import org.aesh.command.shell.Shell;
import org.infinispan.cli.connection.Connection;
import org.infinispan.cli.logging.Messages;
import org.infinispan.cli.printers.DefaultRowPrinter;
import org.infinispan.cli.printers.PrettyPrinter;
import org.infinispan.cli.resources.Resource;
import org.infinispan.cli.resources.RootResource;

public abstract class AbstractResource
implements Resource {
    final Resource parent;
    final String name;

    protected AbstractResource(Resource parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Resource getParent() {
        return this.parent;
    }

    @Override
    public Iterable<String> getChildrenNames() throws IOException {
        return Collections.emptyList();
    }

    @Override
    public void printChildren(Resource.ListFormat format, int limit, PrettyPrinter.PrettyPrintMode prettyPrintMode, Shell shell) throws IOException {
        Iterator<String> it = this.getChildrenNames().iterator();
        DefaultRowPrinter rowPrinter = new DefaultRowPrinter(shell.size().getWidth(), 1);
        try (PrettyPrinter printer = PrettyPrinter.forMode(prettyPrintMode, shell, rowPrinter);){
            printer.print(it);
        }
    }

    @Override
    public Resource getChild(String name) throws IOException {
        if ("..".equals(name) && this.parent != null) {
            return this.parent;
        }
        throw Messages.MSG.noSuchResource(name);
    }

    @Override
    public Resource getChild(String ... name) throws IOException {
        if (name.length == 1) {
            return this.getChild(name[0]);
        }
        String[] children = new String[name.length - 1];
        System.arraycopy(name, 1, children, 0, name.length - 1);
        return this.getChild(name[0]).getChild(children);
    }

    @Override
    public <T extends Resource> T findAncestor(Class<T> resourceClass) {
        return (T)((Resource)this.optionalFindAncestor(resourceClass).orElseThrow(Messages.MSG::illegalContext));
    }

    @Override
    public <T extends Resource> Optional<T> optionalFindAncestor(Class<T> resourceClass) {
        if (resourceClass.isAssignableFrom(this.getClass())) {
            return Optional.of((Resource)resourceClass.cast(this));
        }
        if (this.parent != null) {
            return this.parent.optionalFindAncestor(resourceClass);
        }
        return Optional.empty();
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public String describe() throws IOException {
        return this.name;
    }

    Connection getConnection() {
        return this.findAncestor(RootResource.class).getConnection();
    }

    @Override
    public Resource getResource(String path) throws IOException {
        if (path == null || ".".equals(path)) {
            return this;
        }
        if ("..".equals(path)) {
            Resource parent = this.getParent();
            if (parent != null) {
                return parent;
            }
            throw Messages.MSG.illegalContext();
        }
        String[] parts = path.split("/");
        if (parts.length == 0) {
            return this.findAncestor(RootResource.class);
        }
        Resource resource = this;
        for (String part : parts) {
            resource = part.isEmpty() ? resource.findAncestor(RootResource.class) : resource.getChild(part);
        }
        return resource;
    }
}

