/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Predicate;

public class JsonReaderIterator
implements Iterator<String>,
AutoCloseable {
    private final Predicate<String> predicate;
    JsonParser parser;
    private String line;
    private boolean eof = false;

    public JsonReaderIterator(Reader reader, Predicate<String> predicate) throws IllegalArgumentException, IOException {
        Objects.nonNull(reader);
        JsonFactory jsonFactory = new JsonFactory();
        this.parser = jsonFactory.createParser((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader)));
        this.predicate = predicate;
    }

    @Override
    public boolean hasNext() {
        if (this.eof) {
            return false;
        }
        if (this.line != null) {
            return true;
        }
        try {
            while (true) {
                JsonToken token;
                if ((token = this.parser.nextToken()) == null) {
                    this.close();
                    return false;
                }
                if (token == JsonToken.FIELD_NAME) {
                    if (this.predicate == null || this.predicate.test(this.parser.currentName())) {
                        this.line = this.parser.nextTextValue();
                        return true;
                    }
                    this.parser.nextTextValue();
                    continue;
                }
                if (token == JsonToken.VALUE_STRING && (this.predicate == null || this.predicate.test(null))) break;
            }
            this.line = this.parser.getValueAsString();
            return true;
        }
        catch (IOException e) {
            this.close();
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        String currentLine = this.line;
        this.line = null;
        return currentLine;
    }

    @Override
    public void close() {
        try {
            this.parser.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.eof = true;
        this.line = null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

