/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.resources;

import java.io.IOException;
import java.util.Collections;
import org.infinispan.cli.connection.Connection;
import org.infinispan.cli.logging.Messages;
import org.infinispan.cli.resources.Resource;
import org.infinispan.cli.resources.RootResource;

public abstract class AbstractResource
implements Resource {
    final Resource parent;
    final String name;

    protected AbstractResource(Resource parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Resource getParent() {
        return this.parent;
    }

    @Override
    public Iterable<String> getChildrenNames() throws IOException {
        return Collections.emptyList();
    }

    @Override
    public Resource getChild(String name) throws IOException {
        if ("..".equals(name)) {
            return this.parent;
        }
        throw Messages.MSG.noSuchResource(name);
    }

    @Override
    public Resource getChild(String ... name) throws IOException {
        if (name.length == 1) {
            return this.getChild(name[0]);
        }
        String[] children = new String[name.length - 1];
        System.arraycopy(name, 1, children, 0, name.length - 1);
        return this.getChild(name[0]).getChild(children);
    }

    @Override
    public <T extends Resource> T findAncestor(Class<T> resourceClass) {
        if (resourceClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        if (this.parent != null) {
            return this.parent.findAncestor(resourceClass);
        }
        throw Messages.MSG.illegalContext();
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public String describe() throws IOException {
        return this.name;
    }

    Connection getConnection() {
        return this.findAncestor(RootResource.class).getConnection();
    }
}

