/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands;

import java.util.List;
import java.util.function.BiConsumer;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.GroupCommandDefinition;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Arguments;
import org.aesh.command.option.Option;
import org.infinispan.cli.Context;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.completers.ConfigPropertyCompleter;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.logging.Messages;

@GroupCommandDefinition(name="config", description="Configuration operations", groupCommands={Set.class, Get.class})
public class Config
extends CliCommand {
    public static final String CMD = "config";
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public CommandResult exec(ContextAwareCommandInvocation invocation) {
        Context context = invocation.getContext();
        context.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> invocation.printf("%s=%s\n", k, v)));
        return CommandResult.SUCCESS;
    }

    @CommandDefinition(name="get", description="Gets a configuration property")
    public static class Get
    extends CliCommand {
        public static final String CMD = "get";
        @Argument(description="The name of the property", required=true, completer=ConfigPropertyCompleter.class)
        String name;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) {
            Context context = invocation.getContext();
            invocation.printf("%s=%s\n", this.name, context.getProperty(this.name));
            return CommandResult.SUCCESS;
        }
    }

    @CommandDefinition(name="set", description="Sets a configuration property")
    public static class Set
    extends CliCommand {
        public static final String CMD = "set";
        @Arguments(description="The property name and value", required=true, completer=ConfigPropertyCompleter.class)
        List<String> args;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        public CommandResult exec(ContextAwareCommandInvocation invocation) {
            Context context = invocation.getContext();
            switch (this.args.size()) {
                case 1: {
                    context.setProperty(this.args.get(0), null);
                    break;
                }
                case 2: {
                    context.setProperty(this.args.get(0), this.args.get(1));
                    break;
                }
                default: {
                    throw Messages.MSG.wrongArgumentCount(this.args.size());
                }
            }
            context.saveProperties();
            return CommandResult.SUCCESS;
        }
    }
}

