/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jivesoftware.util.FastDateFormat;

public class XMPPDateTimeFormat {
    public static final String XMPP_DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String XMPP_DATETIME_FORMAT_WO_TIMEZONE = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    public static final String XMPP_DATETIME_FORMAT_WO_MILLIS_WO_TIMEZONE = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String XMPP_DATE_FORMAT = "yyyy-MM-dd";
    public static final String XMPP_TIME_FORMAT = "HH:mm:ss.SSS";
    public static final String XMPP_TIME_FORMAT_WO_MILLIS = "HH:mm:ss";
    public static final String XMPP_DELAY_DATETIME_FORMAT = "yyyyMMdd'T'HH:mm:ss";
    private static final Pattern xep80DateTimePattern = Pattern.compile("^\\d+(-\\d+){2}+T(\\d+:){2}\\d+.\\d+(Z|([+-](\\d+:\\d+)))?$");
    private static final Pattern xep80DateTimeWoMillisPattern = Pattern.compile("^\\d+(-\\d+){2}+T(\\d+:){2}\\d+(Z|([+-](\\d+:\\d+)))?$");
    private static final Pattern xep91Pattern = Pattern.compile("^\\d+T\\d+:\\d+:\\d+$");
    private static final FastDateFormat FAST_FORMAT = FastDateFormat.getInstance("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", TimeZone.getTimeZone("UTC"));
    private final DateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private final DateFormat dateTimeFormatWoMillies = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

    public XMPPDateTimeFormat() {
        TimeZone utc = TimeZone.getTimeZone("UTC");
        this.dateTimeFormat.setTimeZone(utc);
        this.dateTimeFormatWoMillies.setTimeZone(utc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date parseString(String dateString) throws ParseException {
        Matcher xep82WoMillisMatcher = xep80DateTimeWoMillisPattern.matcher(dateString);
        Matcher xep82Matcher = xep80DateTimePattern.matcher(dateString);
        if (xep82WoMillisMatcher.matches() || xep82Matcher.matches()) {
            String rfc822Date;
            if (dateString.charAt(dateString.length() - 1) == 'Z') {
                rfc822Date = dateString.replace("Z", "+0000");
            } else {
                int lastColon = dateString.lastIndexOf(58);
                rfc822Date = dateString.substring(0, lastColon) + dateString.substring(lastColon + 1);
            }
            if (xep82WoMillisMatcher.matches()) {
                DateFormat dateFormat = this.dateTimeFormatWoMillies;
                synchronized (dateFormat) {
                    return this.dateTimeFormatWoMillies.parse(rfc822Date);
                }
            }
            rfc822Date = rfc822Date.replaceAll("(\\.[0-9]{3})[0-9]*", "$1");
            DateFormat dateFormat = this.dateTimeFormat;
            synchronized (dateFormat) {
                return this.dateTimeFormat.parse(rfc822Date);
            }
        }
        throw new ParseException("Date String could not be parsed", 0);
    }

    public static String format(Date date) {
        return FAST_FORMAT.format(date);
    }
}

