/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.StringTokenizer;
import javax.servlet.http.HttpSession;
import org.jivesoftware.openfire.PresenceManager;
import org.jivesoftware.openfire.PrivateStorage;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.XMPPServerInfo;
import org.jivesoftware.openfire.auth.AuthToken;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.lockout.LockOutManager;
import org.jivesoftware.openfire.muc.MultiUserChatManager;
import org.jivesoftware.openfire.pubsub.PubSubInfo;
import org.jivesoftware.openfire.pubsub.PubSubServiceInfo;
import org.jivesoftware.openfire.roster.RosterManager;
import org.jivesoftware.openfire.security.SecurityAuditManager;
import org.jivesoftware.openfire.user.User;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.util.ClassUtils;
import org.jivesoftware.util.WebBean;
import org.jivesoftware.util.cache.Cache;
import org.jivesoftware.util.cache.CacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebManager
extends WebBean {
    private static final Logger Log = LoggerFactory.getLogger(WebManager.class);
    private int start = 0;
    private int range = 15;

    public HttpSession invalidateSession() {
        this.session.invalidate();
        this.session = this.request.getSession(true);
        return this.session;
    }

    public AuthToken getAuthToken() {
        return (AuthToken)this.session.getAttribute("jive.admin.authToken");
    }

    public boolean isSetupMode() {
        return this.getXMPPServer().isSetupMode();
    }

    public XMPPServer getXMPPServer() {
        XMPPServer xmppServer = XMPPServer.getInstance();
        if (xmppServer == null) {
            this.showServerDown();
            return null;
        }
        return xmppServer;
    }

    public UserManager getUserManager() {
        return this.getXMPPServer().getUserManager();
    }

    public GroupManager getGroupManager() {
        return GroupManager.getInstance();
    }

    public LockOutManager getLockOutManager() {
        return LockOutManager.getInstance();
    }

    public SecurityAuditManager getSecurityAuditManager() {
        return SecurityAuditManager.getInstance();
    }

    public RosterManager getRosterManager() {
        return this.getXMPPServer().getRosterManager();
    }

    public PrivateStorage getPrivateStore() {
        return this.getXMPPServer().getPrivateStorage();
    }

    public PresenceManager getPresenceManager() {
        return this.getXMPPServer().getPresenceManager();
    }

    public SessionManager getSessionManager() {
        return this.getXMPPServer().getSessionManager();
    }

    public MultiUserChatManager getMultiUserChatManager() {
        return this.getXMPPServer().getMultiUserChatManager();
    }

    public XMPPServerInfo getServerInfo() {
        return this.getXMPPServer().getServerInfo();
    }

    public PubSubServiceInfo getPubSubInfo() {
        return new PubSubInfo();
    }

    public void logEvent(String summary, String details) {
        SecurityAuditManager.getInstance().logEvent(this.getUser().getUsername(), summary, details);
    }

    public User getUser() {
        User pageUser = null;
        try {
            AuthToken authToken = this.getAuthToken();
            if (authToken == null) {
                Log.debug("Unable to get user: no auth token on session.");
                return null;
            }
            String username = authToken.getUsername();
            if (username == null || username.isEmpty()) {
                Log.debug("Unable to get user: no username in auth token on session.");
                return null;
            }
            pageUser = this.getUserManager().getUser(username);
        }
        catch (Exception ex) {
            Log.debug("Unexpected exception (which is ignored) while trying to obtain user.", (Throwable)ex);
        }
        return pageUser;
    }

    public boolean isEmbedded() {
        try {
            ClassUtils.forName("org.jivesoftware.openfire.starter.ServerStarter");
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public void restart() {
        try {
            this.getXMPPServer().restart();
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
        this.sleep();
    }

    public void stop() {
        try {
            this.getXMPPServer().stop();
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
        this.sleep();
    }

    public WebManager getManager() {
        return this;
    }

    public void validateService() {
        if (this.getPresenceManager() == null || this.getXMPPServer() == null) {
            this.showServerDown();
        }
    }

    public boolean isServerRunning() {
        return this.getPresenceManager() != null && this.getXMPPServer() != null;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getStart() {
        return this.start;
    }

    public void setRange(int range) {
        this.range = range;
    }

    public int getRange() {
        return this.range;
    }

    public int getCurrentPage() {
        return this.start / this.range + 1;
    }

    private void sleep() {
        try {
            Thread.sleep(3000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void showServerDown() {
        try {
            this.response.sendRedirect("error-serverdown.jsp");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void copy(URL src, File dst) throws IOException {
        try (InputStream in = src.openStream();
             FileOutputStream out = new FileOutputStream(dst);){
            dst.mkdirs();
            WebManager.copy(in, out);
        }
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[4096];
        while ((bytesRead = in.read(buffer)) >= 0) {
            out.write(buffer, 0, bytesRead);
        }
    }

    public int getRowsPerPage(String pageName, int defaultValue) {
        return this.getPageProperty(pageName, "console.rows_per_page", defaultValue);
    }

    public void setRowsPerPage(String pageName, int newValue) {
        this.setPageProperty(pageName, "console.rows_per_page", newValue);
    }

    public int getRefreshValue(String pageName, int defaultValue) {
        return this.getPageProperty(pageName, "console.refresh", defaultValue);
    }

    public void setRefreshValue(String pageName, int newValue) {
        this.setPageProperty(pageName, "console.refresh", newValue);
    }

    public int getPageProperty(String pageName, String property, int defaultValue) {
        String values;
        User user = this.getUser();
        if (user != null && (values = user.getProperties().get(property)) != null) {
            StringTokenizer tokens = new StringTokenizer(values, ",=");
            while (tokens.hasMoreTokens()) {
                String page = tokens.nextToken().trim();
                String rows = tokens.nextToken().trim();
                if (!pageName.equals(page)) continue;
                try {
                    return Integer.parseInt(rows);
                }
                catch (NumberFormatException e) {
                    return defaultValue;
                }
            }
        }
        return defaultValue;
    }

    public void setPageProperty(String pageName, String property, int newValue) {
        String toStore = pageName + "=" + newValue;
        User user = this.getUser();
        if (user != null) {
            String values = user.getProperties().get(property);
            if (values != null) {
                if (values.contains(toStore)) {
                    return;
                }
                if (values.contains(pageName)) {
                    int oldValue = this.getPageProperty(pageName, property, -1);
                    String toRemove = pageName + "=" + oldValue;
                    user.getProperties().put(property, values.replace(toRemove, toStore));
                } else {
                    user.getProperties().put(property, values + "," + toStore);
                }
            } else {
                user.getProperties().put(property, toStore);
            }
        }
    }

    public Cache[] getCaches() {
        Cache[] caches = CacheFactory.getAllCaches();
        Arrays.sort(caches, new Comparator<Cache>(){

            @Override
            public int compare(Cache cache1, Cache cache2) {
                return cache1.getName().toLowerCase().compareTo(cache2.getName().toLowerCase());
            }
        });
        return caches;
    }
}

