/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.util;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.PropertyEventDispatcher;
import org.jivesoftware.util.PropertyEventListener;
import org.jivesoftware.util.TaskEngine;
import org.jsmpp.bean.Alphabet;
import org.jsmpp.bean.BindType;
import org.jsmpp.bean.DataCoding;
import org.jsmpp.bean.ESMClass;
import org.jsmpp.bean.GeneralDataCoding;
import org.jsmpp.bean.MessageClass;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.RegisteredDelivery;
import org.jsmpp.bean.SMSCDeliveryReceipt;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.extra.NegativeResponseException;
import org.jsmpp.session.BindParameter;
import org.jsmpp.session.SMPPSession;
import org.jsmpp.util.AbsoluteTimeFormatter;
import org.jsmpp.util.TimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmsService {
    private static final Logger Log = LoggerFactory.getLogger(SmsService.class);
    private static TimeFormatter timeFormatter = new AbsoluteTimeFormatter();
    private static SmsService INSTANCE;
    private final SMPPSessionPool sessionPool = new SMPPSessionPool();

    public static synchronized SmsService getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SmsService();
        }
        return INSTANCE;
    }

    private SmsService() {
        PropertyEventDispatcher.addListener(this.sessionPool);
    }

    public void send(String message, String recipient) {
        if (message == null || message.isEmpty()) {
            throw new IllegalArgumentException("Argument 'message' cannot be null or an empty String.");
        }
        if (recipient == null || recipient.isEmpty()) {
            throw new IllegalArgumentException("Argument 'recipient' cannot be null or an empty String.");
        }
        TaskEngine.getInstance().submit(new SmsTask((ObjectPool<SMPPSession>)this.sessionPool, message, recipient));
    }

    public void sendImmediately(String message, String recipient) throws Exception {
        if (message == null || message.isEmpty()) {
            throw new IllegalArgumentException("Argument 'message' cannot be null or an empty String.");
        }
        if (recipient == null || recipient.isEmpty()) {
            throw new IllegalArgumentException("Argument 'recipient' cannot be null or an empty String.");
        }
        try {
            new SmsTask((ObjectPool<SMPPSession>)this.sessionPool, message, recipient).sendMessage();
        }
        catch (Exception e) {
            Log.error("An exception occurred while sending a SMS message (to '{}')", (Object)recipient, (Object)e);
            throw e;
        }
    }

    public static String getDescriptiveMessage(Throwable ex) {
        if (ex instanceof NegativeResponseException) {
            HashMap<Integer, String> errors = new HashMap<Integer, String>();
            errors.put(0, "No Error");
            errors.put(1, "Message too long");
            errors.put(2, "Command length is invalid");
            errors.put(3, "Command ID is invalid or not supported");
            errors.put(4, "Incorrect bind status for given command");
            errors.put(5, "Already bound");
            errors.put(6, "Invalid Priority Flag");
            errors.put(7, "Invalid registered delivery flag");
            errors.put(8, "System error");
            errors.put(10, "Invalid source address");
            errors.put(11, "Invalid destination address");
            errors.put(12, "Message ID is invalid");
            errors.put(13, "Bind failed");
            errors.put(14, "Invalid password");
            errors.put(15, "Invalid System ID");
            errors.put(17, "Cancelling message failed");
            errors.put(19, "Message recplacement failed");
            errors.put(20, "Message queue full");
            errors.put(21, "Invalid service type");
            errors.put(51, "Invalid number of destinations");
            errors.put(52, "Invalid distribution list name");
            errors.put(64, "Invalid destination flag");
            errors.put(66, "Invalid submit with replace request");
            errors.put(67, "Invalid esm class set");
            errors.put(68, "Invalid submit to ditribution list");
            errors.put(69, "Submitting message has failed");
            errors.put(72, "Invalid source address type of number ( TON )");
            errors.put(73, "Invalid source address numbering plan ( NPI )");
            errors.put(80, "Invalid destination address type of number ( TON )");
            errors.put(81, "Invalid destination address numbering plan ( NPI )");
            errors.put(83, "Invalid system type");
            errors.put(84, "Invalid replace_if_present flag");
            errors.put(85, "Invalid number of messages");
            errors.put(88, "Throttling error");
            errors.put(97, "Invalid scheduled delivery time");
            errors.put(98, "Invalid Validty Period value");
            errors.put(99, "Predefined message not found");
            errors.put(100, "ESME Receiver temporary error");
            errors.put(101, "ESME Receiver permanent error");
            errors.put(102, "ESME Receiver reject message error");
            errors.put(103, "Message query request failed");
            errors.put(192, "Error in the optional part of the PDU body");
            errors.put(193, "TLV not allowed");
            errors.put(194, "Invalid parameter length");
            errors.put(195, "Expected TLV missing");
            errors.put(196, "Invalid TLV value");
            errors.put(254, "Transaction delivery failure");
            errors.put(255, "Unknown error");
            errors.put(256, "ESME not authorised to use specified servicetype");
            errors.put(257, "ESME prohibited from using specified operation");
            errors.put(258, "Specified servicetype is unavailable");
            errors.put(259, "Specified servicetype is denied");
            errors.put(260, "Invalid data coding scheme");
            errors.put(261, "Invalid source address subunit");
            errors.put(262, "Invalid destination address subunit");
            errors.put(1035, "Insufficient credits to send message");
            errors.put(1036, "Destination address blocked by the ActiveXperts SMPP Demo Server");
            String error = (String)errors.get(((NegativeResponseException)ex).getCommandStatus());
            if (ex.getMessage() != null && !ex.getMessage().isEmpty()) {
                error = error + " (exception message: '" + ex.getMessage() + "')";
            }
            return error;
        }
        if (ex.getCause() != null) {
            return SmsService.getDescriptiveMessage(ex.getCause());
        }
        return ex.getMessage();
    }

    static /* synthetic */ TimeFormatter access$000() {
        return timeFormatter;
    }

    private static class SMPPSessionPool
    extends GenericObjectPool<SMPPSession>
    implements PropertyEventListener {
        private static final Logger Log = LoggerFactory.getLogger(SMPPSessionPool.class);

        SMPPSessionPool() {
            super((PooledObjectFactory)new SMPPSessionFactory());
            this.setMaxTotal(JiveGlobals.getIntProperty("sms.smpp.connections.maxAmount", 1));
            this.setNumTestsPerEvictionRun(this.getMaxTotal());
            this.setMinEvictableIdleTimeMillis(JiveGlobals.getLongProperty("sms.smpp.connections.idleMillis", 120000L));
            if (this.getMinEvictableIdleTimeMillis() > 0L) {
                this.setTimeBetweenEvictionRunsMillis(this.getMinEvictableIdleTimeMillis() / 10L);
            }
            this.setTestOnBorrow(true);
            this.setTestWhileIdle(true);
        }

        void processPropertyChange(String propertyName) {
            HashSet<String> ofInterest = new HashSet<String>();
            ofInterest.add("sms.smpp.host");
            ofInterest.add("sms.smpp.port");
            ofInterest.add("sms.smpp.systemId");
            ofInterest.add("sms.smpp.password");
            ofInterest.add("sms.smpp.systemType");
            ofInterest.add("sms.smpp.receive.ton");
            ofInterest.add("sms.smpp.receive.npi");
            if (ofInterest.contains(propertyName)) {
                Log.debug("Property change for '{}' detected. Clearing all (inactive) sessions.", (Object)propertyName);
                if (this.getNumActive() > 0) {
                    Log.warn("Note that property change for '{}' will not affect one or more sessions that are currently actively used (although changes will be applied after the session is rotated out, due to time-based eviction).");
                }
                this.clear();
            }
            if (propertyName.equals("sms.smpp.connections.maxAmount")) {
                this.setMaxTotal(JiveGlobals.getIntProperty("sms.smpp.connections.maxAmount", 1));
                this.setNumTestsPerEvictionRun(this.getMaxTotal());
            }
            if (propertyName.equals("sms.smpp.connections.idleMillis")) {
                this.setMinEvictableIdleTimeMillis(JiveGlobals.getLongProperty("sms.smpp.connections.idleMillis", 120000L));
                if (this.getMinEvictableIdleTimeMillis() > 0L) {
                    this.setTimeBetweenEvictionRunsMillis(this.getMinEvictableIdleTimeMillis() / 10L);
                }
            }
        }

        @Override
        public void propertySet(String property, Map<String, Object> params) {
            this.processPropertyChange(property);
        }

        @Override
        public void propertyDeleted(String property, Map<String, Object> params) {
            this.processPropertyChange(property);
        }

        @Override
        public void xmlPropertySet(String property, Map<String, Object> params) {
            this.processPropertyChange(property);
        }

        @Override
        public void xmlPropertyDeleted(String property, Map<String, Object> params) {
            this.processPropertyChange(property);
        }
    }

    private static class SMPPSessionFactory
    extends BasePooledObjectFactory<SMPPSession> {
        private static final Logger Log = LoggerFactory.getLogger(SMPPSessionFactory.class);

        private SMPPSessionFactory() {
        }

        public SMPPSession create() throws Exception {
            String host = JiveGlobals.getProperty("sms.smpp.host", "localhost");
            int port = JiveGlobals.getIntProperty("sms.smpp.port", 2775);
            String systemId = JiveGlobals.getProperty("sms.smpp.systemId");
            String password = JiveGlobals.getProperty("sms.smpp.password");
            String systemType = JiveGlobals.getProperty("sms.smpp.systemType");
            TypeOfNumber receiveTon = JiveGlobals.getEnumProperty("sms.smpp.receive.ton", TypeOfNumber.class, TypeOfNumber.UNKNOWN);
            NumberingPlanIndicator receiveNpi = JiveGlobals.getEnumProperty("sms.smpp.receive.npi", NumberingPlanIndicator.class, NumberingPlanIndicator.UNKNOWN);
            Log.debug("Creating a new sesssion (host: '{}', port: '{}', systemId: '{}'.", new Object[]{host, port, systemId});
            SMPPSession session = new SMPPSession();
            session.connectAndBind(host, port, new BindParameter(BindType.BIND_TX, systemId, password, systemType, receiveTon, receiveNpi, null));
            Log.debug("Created a new session with ID '{}'.", (Object)session.getSessionId());
            return session;
        }

        public boolean validateObject(PooledObject<SMPPSession> pooledObject) {
            SMPPSession session = (SMPPSession)pooledObject.getObject();
            boolean isValid = session.getSessionState().isTransmittable();
            Log.debug("Ran a check to see if session with ID '{}' is valid. Outcome: {}", (Object)session.getSessionId(), (Object)isValid);
            return isValid;
        }

        public void destroyObject(PooledObject<SMPPSession> pooledObject) throws Exception {
            SMPPSession session = (SMPPSession)pooledObject.getObject();
            Log.debug("Destroying a pooled session with ID '{}'.", (Object)session.getSessionId());
            session.unbindAndClose();
        }

        public PooledObject<SMPPSession> wrap(SMPPSession smppSession) {
            return new DefaultPooledObject((Object)smppSession);
        }
    }

    private static class SmsTask
    implements Runnable {
        private final ObjectPool<SMPPSession> sessionPool;
        private final TypeOfNumber sourceTon = JiveGlobals.getEnumProperty("sms.smpp.source.ton", TypeOfNumber.class, TypeOfNumber.UNKNOWN);
        private final NumberingPlanIndicator sourceNpi = JiveGlobals.getEnumProperty("sms.smpp.source.npi", NumberingPlanIndicator.class, NumberingPlanIndicator.UNKNOWN);
        private final String sourceAddress = JiveGlobals.getProperty("sms.smpp.source.address");
        private final TypeOfNumber destinationTon = JiveGlobals.getEnumProperty("sms.smpp.destination.ton", TypeOfNumber.class, TypeOfNumber.UNKNOWN);
        private final NumberingPlanIndicator destinationNpi = JiveGlobals.getEnumProperty("sms.smpp.destination.npi", NumberingPlanIndicator.class, NumberingPlanIndicator.UNKNOWN);
        private final String destinationAddress;
        private final byte[] message;
        private final ESMClass esm = new ESMClass();
        private final byte protocolId = 0;
        private final byte priorityFlag = 1;
        private final String serviceType = "CMT";
        private final String scheduleDeliveryTime = SmsService.access$000().format(new Date());
        private final String validityPeriod;
        private final RegisteredDelivery registeredDelivery = new RegisteredDelivery(SMSCDeliveryReceipt.DEFAULT);
        private final byte replaceIfPresentFlag = 0;
        private final DataCoding dataCoding = new GeneralDataCoding(Alphabet.ALPHA_DEFAULT, MessageClass.CLASS1, false);
        private final byte smDefaultMsgId = 0;

        SmsTask(ObjectPool<SMPPSession> sessionPool, String message, String destinationAddress) {
            this.validityPeriod = null;
            this.sessionPool = sessionPool;
            this.message = message.getBytes();
            this.destinationAddress = destinationAddress;
        }

        @Override
        public void run() {
            try {
                this.sendMessage();
            }
            catch (Exception e) {
                Log.error("An exception occurred while sending a SMS message (to '{}')", (Object)this.destinationAddress, (Object)e);
            }
        }

        public void sendMessage() throws Exception {
            SMPPSession session = (SMPPSession)this.sessionPool.borrowObject();
            try {
                String messageId = session.submitShortMessage("CMT", this.sourceTon, this.sourceNpi, this.sourceAddress, this.destinationTon, this.destinationNpi, this.destinationAddress, this.esm, (byte)0, (byte)1, this.scheduleDeliveryTime, this.validityPeriod, this.registeredDelivery, (byte)0, this.dataCoding, (byte)0, this.message, new OptionalParameter[0]);
                Log.debug("Message submitted, message_id is '{}'.", (Object)messageId);
            }
            finally {
                this.sessionPool.returnObject((Object)session);
            }
        }
    }
}

