/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamedThreadFactory
implements ThreadFactory {
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String threadNamePrefix;
    private final ThreadFactory delegate;
    private final Boolean daemon;
    private final Integer priority;
    private final Long stackSize;
    private final ThreadGroup threadGroup;

    public NamedThreadFactory(String threadNamePrefix, ThreadFactory delegate, Boolean daemon, Integer priority) {
        if (threadNamePrefix == null || threadNamePrefix.isEmpty()) {
            throw new IllegalArgumentException("Argument 'threadNamePrefix' cannot be null or an empty string.");
        }
        this.threadNamePrefix = threadNamePrefix;
        this.delegate = delegate;
        this.daemon = daemon;
        this.priority = priority;
        this.threadGroup = null;
        this.stackSize = null;
    }

    public NamedThreadFactory(String threadNamePrefix, Boolean daemon, Integer priority, ThreadGroup threadGroup, Long stackSize) {
        if (threadNamePrefix == null || threadNamePrefix.isEmpty()) {
            throw new IllegalArgumentException("Argument 'threadNamePrefix' cannot be null or an empty string.");
        }
        this.delegate = null;
        this.threadNamePrefix = threadNamePrefix;
        this.daemon = daemon;
        this.priority = priority;
        this.threadGroup = threadGroup;
        this.stackSize = stackSize;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread;
        String name = this.threadNamePrefix + this.threadNumber.incrementAndGet();
        if (this.delegate != null) {
            thread = this.delegate.newThread(runnable);
            thread.setName(name);
        } else {
            thread = this.stackSize != null ? new Thread(this.threadGroup, runnable, name, this.stackSize) : new Thread(this.threadGroup, runnable, name);
        }
        if (this.daemon != null && thread.isDaemon() != this.daemon.booleanValue()) {
            thread.setDaemon(this.daemon);
        }
        if (this.priority != null && thread.getPriority() != this.priority.intValue()) {
            thread.setPriority(this.priority);
        }
        return thread;
    }
}

