/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.util.Encryptor;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.PropertyClusterEventTask;
import org.jivesoftware.util.PropertyEventDispatcher;
import org.jivesoftware.util.cache.CacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiveProperties
implements Map<String, String> {
    private static final Logger Log = LoggerFactory.getLogger(JiveProperties.class);
    private static final String LOAD_PROPERTIES = "SELECT name, propValue, encrypted FROM ofProperty";
    private static final String INSERT_PROPERTY = "INSERT INTO ofProperty(name, propValue, encrypted) VALUES(?,?,?)";
    private static final String UPDATE_PROPERTY = "UPDATE ofProperty SET propValue=?, encrypted=? WHERE name=?";
    private static final String DELETE_PROPERTY = "DELETE FROM ofProperty WHERE name LIKE ?";
    private static JiveProperties instance = null;
    private Map<String, String> properties;
    private Map<String, Boolean> encrypted;

    public static synchronized JiveProperties getInstance() {
        if (instance == null) {
            JiveProperties props = new JiveProperties();
            props.init();
            instance = props;
        }
        return instance;
    }

    private JiveProperties() {
    }

    public void init() {
        if (this.properties == null) {
            this.properties = new ConcurrentHashMap<String, String>();
            this.encrypted = new ConcurrentHashMap<String, Boolean>();
        } else {
            this.properties.clear();
            this.encrypted.clear();
        }
        this.loadProperties();
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.properties.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.properties.containsValue(value);
    }

    @Override
    public Collection<String> values() {
        return Collections.unmodifiableCollection(this.properties.values());
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> t) {
        for (Map.Entry<? extends String, ? extends String> entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return Collections.unmodifiableSet(this.properties.entrySet());
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    @Override
    public String get(Object key) {
        return this.properties.get(key);
    }

    boolean isEncrypted(String name) {
        if (name == null) {
            return false;
        }
        Boolean isEncrypted = this.encrypted.get(name);
        return isEncrypted != null && isEncrypted != false;
    }

    boolean setPropertyEncrypted(String name, boolean encrypt) {
        boolean encryptionWasChanged;
        boolean bl = encryptionWasChanged = name != null && this.properties.containsKey(name) && this.isEncrypted(name) != encrypt;
        if (encryptionWasChanged) {
            String value = this.get(name);
            this.put(name, value, encrypt);
        }
        return encryptionWasChanged;
    }

    public Collection<String> getChildrenNames(String parentKey) {
        HashSet<String> results = new HashSet<String>();
        for (String key : this.properties.keySet()) {
            if (!key.startsWith(parentKey + ".") || key.equals(parentKey)) continue;
            int dotIndex = key.indexOf(".", parentKey.length() + 1);
            if (dotIndex < 1) {
                if (results.contains(key)) continue;
                results.add(key);
                continue;
            }
            String name = parentKey + key.substring(parentKey.length(), dotIndex);
            results.add(name);
        }
        return results;
    }

    public Collection<String> getPropertyNames() {
        return this.properties.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String remove(Object key) {
        String value;
        JiveProperties jiveProperties = this;
        synchronized (jiveProperties) {
            value = this.properties.remove(key);
            Collection<String> propNames = this.getPropertyNames();
            for (String name : propNames) {
                if (!name.startsWith((String)key)) continue;
                this.properties.remove(name);
            }
            this.deleteProperty((String)key);
        }
        Map<String, Object> params = Collections.emptyMap();
        PropertyEventDispatcher.dispatchEvent((String)key, PropertyEventDispatcher.EventType.property_deleted, params);
        CacheFactory.doClusterTask(PropertyClusterEventTask.createDeleteTask((String)key));
        return value;
    }

    void localRemove(String key) {
        this.properties.remove(key);
        Collection<String> propNames = this.getPropertyNames();
        for (String name : propNames) {
            if (!name.startsWith(key)) continue;
            this.properties.remove(name);
        }
        Map<String, Object> params = Collections.emptyMap();
        PropertyEventDispatcher.dispatchEvent(key, PropertyEventDispatcher.EventType.property_deleted, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String put(String key, String value, boolean isEncrypted) {
        String result;
        if (value == null) {
            return this.remove(key);
        }
        if (key == null) {
            throw new NullPointerException("Key cannot be null. Key=" + key + ", value=" + value);
        }
        if (key.endsWith(".")) {
            key = key.substring(0, key.length() - 1);
        }
        key = key.trim();
        JiveProperties jiveProperties = this;
        synchronized (jiveProperties) {
            if (this.properties.containsKey(key)) {
                this.updateProperty(key, value, isEncrypted);
            } else {
                this.insertProperty(key, value, isEncrypted);
            }
            result = this.properties.put(key, value);
            this.encrypted.put(key, isEncrypted);
            JiveGlobals.clearXMLPropertyEncryptionEntry(key);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("value", value);
        PropertyEventDispatcher.dispatchEvent(key, PropertyEventDispatcher.EventType.property_set, params);
        CacheFactory.doClusterTask(PropertyClusterEventTask.createPutTask(key, value, isEncrypted));
        return result;
    }

    @Override
    public String put(String key, String value) {
        return this.put(key, value, this.isEncrypted(key));
    }

    void localPut(String key, String value, boolean isEncrypted) {
        this.properties.put(key, value);
        this.encrypted.put(key, isEncrypted);
        JiveGlobals.clearXMLPropertyEncryptionEntry(key);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("value", value);
        PropertyEventDispatcher.dispatchEvent(key, PropertyEventDispatcher.EventType.property_set, params);
    }

    public String getProperty(String name, String defaultValue) {
        String value = this.properties.get(name);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public boolean getBooleanProperty(String name) {
        return Boolean.valueOf(this.get(name));
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        String value = this.get(name);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertProperty(String name, String value, boolean isEncrypted) {
        Encryptor encryptor = this.getEncryptor();
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(INSERT_PROPERTY);
            pstmt.setString(1, name);
            pstmt.setString(2, isEncrypted ? encryptor.encrypt(value) : value);
            pstmt.setInt(3, isEncrypted ? 1 : 0);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                Log.error(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
        DbConnectionManager.closeConnection(pstmt, con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProperty(String name, String value, boolean isEncrypted) {
        Encryptor encryptor = this.getEncryptor();
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(UPDATE_PROPERTY);
            pstmt.setString(1, isEncrypted ? encryptor.encrypt(value) : value);
            pstmt.setInt(2, isEncrypted ? 1 : 0);
            pstmt.setString(3, name);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                Log.error(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
        DbConnectionManager.closeConnection(pstmt, con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteProperty(String name) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(DELETE_PROPERTY);
            pstmt.setString(1, name + "%");
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                Log.error(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
        DbConnectionManager.closeConnection(pstmt, con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties() {
        Encryptor encryptor = this.getEncryptor();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(LOAD_PROPERTIES);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                boolean isEncrypted;
                String name = rs.getString(1);
                String value = rs.getString(2);
                boolean bl = isEncrypted = rs.getInt(3) == 1 || JiveGlobals.isXMLPropertyEncrypted(name);
                if (isEncrypted) {
                    try {
                        value = encryptor.decrypt(value);
                    }
                    catch (Exception ex) {
                        Log.error("Failed to load encrypted property value for " + name, (Throwable)ex);
                        value = null;
                    }
                }
                if (value == null) continue;
                this.properties.put(name, value);
                this.encrypted.put(name, isEncrypted);
            }
        }
        catch (Exception e) {
            try {
                Log.error(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(rs, pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        DbConnectionManager.closeConnection(rs, pstmt, con);
    }

    private Encryptor getEncryptor() {
        return JiveGlobals.getPropertyEncryptor();
    }
}

