/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.util;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TimerTask;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.util.AesEncryptor;
import org.jivesoftware.util.Blowfish;
import org.jivesoftware.util.Encryptor;
import org.jivesoftware.util.JiveProperties;
import org.jivesoftware.util.PropertyEventDispatcher;
import org.jivesoftware.util.TaskEngine;
import org.jivesoftware.util.XMLProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiveGlobals {
    private static final Logger Log = LoggerFactory.getLogger(JiveGlobals.class);
    private static String JIVE_CONFIG_FILENAME = "conf" + File.separator + "openfire.xml";
    private static final String JIVE_SECURITY_FILENAME = "conf" + File.separator + "security.xml";
    private static final String ENCRYPTED_PROPERTY_NAME_PREFIX = "encrypt.";
    private static final String ENCRYPTED_PROPERTY_NAMES = "encrypt.property.name";
    private static final String ENCRYPTION_ALGORITHM = "encrypt.algorithm";
    private static final String ENCRYPTION_KEY_CURRENT = "encrypt.key.current";
    private static final String ENCRYPTION_KEY_NEW = "encrypt.key.new";
    private static final String ENCRYPTION_KEY_OLD = "encrypt.key.old";
    private static final String ENCRYPTION_ALGORITHM_AES = "AES";
    private static final String ENCRYPTION_ALGORITHM_BLOWFISH = "Blowfish";
    private static String home = null;
    public static boolean failedLoading = false;
    private static XMLProperties openfireProperties = null;
    private static XMLProperties securityProperties = null;
    private static JiveProperties properties = null;
    private static Locale locale = null;
    private static TimeZone timeZone = null;
    private static DateFormat dateFormat = null;
    private static DateFormat dateTimeFormat = null;
    private static DateFormat timeFormat = null;
    private static Encryptor propertyEncryptor = null;
    private static String currentKey = null;

    public static Locale getLocale() {
        if (locale == null) {
            if (openfireProperties != null) {
                String localeProperty = openfireProperties.getProperty("locale");
                String[] localeArray = localeProperty != null ? localeProperty.split("_") : new String[]{"", ""};
                String language = localeArray[0];
                if (language == null) {
                    language = "";
                }
                String country = "";
                if (localeArray.length == 2) {
                    country = localeArray[1];
                }
                locale = language.equals("") && country.equals("") ? Locale.getDefault() : new Locale(language, country);
            } else {
                return Locale.getDefault();
            }
        }
        return locale;
    }

    public static void setLocale(Locale newLocale) {
        locale = newLocale;
        JiveGlobals.setXMLProperty("locale", locale.toString());
        timeFormat = null;
        dateFormat = null;
        dateTimeFormat = null;
    }

    public static TimeZone getTimeZone() {
        if (timeZone == null) {
            if (properties != null) {
                String timeZoneID = properties.get("locale.timeZone");
                timeZone = timeZoneID == null ? TimeZone.getDefault() : TimeZone.getTimeZone(timeZoneID);
            } else {
                return TimeZone.getDefault();
            }
        }
        return timeZone;
    }

    public static void setTimeZone(TimeZone newTimeZone) {
        timeZone = newTimeZone;
        if (timeFormat != null) {
            timeFormat.setTimeZone(timeZone);
        }
        if (dateFormat != null) {
            dateFormat.setTimeZone(timeZone);
        }
        if (dateTimeFormat != null) {
            dateTimeFormat.setTimeZone(timeZone);
        }
        JiveGlobals.setProperty("locale.timeZone", timeZone.getID());
    }

    public static String formatTime(Date date) {
        if (timeFormat == null) {
            if (properties != null) {
                timeFormat = DateFormat.getTimeInstance(3, JiveGlobals.getLocale());
                timeFormat.setTimeZone(JiveGlobals.getTimeZone());
            } else {
                DateFormat instance = DateFormat.getTimeInstance(3, JiveGlobals.getLocale());
                instance.setTimeZone(JiveGlobals.getTimeZone());
                return instance.format(date);
            }
        }
        return timeFormat.format(date);
    }

    public static String formatDate(Date date) {
        if (dateFormat == null) {
            if (properties != null) {
                dateFormat = DateFormat.getDateInstance(2, JiveGlobals.getLocale());
                dateFormat.setTimeZone(JiveGlobals.getTimeZone());
            } else {
                DateFormat instance = DateFormat.getDateInstance(2, JiveGlobals.getLocale());
                instance.setTimeZone(JiveGlobals.getTimeZone());
                return instance.format(date);
            }
        }
        return dateFormat.format(date);
    }

    public static String formatDateTime(Date date) {
        if (dateTimeFormat == null) {
            if (properties != null) {
                dateTimeFormat = DateFormat.getDateTimeInstance(2, 2, JiveGlobals.getLocale());
                dateTimeFormat.setTimeZone(JiveGlobals.getTimeZone());
            } else {
                DateFormat instance = DateFormat.getDateTimeInstance(2, 2, JiveGlobals.getLocale());
                instance.setTimeZone(JiveGlobals.getTimeZone());
                return instance.format(date);
            }
        }
        return dateTimeFormat.format(date);
    }

    public static String getHomeDirectory() {
        if (openfireProperties == null) {
            JiveGlobals.loadOpenfireProperties();
        }
        return home;
    }

    public static void setHomeDirectory(String pathname) {
        File mh = new File(pathname);
        if (!mh.exists()) {
            Log.error("Error - the specified home directory does not exist (" + pathname + ")");
        } else if (!mh.canRead() || !mh.canWrite()) {
            Log.error("Error - the user running this application can not read and write to the specified home directory (" + pathname + "). Please grant the executing user read and write permissions.");
        } else {
            home = pathname;
        }
    }

    public static String getXMLProperty(String name) {
        if (openfireProperties == null) {
            JiveGlobals.loadOpenfireProperties();
        }
        return openfireProperties.getProperty(name);
    }

    public static String getXMLProperty(String name, String defaultValue) {
        String value;
        if (openfireProperties == null) {
            JiveGlobals.loadOpenfireProperties();
        }
        if ((value = openfireProperties.getProperty(name)) == null) {
            value = defaultValue;
        }
        return value;
    }

    public static int getXMLProperty(String name, int defaultValue) {
        String value = JiveGlobals.getXMLProperty(name);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static boolean getXMLProperty(String name, boolean defaultValue) {
        String value = JiveGlobals.getXMLProperty(name);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return defaultValue;
    }

    public static void setXMLProperty(String name, String value) {
        if (openfireProperties == null) {
            JiveGlobals.loadOpenfireProperties();
        }
        openfireProperties.setProperty(name, value);
    }

    public static void setXMLProperties(Map<String, String> propertyMap) {
        if (openfireProperties == null) {
            JiveGlobals.loadOpenfireProperties();
        }
        openfireProperties.setProperties(propertyMap);
    }

    public static List getXMLProperties(String parent) {
        if (openfireProperties == null) {
            JiveGlobals.loadOpenfireProperties();
        }
        String[] propNames = openfireProperties.getChildrenProperties(parent);
        ArrayList<String> values = new ArrayList<String>();
        for (String propName : propNames) {
            String value = JiveGlobals.getXMLProperty(parent + "." + propName);
            if (value == null) continue;
            values.add(value);
        }
        return values;
    }

    public static List<String> getXMLPropertyNames() {
        if (openfireProperties == null) {
            JiveGlobals.loadOpenfireProperties();
        }
        return openfireProperties.getAllPropertyNames();
    }

    public static void deleteXMLProperty(String name) {
        if (openfireProperties == null) {
            JiveGlobals.loadOpenfireProperties();
        }
        openfireProperties.deleteProperty(name);
    }

    public static String getProperty(String name) {
        if (properties == null) {
            if (JiveGlobals.isSetupMode()) {
                return null;
            }
            properties = JiveProperties.getInstance();
        }
        return properties.get(name);
    }

    public static String getProperty(String name, String defaultValue) {
        String value;
        if (properties == null) {
            if (JiveGlobals.isSetupMode()) {
                return defaultValue;
            }
            properties = JiveProperties.getInstance();
        }
        if ((value = properties.get(name)) != null) {
            return value;
        }
        return defaultValue;
    }

    public static <E extends Enum<E>> E getEnumProperty(String name, Class<E> enumType, E defaultValue) {
        String value = JiveGlobals.getProperty(name);
        if (value != null) {
            try {
                return Enum.valueOf(enumType, value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static int getIntProperty(String name, int defaultValue) {
        String value = JiveGlobals.getProperty(name);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static long getLongProperty(String name, long defaultValue) {
        String value = JiveGlobals.getProperty(name);
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static boolean getBooleanProperty(String name) {
        return Boolean.valueOf(JiveGlobals.getProperty(name));
    }

    public static boolean getBooleanProperty(String name, boolean defaultValue) {
        String value = JiveGlobals.getProperty(name);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return defaultValue;
    }

    public static List<String> getPropertyNames(String parent) {
        if (properties == null) {
            if (JiveGlobals.isSetupMode()) {
                return new ArrayList<String>();
            }
            properties = JiveProperties.getInstance();
        }
        return new ArrayList<String>(properties.getChildrenNames(parent));
    }

    public static List<String> getProperties(String parent) {
        return JiveGlobals.getListProperty(parent, new ArrayList<String>());
    }

    public static List<String> getListProperty(String parent, List<String> defaultValues) {
        if (properties == null) {
            if (JiveGlobals.isSetupMode()) {
                return defaultValues;
            }
            properties = JiveProperties.getInstance();
        }
        String legacyValue = JiveGlobals.getProperty(parent);
        TreeSet<String> propertyNames = new TreeSet<String>(properties.getChildrenNames(parent));
        if (propertyNames.isEmpty()) {
            if (legacyValue != null) {
                Log.info("Retrieving a list from property '{}' which is stored in a comma-separated format. Consider using child properties instead, via JiveGlobals.setProperty( String value, List<String> values )", (Object)parent);
                return Arrays.asList(legacyValue.split("\\s*,\\s*"));
            }
            return defaultValues;
        }
        if (legacyValue != null) {
            Log.warn("Retrieving a list from property '{}' which is stored using child properties, but also in a legacy format! The data that is in the legacy format (the text value of property '{}') is not returned by this call! Its child property values are used instead. Consider removing the text value of the parent property.", (Object)parent, (Object)parent);
        }
        ArrayList<String> values = new ArrayList<String>();
        for (String propertyName : propertyNames) {
            String value = JiveGlobals.getProperty(propertyName);
            if (value == null || value.isEmpty()) continue;
            values.add(value);
        }
        return values;
    }

    public static List<String> getPropertyNames() {
        if (properties == null) {
            if (JiveGlobals.isSetupMode()) {
                return new ArrayList<String>();
            }
            properties = JiveProperties.getInstance();
        }
        return new ArrayList<String>(properties.getPropertyNames());
    }

    public static void setProperty(String name, String value) {
        JiveGlobals.setProperty(name, value, false);
    }

    public static void setProperty(String name, String value, boolean encrypt) {
        if (properties == null) {
            if (JiveGlobals.isSetupMode()) {
                return;
            }
            properties = JiveProperties.getInstance();
        }
        properties.put(name, value, encrypt);
    }

    public static void setProperty(String name, List<String> values) {
        List<String> existing;
        if (properties == null) {
            if (JiveGlobals.isSetupMode()) {
                return;
            }
            properties = JiveProperties.getInstance();
        }
        if ((existing = JiveGlobals.getProperties(name)) != null && existing.equals(values)) {
            return;
        }
        properties.remove(name);
        if (values != null) {
            int i = 1;
            for (String value : values) {
                if (value == null || value.isEmpty()) continue;
                String childName = name + "." + String.format("%05d", i++);
                properties.put(childName, value);
            }
            if (i == 1) {
                properties.put(name + ".00001", "");
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("value", values);
            PropertyEventDispatcher.dispatchEvent(name, PropertyEventDispatcher.EventType.property_set, params);
        }
    }

    public static void setProperties(Map<String, String> propertyMap) {
        if (properties == null) {
            if (JiveGlobals.isSetupMode()) {
                return;
            }
            properties = JiveProperties.getInstance();
        }
        properties.putAll((Map<? extends String, ? extends String>)propertyMap);
    }

    public static void deleteProperty(String name) {
        if (properties == null) {
            if (JiveGlobals.isSetupMode()) {
                return;
            }
            properties = JiveProperties.getInstance();
        }
        properties.remove(name);
        JiveGlobals.clearXMLPropertyEncryptionEntry(name);
    }

    static void clearXMLPropertyEncryptionEntry(String name) {
        if (JiveGlobals.isSetupMode()) {
            return;
        }
        if (securityProperties == null) {
            JiveGlobals.loadSecurityProperties();
        }
        if (openfireProperties == null) {
            JiveGlobals.loadOpenfireProperties();
        }
        if (JiveGlobals.isXMLPropertyEncrypted(name) && openfireProperties.getProperty(name) == null) {
            securityProperties.removeFromList(ENCRYPTED_PROPERTY_NAMES, name);
        }
    }

    public static void migrateProperty(String name) {
        if (JiveGlobals.isSetupMode()) {
            return;
        }
        if (openfireProperties == null) {
            JiveGlobals.loadOpenfireProperties();
        }
        openfireProperties.migrateProperty(name);
    }

    public static boolean isPropertySensitive(String name) {
        return name != null && (name.toLowerCase().indexOf("passwd") > -1 || name.toLowerCase().indexOf("password") > -1 || name.toLowerCase().indexOf("cookiekey") > -1);
    }

    static boolean isXMLPropertyEncrypted(String name) {
        if (securityProperties == null) {
            JiveGlobals.loadSecurityProperties();
        }
        return name != null && !name.startsWith(ENCRYPTED_PROPERTY_NAME_PREFIX) && securityProperties.getProperties(ENCRYPTED_PROPERTY_NAMES, true).contains(name);
    }

    public static boolean isPropertyEncrypted(String name) {
        if (properties == null) {
            if (JiveGlobals.isSetupMode()) {
                return false;
            }
            properties = JiveProperties.getInstance();
        }
        return properties.isEncrypted(name);
    }

    public static boolean setPropertyEncrypted(String name, boolean encrypt) {
        if (properties == null) {
            if (JiveGlobals.isSetupMode()) {
                return false;
            }
            properties = JiveProperties.getInstance();
        }
        return properties.setPropertyEncrypted(name, encrypt);
    }

    public static Encryptor getPropertyEncryptor() {
        if (securityProperties == null) {
            JiveGlobals.loadSecurityProperties();
        }
        if (propertyEncryptor == null) {
            String algorithm = securityProperties.getProperty(ENCRYPTION_ALGORITHM);
            propertyEncryptor = ENCRYPTION_ALGORITHM_AES.equalsIgnoreCase(algorithm) ? new AesEncryptor(currentKey) : new Blowfish(currentKey);
        }
        return propertyEncryptor;
    }

    public static void setupPropertyEncryptionAlgorithm(String alg) {
        String oldAlg = securityProperties.getProperty(ENCRYPTION_ALGORITHM);
        String oldKey = securityProperties.getProperty(ENCRYPTION_KEY_CURRENT);
        if (StringUtils.isNotEmpty((String)oldAlg) && !oldAlg.equals(alg) && StringUtils.isNotEmpty((String)oldKey)) {
            JiveGlobals.updateEncryptionProperties(oldAlg, oldKey, alg, oldAlg);
        }
        if (ENCRYPTION_ALGORITHM_AES.equalsIgnoreCase(alg)) {
            securityProperties.setProperty(ENCRYPTION_ALGORITHM, ENCRYPTION_ALGORITHM_AES);
        } else {
            securityProperties.setProperty(ENCRYPTION_ALGORITHM, ENCRYPTION_ALGORITHM_BLOWFISH);
        }
    }

    public static void setupPropertyEncryptionKey(String key) {
        String oldAlg = securityProperties.getProperty(ENCRYPTION_ALGORITHM);
        String oldKey = securityProperties.getProperty(ENCRYPTION_KEY_CURRENT);
        if (StringUtils.isNotEmpty((String)oldKey) && !oldKey.equals(key) && StringUtils.isNotEmpty((String)oldAlg)) {
            JiveGlobals.updateEncryptionProperties(oldAlg, oldKey, oldAlg, key);
        }
        securityProperties.setProperty(ENCRYPTION_KEY_CURRENT, new AesEncryptor().encrypt(currentKey));
    }

    private static void updateEncryptionProperties(String oldAlg, String oldKey, String newAlg, String newKey) {
        Encryptor oldEncryptor = null;
        Encryptor newEncryptor = null;
        oldEncryptor = ENCRYPTION_ALGORITHM_AES.equalsIgnoreCase(oldAlg) ? new AesEncryptor(oldKey) : new Blowfish(oldKey);
        newEncryptor = ENCRYPTION_ALGORITHM_AES.equalsIgnoreCase(newAlg) ? new AesEncryptor(newKey) : new Blowfish(newKey);
        currentKey = oldKey;
        propertyEncryptor = oldEncryptor;
        if (properties == null) {
            properties = JiveProperties.getInstance();
        }
        currentKey = newKey;
        propertyEncryptor = newEncryptor;
        Iterator<Map.Entry<String, String>> iterator = properties.entrySet().iterator();
        Map.Entry<String, String> entry = null;
        String name = null;
        while (iterator.hasNext()) {
            String xmlProperty;
            entry = iterator.next();
            name = entry.getKey();
            if (JiveGlobals.isPropertyEncrypted(name) && StringUtils.isNotEmpty((String)(xmlProperty = JiveGlobals.getXMLProperty(name)))) {
                JiveGlobals.setXMLProperty(name, entry.getValue());
            }
            properties.put(name, entry.getValue());
        }
    }

    public static void setConfigName(String configName) {
        JIVE_CONFIG_FILENAME = configName;
    }

    static String getConfigName() {
        return JIVE_CONFIG_FILENAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isSetupMode() {
        if (Boolean.valueOf(JiveGlobals.getXMLProperty("setup")).booleanValue()) {
            return false;
        }
        if (DbConnectionManager.getConnectionProvider() == null) {
            return true;
        }
        Connection con = null;
        Statement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
        }
        catch (SQLException e) {
            boolean bl = true;
            return bl;
        }
        finally {
            DbConnectionManager.closeConnection(pstmt, con);
        }
        return false;
    }

    private static synchronized void loadOpenfireProperties() {
        if (openfireProperties == null) {
            if (home == null && !failedLoading) {
                failedLoading = true;
                StringBuilder msg = new StringBuilder();
                msg.append("Critical Error! The home directory has not been configured, \n");
                msg.append("which will prevent the application from working correctly.\n\n");
                System.err.println(msg.toString());
            } else {
                try {
                    openfireProperties = new XMLProperties(home + File.separator + JiveGlobals.getConfigName());
                }
                catch (IOException ioe) {
                    Log.error(ioe.getMessage());
                    failedLoading = true;
                }
            }
            if (openfireProperties == null) {
                try {
                    openfireProperties = new XMLProperties();
                }
                catch (IOException e) {
                    Log.error("Failed to setup default openfire properties", (Throwable)e);
                }
            }
        }
    }

    private static synchronized void loadSecurityProperties() {
        if (securityProperties == null) {
            if (home == null && !failedLoading) {
                failedLoading = true;
                StringBuilder msg = new StringBuilder();
                msg.append("Critical Error! The home directory has not been configured, \n");
                msg.append("which will prevent the application from working correctly.\n\n");
                System.err.println(msg.toString());
            } else {
                try {
                    securityProperties = new XMLProperties(home + File.separator + JIVE_SECURITY_FILENAME);
                    JiveGlobals.setupPropertyEncryption();
                    TaskEngine.getInstance().schedule(new TimerTask(){

                        @Override
                        public void run() {
                            for (String propertyName : securityProperties.getAllPropertyNames()) {
                                if (propertyName.startsWith(JiveGlobals.ENCRYPTED_PROPERTY_NAME_PREFIX)) continue;
                                JiveGlobals.setPropertyEncrypted(propertyName, true);
                                securityProperties.migrateProperty(propertyName);
                            }
                        }
                    }, 1000L);
                }
                catch (IOException ioe) {
                    Log.error(ioe.getMessage());
                    failedLoading = true;
                }
            }
            if (securityProperties == null) {
                try {
                    securityProperties = new XMLProperties();
                }
                catch (IOException e) {
                    Log.error("Failed to setup default security properties", (Throwable)e);
                }
            }
        }
    }

    private static void setupPropertyEncryption() {
        AesEncryptor keyEncryptor = new AesEncryptor();
        String encryptedKey = securityProperties.getProperty(ENCRYPTION_KEY_CURRENT);
        currentKey = encryptedKey == null || encryptedKey.isEmpty() ? null : keyEncryptor.decrypt(encryptedKey);
        String newKey = securityProperties.getProperty(ENCRYPTION_KEY_NEW, false);
        if (newKey != null) {
            Log.info("Detected new encryption key; updating encrypted properties");
            String oldKey = securityProperties.getProperty(ENCRYPTION_KEY_OLD);
            if (oldKey == null) {
                if (currentKey != null) {
                    Log.warn("Old encryption key was not provided; ignoring new encryption key");
                    return;
                }
            } else if (!oldKey.equals(currentKey)) {
                Log.warn("Old encryption key does not match current encryption key; ignoring new encryption key");
                return;
            }
            if (properties == null) {
                properties = JiveProperties.getInstance();
            }
            HashMap<String, String> openfireProps = new HashMap<String, String>();
            for (String xmlProp : openfireProperties.getAllPropertyNames()) {
                if (!JiveGlobals.isPropertyEncrypted(xmlProp)) continue;
                openfireProps.put(xmlProp, openfireProperties.getProperty(xmlProp));
            }
            currentKey = newKey == null || newKey.isEmpty() ? null : newKey;
            propertyEncryptor = null;
            for (String propertyName : securityProperties.getProperties(ENCRYPTED_PROPERTY_NAMES, true)) {
                Log.info("Updating encrypted value for " + propertyName);
                if (openfireProps.containsKey(propertyName)) {
                    openfireProperties.setProperty(propertyName, (String)openfireProps.get(propertyName));
                    continue;
                }
                if (JiveGlobals.resetProperty(propertyName)) continue;
                Log.warn("Failed to reset encrypted property value for " + propertyName);
            }
            securityProperties.deleteProperty(ENCRYPTION_KEY_NEW);
            securityProperties.deleteProperty(ENCRYPTION_KEY_OLD);
        }
        securityProperties.setProperty(ENCRYPTION_KEY_CURRENT, keyEncryptor.encrypt(currentKey));
    }

    private static boolean resetProperty(String propertyName) {
        String propertyValue;
        if (properties != null && (propertyValue = properties.get(propertyName)) != null) {
            properties.remove(propertyName);
            properties.put(propertyName, propertyValue);
            return true;
        }
        return false;
    }
}

