/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.cert.CertException;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.openssl.MiscPEMGenerator;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;
import org.jivesoftware.openfire.keystore.CertificateStore;
import org.jivesoftware.openfire.keystore.CertificateUtils;
import org.jivesoftware.util.CertificateEventListener;
import org.jivesoftware.util.ClassUtils;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.cert.CNCertificateIdentityMapping;
import org.jivesoftware.util.cert.CertificateIdentityMapping;
import org.jivesoftware.util.cert.SANCertificateIdentityMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateManager {
    private static final Logger Log;
    private static Pattern valuesPattern;
    private static List<CertificateEventListener> listeners;
    private static List<CertificateIdentityMapping> serverCertMapping;
    private static List<CertificateIdentityMapping> clientCertMapping;

    public static List<String> getClientIdentities(X509Certificate x509Certificate) {
        ArrayList<String> names = new ArrayList<String>();
        for (CertificateIdentityMapping mapping : clientCertMapping) {
            List<String> identities = mapping.mapIdentity(x509Certificate);
            Log.debug("CertificateManager: " + mapping.name() + " returned " + identities.toString());
            if (identities.isEmpty()) continue;
            names.addAll(identities);
            break;
        }
        return names;
    }

    public static List<String> getServerIdentities(X509Certificate x509Certificate) {
        ArrayList<String> names = new ArrayList<String>();
        for (CertificateIdentityMapping mapping : serverCertMapping) {
            List<String> identities = mapping.mapIdentity(x509Certificate);
            Log.debug("CertificateManager: " + mapping.name() + " returned " + identities.toString());
            if (identities.isEmpty()) continue;
            names.addAll(identities);
            break;
        }
        return names;
    }

    public static boolean isSelfSignedCertificate(X509Certificate certificate) {
        try {
            certificate.verify(certificate.getPublicKey());
            return true;
        }
        catch (GeneralSecurityException e) {
            return false;
        }
    }

    public static boolean isSigningRequestPending(X509Certificate certificate) {
        if (!CertificateManager.isSelfSignedCertificate(certificate)) {
            return false;
        }
        Matcher matcher = valuesPattern.matcher(certificate.getIssuerDN().toString());
        return matcher.find() && matcher.find();
    }

    public static String createSigningRequest(X509Certificate cert, PrivateKey privKey) throws OperatorCreationException, IOException {
        JcaPKCS10CertificationRequestBuilder csrBuilder = new JcaPKCS10CertificationRequestBuilder(cert.getSubjectX500Principal(), cert.getPublicKey());
        String signatureAlgorithm = "SHA256WITH" + cert.getPublicKey().getAlgorithm();
        ContentSigner signer = new JcaContentSignerBuilder(signatureAlgorithm).build(privKey);
        PKCS10CertificationRequest csr = csrBuilder.build(signer);
        StringWriter string = new StringWriter();
        PemWriter pemWriter = new PemWriter((Writer)string);
        MiscPEMGenerator objGen = new MiscPEMGenerator((Object)csr);
        pemWriter.writeObject((PemObjectGenerator)objGen);
        pemWriter.close();
        return string.toString();
    }

    public static PrivateKey parsePrivateKey(String pemRepresentation, String passPhrase) throws IOException {
        if (pemRepresentation == null || pemRepresentation.trim().isEmpty()) {
            throw new IllegalArgumentException("Argument 'pemRepresentation' cannot be null or an empty String.");
        }
        ByteArrayInputStream input = new ByteArrayInputStream(pemRepresentation.getBytes(StandardCharsets.UTF_8));
        return CertificateManager.parsePrivateKey(input, passPhrase);
    }

    /*
     * Exception decompiling
     */
    public static PrivateKey parsePrivateKey(InputStream pemRepresentation, String passPhrase) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Collection<X509Certificate> parseCertificates(String pemRepresentation) throws IOException, CertificateException {
        String pem = pemRepresentation.replaceAll("(?m) +$", "").replaceAll("(?m)^ +", "");
        ByteArrayInputStream input = new ByteArrayInputStream(pem.getBytes(StandardCharsets.UTF_8));
        return CertificateManager.parseCertificates(input);
    }

    public static Collection<X509Certificate> parseCertificates(InputStream pemRepresentation) throws IOException, CertificateException {
        CertificateFactory certificateFactory;
        try {
            certificateFactory = CertificateFactory.getInstance("X509", "BC");
        }
        catch (NoSuchProviderException e) {
            certificateFactory = CertificateFactory.getInstance("X509");
        }
        return certificateFactory.generateCertificates(pemRepresentation);
    }

    public static void addListener(CertificateEventListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        listeners.add(listener);
    }

    public static void removeListener(CertificateEventListener listener) {
        listeners.remove(listener);
    }

    public static void fireCertificateStoreChanged(CertificateStore store) {
        for (CertificateEventListener listener : listeners) {
            try {
                listener.storeContentChanged(store);
            }
            catch (Exception e) {
                Log.error("A listener threw an exception while processing a 'store changed' event.", (Throwable)e);
            }
        }
    }

    @Deprecated
    public static List<X509Certificate> order(Collection<X509Certificate> certificates) throws CertificateException {
        return CertificateUtils.order(certificates);
    }

    public static synchronized X509Certificate createX509V3Certificate(KeyPair kp, int days, String issuerCommonName, String subjectCommonName, String domain, String signAlgoritm) throws GeneralSecurityException, IOException {
        X500NameBuilder subjectBuilder = new X500NameBuilder();
        subjectBuilder.addRDN(BCStyle.CN, subjectCommonName);
        X500NameBuilder issuerBuilder = new X500NameBuilder();
        issuerBuilder.addRDN(BCStyle.CN, issuerCommonName);
        return CertificateManager.createX509V3Certificate(kp, days, issuerBuilder, subjectBuilder, domain, signAlgoritm);
    }

    public static synchronized X509Certificate createX509V3Certificate(KeyPair kp, int days, X500NameBuilder issuerBuilder, X500NameBuilder subjectBuilder, String domain, String signAlgoritm) throws GeneralSecurityException, IOException {
        PublicKey pubKey = kp.getPublic();
        PrivateKey privKey = kp.getPrivate();
        byte[] serno = new byte[8];
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        random.setSeed(new Date().getTime());
        random.nextBytes(serno);
        BigInteger serial = new BigInteger(serno).abs();
        X500Name issuerDN = issuerBuilder.build();
        X500Name subjectDN = subjectBuilder.build();
        JcaX509v3CertificateBuilder certBuilder = new JcaX509v3CertificateBuilder(issuerDN, serial, new Date(), new Date(System.currentTimeMillis() + (long)days * 86400000L), subjectDN, pubKey);
        boolean critical = subjectDN.getRDNs().length == 0;
        DERSequence othernameSequence = new DERSequence(new ASN1Encodable[]{new ASN1ObjectIdentifier("1.3.6.1.5.5.7.8.5"), new DERUTF8String(domain)});
        GeneralName othernameGN = new GeneralName(0, (ASN1Encodable)othernameSequence);
        GeneralNames subjectAltNames = new GeneralNames(new GeneralName[]{othernameGN});
        certBuilder.addExtension(Extension.subjectAlternativeName, critical, (ASN1Encodable)subjectAltNames);
        JcaX509ExtensionUtils utils = new JcaX509ExtensionUtils();
        certBuilder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)utils.createSubjectKeyIdentifier(pubKey));
        certBuilder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)utils.createAuthorityKeyIdentifier(pubKey));
        try {
            ContentSigner signer = new JcaContentSignerBuilder(signAlgoritm).build(privKey);
            X509CertificateHolder cert = certBuilder.build(signer);
            if (!cert.isValidOn(new Date())) {
                throw new GeneralSecurityException("Certificate validity not valid");
            }
            ContentVerifierProvider verifierProvider = new JcaContentVerifierProviderBuilder().build(pubKey);
            if (!cert.isSignatureValid(verifierProvider)) {
                throw new GeneralSecurityException("Certificate signature not valid");
            }
            return new JcaX509CertificateConverter().getCertificate(cert);
        }
        catch (CertException | OperatorCreationException e) {
            throw new GeneralSecurityException(e);
        }
    }

    static {
        String clientCertMapList;
        Log = LoggerFactory.getLogger(CertificateManager.class);
        valuesPattern = Pattern.compile("(?i)(=)([^,]*)");
        listeners = new CopyOnWriteArrayList<CertificateEventListener>();
        serverCertMapping = new ArrayList<CertificateIdentityMapping>();
        clientCertMapping = new ArrayList<CertificateIdentityMapping>();
        String serverCertIdentityMapList = JiveGlobals.getProperty("provider.serverCertIdentityMap.classList");
        if (serverCertIdentityMapList != null) {
            StringTokenizer st = new StringTokenizer(serverCertIdentityMapList, " ,\t\n\r\f");
            while (st.hasMoreTokens()) {
                String s_provider = st.nextToken();
                try {
                    Class c_provider = ClassUtils.forName(s_provider);
                    CertificateIdentityMapping provider = (CertificateIdentityMapping)c_provider.newInstance();
                    Log.debug("CertificateManager: Loaded server identity mapping " + s_provider);
                    serverCertMapping.add(provider);
                }
                catch (Exception e) {
                    Log.error("CertificateManager: Error loading CertificateIdentityMapping: " + s_provider + "\n" + e);
                }
            }
        }
        if (serverCertMapping.isEmpty()) {
            Log.debug("CertificateManager: No server CertificateIdentityMapping's found. Loading default mappings");
            serverCertMapping.add(new SANCertificateIdentityMapping());
            serverCertMapping.add(new CNCertificateIdentityMapping());
        }
        if ((clientCertMapList = JiveGlobals.getProperty("provider.clientCertIdentityMap.classList")) != null) {
            StringTokenizer st = new StringTokenizer(clientCertMapList, " ,\t\n\r\f");
            while (st.hasMoreTokens()) {
                String s_provider = st.nextToken();
                try {
                    Class c_provider = ClassUtils.forName(s_provider);
                    CertificateIdentityMapping provider = (CertificateIdentityMapping)c_provider.newInstance();
                    Log.debug("CertificateManager: Loaded client identity mapping " + s_provider);
                    clientCertMapping.add(provider);
                }
                catch (Exception e) {
                    Log.error("CertificateManager: Error loading CertificateIdentityMapping: " + s_provider + "\n" + e);
                }
            }
        }
        if (clientCertMapping.isEmpty()) {
            Log.debug("CertificateManager: No client CertificateIdentityMapping's found. Loading default mappings");
            clientCertMapping.add(new CNCertificateIdentityMapping());
        }
    }
}

