/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.websocket;

import java.text.MessageFormat;
import org.eclipse.jetty.websocket.common.extensions.compress.PerMessageDeflateExtension;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.session.ClientSession;
import org.jivesoftware.openfire.session.LocalSession;
import org.jivesoftware.openfire.websocket.XmppWebSocket;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenfireWebSocketServlet
extends WebSocketServlet {
    private static final long serialVersionUID = 7281841492829464605L;
    private static final Logger Log = LoggerFactory.getLogger(OpenfireWebSocketServlet.class);

    public void destroy() {
        SessionManager sm = XMPPServer.getInstance().getSessionManager();
        for (ClientSession session : sm.getSessions()) {
            Object ws;
            if (!(session instanceof LocalSession) || (ws = ((LocalSession)((Object)session)).getSessionData("ws")) == null || !((Boolean)ws).booleanValue()) continue;
            session.close();
        }
        super.destroy();
    }

    public void configure(WebSocketServletFactory factory) {
        if (XmppWebSocket.isCompressionEnabled()) {
            factory.getExtensionFactory().register("permessage-deflate", PerMessageDeflateExtension.class);
        }
        int messageSize = JiveGlobals.getIntProperty("xmpp.parser.buffer.size", 0x100000);
        factory.getPolicy().setMaxTextMessageBufferSize(messageSize * 5);
        factory.getPolicy().setMaxTextMessageSize(messageSize);
        factory.setCreator(new WebSocketCreator(){

            public Object createWebSocket(ServletUpgradeRequest req, ServletUpgradeResponse resp) {
                try {
                    for (String subprotocol : req.getSubProtocols()) {
                        if (!"xmpp".equals(subprotocol)) continue;
                        resp.setAcceptedSubProtocol(subprotocol);
                        return new XmppWebSocket();
                    }
                }
                catch (Exception e) {
                    Log.warn(MessageFormat.format("Unable to load websocket factory: {0} ({1})", e.getClass().getName(), e.getMessage()));
                }
                Log.warn("Failed to create websocket for {}:{} make a request at {}", new Object[]{req.getRemoteAddress(), req.getRemotePort(), req.getRequestPath()});
                return null;
            }
        });
    }
}

