/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.user.property;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.user.property.UserPropertyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUserPropertyProvider
implements UserPropertyProvider {
    private static final Logger Log = LoggerFactory.getLogger(DefaultUserPropertyProvider.class);
    private static final String LOAD_PROPERTIES = "SELECT name, propValue FROM ofUserProp WHERE username=?";
    private static final String LOAD_PROPERTY = "SELECT propValue FROM ofUserProp WHERE username=? AND name=?";
    private static final String DELETE_PROPERTY = "DELETE FROM ofUserProp WHERE username=? AND name=?";
    private static final String UPDATE_PROPERTY = "UPDATE ofUserProp SET propValue=? WHERE name=? AND username=?";
    private static final String INSERT_PROPERTY = "INSERT INTO ofUserProp (username, name, propValue) VALUES (?, ?, ?)";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> loadProperties(String username) {
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ConcurrentHashMap<String, String> properties = new ConcurrentHashMap<String, String>();
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(LOAD_PROPERTIES);
            pstmt.setString(1, username);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                properties.put(rs.getString(1), rs.getString(2));
            }
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        catch (SQLException sqle) {
            Log.error(sqle.getMessage(), (Throwable)sqle);
        }
        finally {
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String loadProperty(String username, String propertyName) {
        String propertyValue = null;
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(LOAD_PROPERTY);
            pstmt.setString(1, username);
            pstmt.setString(2, propertyName);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                propertyValue = rs.getString(1);
            }
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        catch (SQLException sqle) {
            Log.error(sqle.getMessage(), (Throwable)sqle);
        }
        finally {
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        return propertyValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertProperty(String username, String propName, String propValue) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(INSERT_PROPERTY);
            pstmt.setString(1, username);
            pstmt.setString(2, propName);
            pstmt.setString(3, propValue);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                Log.error(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
        DbConnectionManager.closeConnection(pstmt, con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateProperty(String username, String propName, String propValue) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(UPDATE_PROPERTY);
            pstmt.setString(1, propValue);
            pstmt.setString(2, propName);
            pstmt.setString(3, username);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                Log.error(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
        DbConnectionManager.closeConnection(pstmt, con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteProperty(String username, String propName) {
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(DELETE_PROPERTY);
            pstmt.setString(1, username);
            pstmt.setString(2, propName);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                Log.error(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
        DbConnectionManager.closeConnection(pstmt, con);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }
}

