/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.user;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.AuthFactory;
import org.jivesoftware.openfire.auth.ConnectionException;
import org.jivesoftware.openfire.auth.InternalUnauthenticatedException;
import org.jivesoftware.openfire.event.UserEventDispatcher;
import org.jivesoftware.openfire.roster.Roster;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.StringUtils;
import org.jivesoftware.util.cache.CacheSizes;
import org.jivesoftware.util.cache.Cacheable;
import org.jivesoftware.util.cache.CannotCalculateSizeException;
import org.jivesoftware.util.cache.ExternalizableUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.resultsetmanagement.Result;

public class User
implements Cacheable,
Externalizable,
Result {
    private static final Logger Log = LoggerFactory.getLogger(User.class);
    private static final String NAME_VISIBLE_PROPERTY = "name.visible";
    private static final String EMAIL_VISIBLE_PROPERTY = "email.visible";
    private String username;
    private String salt;
    private String storedKey;
    private String serverKey;
    private int iterations;
    private String name;
    private String email;
    private Date creationDate;
    private Date modificationDate;
    private Map<String, String> properties = null;

    public static String getPropertyValue(String username, String propertyName) throws UserNotFoundException {
        return UserManager.getUserPropertyProvider().loadProperty(username, propertyName);
    }

    public User() {
    }

    public User(String username, String name, String email, Date creationDate, Date modificationDate) {
        if (username == null) {
            throw new NullPointerException("Username cannot be null");
        }
        this.username = username;
        if (UserManager.getUserProvider().isNameRequired() && (name == null || "".equals(name.trim()))) {
            throw new IllegalArgumentException("Invalid or empty name specified with provider that requires name");
        }
        this.name = name;
        if (UserManager.getUserProvider().isEmailRequired() && (email == null || "".equals(email.trim()))) {
            throw new IllegalArgumentException("Empty email address specified with provider that requires email address. User: " + username + " Email: " + email);
        }
        this.email = email;
        this.creationDate = creationDate;
        this.modificationDate = modificationDate;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String password) throws UnsupportedOperationException {
        if (UserManager.getUserProvider().isReadOnly()) {
            throw new UnsupportedOperationException("User provider is read-only.");
        }
        try {
            AuthFactory.setPassword(this.username, password);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("type", "passwordModified");
            UserEventDispatcher.dispatchEvent(this, UserEventDispatcher.EventType.user_modified, params);
        }
        catch (ConnectionException | InternalUnauthenticatedException | UserNotFoundException e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
    }

    public String getStoredKey() {
        return this.storedKey;
    }

    public void setStoredKey(String storedKey) {
        this.storedKey = storedKey;
    }

    public String getServerKey() {
        return this.serverKey;
    }

    public void setServerKey(String serverKey) {
        this.serverKey = serverKey;
    }

    public String getSalt() {
        return this.salt;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public int getIterations() {
        return this.iterations;
    }

    public void setIterations(int iterations) {
        this.iterations = iterations;
    }

    public String getName() {
        return this.name == null ? "" : this.name;
    }

    public void setName(String name) {
        if (UserManager.getUserProvider().isReadOnly()) {
            throw new UnsupportedOperationException("User provider is read-only.");
        }
        if (name != null && name.matches("\\s*")) {
            name = null;
        }
        if (name == null && UserManager.getUserProvider().isNameRequired()) {
            throw new IllegalArgumentException("User provider requires name.");
        }
        try {
            String originalName = this.name;
            UserManager.getUserProvider().setName(this.username, name);
            this.name = name;
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("type", "nameModified");
            params.put("originalValue", originalName);
            UserEventDispatcher.dispatchEvent(this, UserEventDispatcher.EventType.user_modified, params);
        }
        catch (UserNotFoundException unfe) {
            Log.error(unfe.getMessage(), (Throwable)unfe);
        }
    }

    public boolean isNameVisible() {
        return !this.getProperties().containsKey(NAME_VISIBLE_PROPERTY) || Boolean.valueOf(this.getProperties().get(NAME_VISIBLE_PROPERTY)) != false;
    }

    public void setNameVisible(boolean visible) {
        this.getProperties().put(NAME_VISIBLE_PROPERTY, String.valueOf(visible));
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        if (UserManager.getUserProvider().isReadOnly()) {
            throw new UnsupportedOperationException("User provider is read-only.");
        }
        if (email != null && email.matches("\\s*")) {
            email = null;
        }
        if (UserManager.getUserProvider().isEmailRequired() && !StringUtils.isValidEmailAddress(email)) {
            throw new IllegalArgumentException("User provider requires email address.");
        }
        try {
            String originalEmail = this.email;
            UserManager.getUserProvider().setEmail(this.username, email);
            this.email = email;
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("type", "emailModified");
            params.put("originalValue", originalEmail);
            UserEventDispatcher.dispatchEvent(this, UserEventDispatcher.EventType.user_modified, params);
        }
        catch (UserNotFoundException unfe) {
            Log.error(unfe.getMessage(), (Throwable)unfe);
        }
    }

    public boolean isEmailVisible() {
        return !this.getProperties().containsKey(EMAIL_VISIBLE_PROPERTY) || Boolean.valueOf(this.getProperties().get(EMAIL_VISIBLE_PROPERTY)) != false;
    }

    public void setEmailVisible(boolean visible) {
        this.getProperties().put(EMAIL_VISIBLE_PROPERTY, String.valueOf(visible));
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        if (UserManager.getUserProvider().isReadOnly()) {
            throw new UnsupportedOperationException("User provider is read-only.");
        }
        try {
            Date originalCreationDate = this.creationDate;
            UserManager.getUserProvider().setCreationDate(this.username, creationDate);
            this.creationDate = creationDate;
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("type", "creationDateModified");
            params.put("originalValue", originalCreationDate);
            UserEventDispatcher.dispatchEvent(this, UserEventDispatcher.EventType.user_modified, params);
        }
        catch (UserNotFoundException unfe) {
            Log.error(unfe.getMessage(), (Throwable)unfe);
        }
    }

    public Date getModificationDate() {
        return this.modificationDate;
    }

    public void setModificationDate(Date modificationDate) {
        if (UserManager.getUserProvider().isReadOnly()) {
            throw new UnsupportedOperationException("User provider is read-only.");
        }
        try {
            Date originalModificationDate = this.modificationDate;
            UserManager.getUserProvider().setCreationDate(this.username, modificationDate);
            this.modificationDate = modificationDate;
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("type", "nameModified");
            params.put("originalValue", originalModificationDate);
            UserEventDispatcher.dispatchEvent(this, UserEventDispatcher.EventType.user_modified, params);
        }
        catch (UserNotFoundException unfe) {
            Log.error(unfe.getMessage(), (Throwable)unfe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getProperties() {
        User user = this;
        synchronized (user) {
            if (this.properties == null) {
                try {
                    this.properties = UserManager.getUserPropertyProvider().loadProperties(this.username);
                }
                catch (UserNotFoundException e) {
                    Log.error("Unable to retrieve properties for user " + this.username, (Throwable)e);
                }
            }
        }
        return new PropertiesMap();
    }

    public Roster getRoster() {
        try {
            return XMPPServer.getInstance().getRosterManager().getRoster(this.username);
        }
        catch (UserNotFoundException unfe) {
            Log.error(unfe.getMessage(), (Throwable)unfe);
            return null;
        }
    }

    @Override
    public int getCachedSize() throws CannotCalculateSizeException {
        int size = 0;
        size += CacheSizes.sizeOfObject();
        size += CacheSizes.sizeOfLong();
        size += CacheSizes.sizeOfString(this.username);
        size += CacheSizes.sizeOfString(this.name);
        size += CacheSizes.sizeOfString(this.email);
        size += CacheSizes.sizeOfDate() * 2;
        return size += CacheSizes.sizeOfMap(this.properties);
    }

    public String toString() {
        return this.username;
    }

    public int hashCode() {
        return this.username.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof User) {
            return this.username.equals(((User)object).getUsername());
        }
        return false;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ExternalizableUtil.getInstance().writeSafeUTF(out, this.username);
        ExternalizableUtil.getInstance().writeSafeUTF(out, this.getName());
        ExternalizableUtil.getInstance().writeBoolean(out, this.email != null);
        if (this.email != null) {
            ExternalizableUtil.getInstance().writeSafeUTF(out, this.email);
        }
        ExternalizableUtil.getInstance().writeLong(out, this.creationDate.getTime());
        ExternalizableUtil.getInstance().writeLong(out, this.modificationDate.getTime());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.username = ExternalizableUtil.getInstance().readSafeUTF(in);
        this.name = ExternalizableUtil.getInstance().readSafeUTF(in);
        if (ExternalizableUtil.getInstance().readBoolean(in)) {
            this.email = ExternalizableUtil.getInstance().readSafeUTF(in);
        }
        this.creationDate = new Date(ExternalizableUtil.getInstance().readLong(in));
        this.modificationDate = new Date(ExternalizableUtil.getInstance().readLong(in));
    }

    public String getUID() {
        return this.username;
    }

    private class PropertiesEntrySet
    extends AbstractSet<Map.Entry<String, String>> {
        private PropertiesEntrySet() {
        }

        @Override
        public int size() {
            return User.this.properties.entrySet().size();
        }

        @Override
        public Iterator<Map.Entry<String, String>> iterator() {
            return new Iterator<Map.Entry<String, String>>(){
                Iterator<Map.Entry<String, String>> iter;
                Map.Entry<String, String> current;
                {
                    this.iter = User.this.properties.entrySet().iterator();
                    this.current = null;
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public Map.Entry<String, String> next() {
                    this.current = this.iter.next();
                    return this.current;
                }

                @Override
                public void remove() {
                    if (this.current == null) {
                        throw new IllegalStateException();
                    }
                    String key = this.current.getKey();
                    try {
                        UserManager.getUserPropertyProvider().deleteProperty(User.this.username, key);
                        this.iter.remove();
                        HashMap<String, Object> params = new HashMap<String, Object>();
                        params.put("type", "propertyDeleted");
                        params.put("propertyKey", key);
                        UserEventDispatcher.dispatchEvent(User.this, UserEventDispatcher.EventType.user_modified, params);
                    }
                    catch (UserNotFoundException e) {
                        Log.error("Unable to delete property for user " + User.this.username, (Throwable)e);
                    }
                }
            };
        }
    }

    private class PropertiesMap
    extends AbstractMap<String, String> {
        private PropertiesMap() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String put(String key, String value) {
            HashMap<String, Object> eventParams = new HashMap<String, Object>();
            String keyString = key;
            try {
                String answer;
                String string = (User.this.getName() + keyString).intern();
                synchronized (string) {
                    if (User.this.properties.containsKey(keyString)) {
                        String originalValue = (String)User.this.properties.get(keyString);
                        answer = User.this.properties.put(keyString, value);
                        UserManager.getUserPropertyProvider().updateProperty(User.this.username, keyString, value);
                        eventParams.put("type", "propertyModified");
                        eventParams.put("propertyKey", key);
                        eventParams.put("originalValue", originalValue);
                    } else {
                        answer = User.this.properties.put(keyString, value);
                        UserManager.getUserPropertyProvider().insertProperty(User.this.username, keyString, value);
                        eventParams.put("type", "propertyAdded");
                        eventParams.put("propertyKey", key);
                    }
                }
                UserEventDispatcher.dispatchEvent(User.this, UserEventDispatcher.EventType.user_modified, eventParams);
                return answer;
            }
            catch (UserNotFoundException e) {
                Log.error("Unable to put property for user " + User.this.username, (Throwable)e);
                return null;
            }
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            return new PropertiesEntrySet();
        }
    }
}

