/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.streammanagement;

import java.math.BigInteger;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Deque;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.dom.DOMElement;
import org.jivesoftware.openfire.Connection;
import org.jivesoftware.openfire.PacketRouter;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.AuthToken;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.session.ClientSession;
import org.jivesoftware.openfire.session.LocalClientSession;
import org.jivesoftware.openfire.session.LocalSession;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.StringUtils;
import org.jivesoftware.util.XMPPDateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;
import org.xmpp.packet.PacketError;
import org.xmpp.packet.Presence;

public class StreamManager {
    private final Logger Log;
    private boolean resume = false;
    public static final String SM_ACTIVE = "stream.management.active";
    public static final String NAMESPACE_V2 = "urn:xmpp:sm:2";
    public static final String NAMESPACE_V3 = "urn:xmpp:sm:3";
    private final LocalSession session;
    private String namespace;
    private long serverProcessedStanzas = 0L;
    private long clientProcessedStanzas = 0L;
    private static long mask = new BigInteger("2").pow(32).longValue() - 1L;
    private Deque<UnackedPacket> unacknowledgedServerStanzas = new LinkedList<UnackedPacket>();

    public StreamManager(LocalSession session) {
        String address;
        try {
            address = session.getConnection().getHostAddress();
        }
        catch (UnknownHostException e) {
            address = null;
        }
        this.Log = LoggerFactory.getLogger((String)(StreamManager.class + "[" + (address == null ? "(unknown address)" : address) + "]"));
        this.session = session;
    }

    public boolean getResume() {
        return this.resume;
    }

    public void process(Element element) {
        switch (element.getName()) {
            case "enable": {
                String resumeString = element.attributeValue("resume");
                boolean resume = false;
                if (resumeString != null && (resumeString.equalsIgnoreCase("true") || resumeString.equalsIgnoreCase("yes") || resumeString.equals("1"))) {
                    resume = true;
                }
                this.enable(element.getNamespace().getStringValue(), resume);
                break;
            }
            case "resume": {
                long h = new Long(element.attributeValue("h"));
                String previd = element.attributeValue("previd");
                this.startResume(element.getNamespaceURI(), previd, h);
                break;
            }
            case "r": {
                this.sendServerAcknowledgement();
                break;
            }
            case "a": {
                this.processClientAcknowledgement(element);
                break;
            }
            default: {
                this.sendUnexpectedError();
            }
        }
    }

    private boolean allowResume() {
        AuthToken authToken;
        boolean allow = false;
        if (this.session instanceof ClientSession && (authToken = ((LocalClientSession)this.session).getAuthToken()) != null && !authToken.isAnonymous()) {
            allow = true;
        }
        return allow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enable(String namespace, boolean resume) {
        boolean offerResume = this.allowResume();
        if (this.session.getStatus() != 3) {
            this.namespace = namespace;
            this.sendUnexpectedError();
            return;
        }
        String smId = null;
        StreamManager streamManager = this;
        synchronized (streamManager) {
            if (this.isEnabled()) {
                this.sendUnexpectedError();
                return;
            }
            this.namespace = namespace;
            boolean bl = this.resume = resume && offerResume;
            if (this.resume) {
                smId = StringUtils.encodeBase64(this.session.getAddress().getResource() + "\u0000" + this.session.getStreamID().getID());
            }
        }
        DOMElement enabled = new DOMElement(QName.get((String)"enabled", (String)namespace));
        if (this.resume) {
            enabled.addAttribute("resume", "true");
            enabled.addAttribute("id", smId);
        }
        this.session.deliverRawText(enabled.asXML());
    }

    private void startResume(String namespace, String previd, long h) {
        String streamId;
        String resource;
        this.Log.debug("Attempting resumption for {}, h={}", (Object)previd, (Object)h);
        this.namespace = namespace;
        if (!this.allowResume()) {
            this.sendUnexpectedError();
            return;
        }
        if (this.session.getStatus() == 3) {
            this.sendUnexpectedError();
            return;
        }
        AuthToken authToken = null;
        if (this.session instanceof ClientSession) {
            authToken = ((LocalClientSession)this.session).getAuthToken();
        }
        if (authToken == null) {
            this.sendUnexpectedError();
            return;
        }
        try {
            StringTokenizer toks = new StringTokenizer(new String(StringUtils.decodeBase64(previd), StandardCharsets.UTF_8), "\u0000");
            resource = toks.nextToken();
            streamId = toks.nextToken();
        }
        catch (Exception e) {
            this.Log.debug("Exception from previd decode:", (Throwable)e);
            this.sendUnexpectedError();
            return;
        }
        JID fullJid = new JID(authToken.getUsername(), authToken.getDomain(), resource, true);
        this.Log.debug("Resuming session {}", (Object)fullJid);
        LocalClientSession otherSession = (LocalClientSession)XMPPServer.getInstance().getRoutingTable().getClientRoute(fullJid);
        if (otherSession == null) {
            this.sendError(new PacketError(PacketError.Condition.item_not_found));
            return;
        }
        if (!otherSession.getStreamID().getID().equals(streamId)) {
            this.sendError(new PacketError(PacketError.Condition.item_not_found));
            return;
        }
        this.Log.debug("Found existing session, checking status");
        if (!otherSession.getStreamManager().namespace.equals(namespace)) {
            this.sendError(new PacketError(PacketError.Condition.unexpected_request));
            return;
        }
        if (!otherSession.getStreamManager().resume) {
            this.sendError(new PacketError(PacketError.Condition.unexpected_request));
            return;
        }
        if (!otherSession.isDetached()) {
            this.Log.debug("Existing session is not detached; detaching.");
            Connection oldConnection = otherSession.getConnection();
            otherSession.setDetached();
            oldConnection.close();
        }
        this.Log.debug("Attaching to other session.");
        Connection conn = this.session.getConnection();
        this.session.setDetached();
        otherSession.reattach(conn, h);
        this.session.close();
    }

    public void formalClose() {
        this.resume = false;
    }

    public void sendServerAcknowledgement() {
        if (this.isEnabled()) {
            if (this.session.isDetached()) {
                this.Log.debug("Session is detached, won't request an ack.");
                return;
            }
            String ack = String.format("<a xmlns='%s' h='%s' />", this.namespace, this.serverProcessedStanzas & mask);
            this.session.deliverRawText(ack);
        }
    }

    private void sendServerRequest() {
        if (this.isEnabled()) {
            if (this.session.isDetached()) {
                this.Log.debug("Session is detached, won't request an ack.");
                return;
            }
            String request = String.format("<r xmlns='%s' />", this.namespace);
            this.session.deliverRawText(request);
        }
    }

    private void sendUnexpectedError() {
        this.sendError(new PacketError(PacketError.Condition.unexpected_request));
    }

    private void sendError(PacketError error) {
        this.session.deliverRawText(String.format("<failed xmlns='%s'>", this.namespace) + String.format("<%s xmlns='urn:ietf:params:xml:ns:xmpp-stanzas'/>", error.getCondition().toXMPP()) + "</failed>");
        this.namespace = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processClientAcknowledgement(long h) {
        StreamManager streamManager = this;
        synchronized (streamManager) {
            boolean clientHadRollOver;
            if (!this.unacknowledgedServerStanzas.isEmpty() && h > this.unacknowledgedServerStanzas.getLast().x) {
                this.Log.warn("Client acknowledges stanzas that we didn't send! Client Ack h: {}, our last stanza: {}", (Object)h, (Object)this.unacknowledgedServerStanzas.getLast().x);
            }
            this.clientProcessedStanzas = h;
            this.Log.trace("Before processing client Ack (h={}): {} unacknowledged stanzas.", (Object)h, (Object)this.unacknowledgedServerStanzas.size());
            while (!this.unacknowledgedServerStanzas.isEmpty() && this.unacknowledgedServerStanzas.getFirst().x <= h) {
                this.unacknowledgedServerStanzas.removeFirst();
            }
            int maxUnacked = this.getMaximumUnacknowledgedStanzas();
            boolean bl = clientHadRollOver = h < (long)maxUnacked && !this.unacknowledgedServerStanzas.isEmpty() && this.unacknowledgedServerStanzas.getLast().x > mask - (long)maxUnacked;
            if (clientHadRollOver) {
                this.Log.info("Client rolled over 'h'. Purging high-numbered unacknowledged stanzas.");
                while (!this.unacknowledgedServerStanzas.isEmpty() && this.unacknowledgedServerStanzas.getLast().x > mask - (long)maxUnacked) {
                    this.unacknowledgedServerStanzas.removeLast();
                }
            }
            this.Log.trace("After processing client Ack (h={}): {} unacknowledged stanzas.", (Object)h, (Object)this.unacknowledgedServerStanzas.size());
        }
    }

    private void processClientAcknowledgement(Element ack) {
        if (this.isEnabled() && ack.attribute("h") != null) {
            long h = Long.valueOf(ack.attributeValue("h"));
            this.Log.debug("Received acknowledgement from client: h={}", (Object)h);
            this.processClientAcknowledgement(h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sentStanza(Packet packet) {
        if (this.isEnabled()) {
            int size;
            long requestFrequency = JiveGlobals.getLongProperty("stream.management.requestFrequency", 5L);
            StreamManager streamManager = this;
            synchronized (streamManager) {
                long x = 1L + (this.unacknowledgedServerStanzas.isEmpty() ? this.clientProcessedStanzas : this.unacknowledgedServerStanzas.getLast().x);
                this.unacknowledgedServerStanzas.addLast(new UnackedPacket(x, packet.createCopy()));
                size = this.unacknowledgedServerStanzas.size();
                this.Log.trace("Added stanza of type '{}' to collection of unacknowledged stanzas (x={}). Collection size is now {}.", new Object[]{packet.getElement().getName(), x, size});
                if (size > this.getMaximumUnacknowledgedStanzas()) {
                    this.Log.warn("To many stanzas go unacknowledged for this connection. Clearing queue and disabling functionality.");
                    this.namespace = null;
                    this.unacknowledgedServerStanzas.clear();
                    return;
                }
            }
            if ((long)size % requestFrequency == 0L) {
                this.Log.debug("Requesting acknowledgement from peer, as we have {} or more unacknowledged stanzas.", (Object)requestFrequency);
                this.sendServerRequest();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClose(PacketRouter router, JID serverAddress) {
        StreamManager streamManager = this;
        synchronized (streamManager) {
            if (this.isEnabled()) {
                this.namespace = null;
                for (UnackedPacket unacked : this.unacknowledgedServerStanzas) {
                    if (!(unacked.packet instanceof Message)) continue;
                    Message m = (Message)unacked.packet;
                    if (m.getExtension("delay", "urn:xmpp:delay") == null) {
                        Element delayInformation = m.addChildElement("delay", "urn:xmpp:delay");
                        delayInformation.addAttribute("stamp", XMPPDateTimeFormat.format(unacked.timestamp));
                        delayInformation.addAttribute("from", serverAddress.toBareJID());
                    }
                    router.route(unacked.packet);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResume(JID serverAddress, long h) {
        this.Log.debug("Agreeing to resume");
        DOMElement resumed = new DOMElement(QName.get((String)"resumed", (String)this.namespace));
        resumed.addAttribute("previd", StringUtils.encodeBase64(this.session.getAddress().getResource() + "\u0000" + this.session.getStreamID().getID()));
        resumed.addAttribute("h", Long.toString(this.serverProcessedStanzas));
        this.session.getConnection().deliverRawText(resumed.asXML());
        this.Log.debug("Resuming session: Ack for {}", (Object)h);
        this.processClientAcknowledgement(h);
        this.Log.debug("Processing remaining unacked stanzas");
        StreamManager streamManager = this;
        synchronized (streamManager) {
            if (this.isEnabled()) {
                for (UnackedPacket unacked : this.unacknowledgedServerStanzas) {
                    try {
                        Element delayInformation;
                        if (unacked.packet instanceof Message) {
                            Message m = (Message)unacked.packet;
                            if (m.getExtension("delay", "urn:xmpp:delay") == null) {
                                delayInformation = m.addChildElement("delay", "urn:xmpp:delay");
                                delayInformation.addAttribute("stamp", XMPPDateTimeFormat.format(unacked.timestamp));
                                delayInformation.addAttribute("from", serverAddress.toBareJID());
                            }
                            this.session.getConnection().deliver((Packet)m);
                            continue;
                        }
                        if (unacked.packet instanceof Presence) {
                            Presence p = (Presence)unacked.packet;
                            if (p.getExtension("delay", "urn:xmpp:delay") == null) {
                                delayInformation = p.addChildElement("delay", "urn:xmpp:delay");
                                delayInformation.addAttribute("stamp", XMPPDateTimeFormat.format(unacked.timestamp));
                                delayInformation.addAttribute("from", serverAddress.toBareJID());
                            }
                            this.session.getConnection().deliver((Packet)p);
                            continue;
                        }
                        this.session.getConnection().deliver(unacked.packet);
                    }
                    catch (UnauthorizedException e) {
                        this.Log.warn("Caught unauthorized exception, which seems worrying: ", (Throwable)e);
                    }
                }
                this.sendServerRequest();
            }
        }
    }

    public boolean isEnabled() {
        return this.namespace != null;
    }

    public void incrementServerProcessedStanzas() {
        if (this.isEnabled()) {
            ++this.serverProcessedStanzas;
        }
    }

    private int getMaximumUnacknowledgedStanzas() {
        return JiveGlobals.getIntProperty("stream.management.max-unacked", 10000);
    }

    public static class UnackedPacket {
        public final long x;
        public final Date timestamp = new Date();
        public final Packet packet;

        public UnackedPacket(long x, Packet p) {
            this.x = x;
            this.packet = p;
        }
    }
}

