/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.spi;

import org.jivesoftware.openfire.PacketDeliverer;
import org.jivesoftware.openfire.PacketException;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.container.BasicModule;
import org.jivesoftware.openfire.net.SocketPacketWriteHandler;
import org.xmpp.packet.Packet;

public class PacketDelivererImpl
extends BasicModule
implements PacketDeliverer {
    protected SocketPacketWriteHandler deliverHandler;

    public PacketDelivererImpl() {
        super("Packet Delivery");
    }

    @Override
    public void deliver(Packet packet) throws UnauthorizedException, PacketException {
        if (packet == null) {
            throw new PacketException("Packet was null");
        }
        if (this.deliverHandler == null) {
            throw new PacketException("Could not send packet - no route" + packet.toString());
        }
        this.deliverHandler.process(packet);
    }

    @Override
    public void start() throws IllegalStateException {
        super.start();
        this.deliverHandler = new SocketPacketWriteHandler(XMPPServer.getInstance().getRoutingTable());
    }

    @Override
    public void stop() {
        super.stop();
        this.deliverHandler = null;
    }
}

