/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.spi;

import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import org.apache.mina.filter.ssl.SslFilter;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.jivesoftware.openfire.keystore.OpenfireX509TrustManager;
import org.jivesoftware.openfire.spi.ConnectionConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptionArtifactFactory {
    private final Logger Log = LoggerFactory.getLogger(EncryptionArtifactFactory.class);
    private final ConnectionConfiguration configuration;
    private transient KeyManagerFactory keyManagerFactory;
    private transient SslContextFactory sslContextFactory;

    public EncryptionArtifactFactory(ConnectionConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("Argument 'configuration' cannot be null");
        }
        this.configuration = configuration;
    }

    public synchronized KeyManager[] getKeyManagers() throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException {
        try {
            if (this.keyManagerFactory == null) {
                this.keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                this.keyManagerFactory.init(this.configuration.getIdentityStore().getStore(), this.configuration.getIdentityStoreConfiguration().getPassword());
            }
            return this.keyManagerFactory.getKeyManagers();
        }
        catch (RuntimeException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException ex) {
            this.keyManagerFactory = null;
            throw ex;
        }
    }

    public synchronized TrustManager[] getTrustManagers() throws KeyStoreException, NoSuchAlgorithmException {
        return new TrustManager[]{new OpenfireX509TrustManager(this.configuration.getTrustStore().getStore(), this.configuration.isAcceptSelfSignedCertificates(), this.configuration.isVerifyCertificateValidity())};
    }

    public synchronized SSLContext getSSLContext() throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        SSLContext sslContext = SSLContext.getInstance("TLSv1");
        sslContext.init(this.getKeyManagers(), this.getTrustManagers(), new SecureRandom());
        return sslContext;
    }

    private SSLEngine createSSLEngine() throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        Set<String> cipherSuites;
        SSLContext sslContext = this.getSSLContext();
        SSLEngine sslEngine = sslContext.createSSLEngine();
        Set<String> protocols = this.configuration.getEncryptionProtocols();
        if (!protocols.isEmpty()) {
            sslEngine.setEnabledProtocols(protocols.toArray(new String[protocols.size()]));
        }
        if (!(cipherSuites = this.configuration.getEncryptionCipherSuites()).isEmpty()) {
            sslEngine.setEnabledCipherSuites(cipherSuites.toArray(new String[cipherSuites.size()]));
        }
        return sslEngine;
    }

    public SSLEngine createServerModeSSLEngine() throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        SSLEngine sslEngine = this.createSSLEngine();
        sslEngine.setUseClientMode(false);
        switch (this.configuration.getClientAuth()) {
            case needed: {
                sslEngine.setNeedClientAuth(true);
                break;
            }
            case wanted: {
                sslEngine.setWantClientAuth(true);
                break;
            }
            case disabled: {
                sslEngine.setWantClientAuth(false);
            }
        }
        return sslEngine;
    }

    public SSLEngine createClientModeSSLEngine() throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        SSLEngine sslEngine = this.createSSLEngine();
        sslEngine.setUseClientMode(true);
        LinkedHashSet<String> protocols = new LinkedHashSet<String>(Arrays.asList(sslEngine.getEnabledProtocols()));
        protocols.remove("SSLv2Hello");
        sslEngine.setEnabledProtocols(protocols.toArray(new String[protocols.size()]));
        return sslEngine;
    }

    public synchronized SslContextFactory getSslContextFactory() {
        if (this.sslContextFactory != null) {
            return this.sslContextFactory;
        }
        this.Log.info("Creating new SslContextFactory instance");
        try {
            Set<String> cipherSuites;
            this.sslContextFactory = new SslContextFactory();
            this.sslContextFactory.setTrustStore(this.configuration.getTrustStore().getStore());
            this.sslContextFactory.setTrustStorePassword(new String(this.configuration.getTrustStore().getConfiguration().getPassword()));
            this.sslContextFactory.setKeyStore(this.configuration.getIdentityStore().getStore());
            this.sslContextFactory.setKeyStorePassword(new String(this.configuration.getIdentityStore().getConfiguration().getPassword()));
            Set<String> protocols = this.configuration.getEncryptionProtocols();
            if (!protocols.isEmpty()) {
                this.sslContextFactory.setIncludeProtocols(protocols.toArray(new String[protocols.size()]));
            }
            if (!(cipherSuites = this.configuration.getEncryptionCipherSuites()).isEmpty()) {
                this.sslContextFactory.setIncludeCipherSuites(cipherSuites.toArray(new String[cipherSuites.size()]));
            }
            switch (this.configuration.getClientAuth()) {
                case disabled: {
                    this.sslContextFactory.setNeedClientAuth(false);
                    this.sslContextFactory.setWantClientAuth(false);
                    break;
                }
                case wanted: {
                    this.sslContextFactory.setNeedClientAuth(false);
                    this.sslContextFactory.setWantClientAuth(true);
                    break;
                }
                case needed: {
                    this.sslContextFactory.setNeedClientAuth(true);
                }
            }
            return this.sslContextFactory;
        }
        catch (RuntimeException ex) {
            this.sslContextFactory = null;
            throw ex;
        }
    }

    public SslFilter createServerModeSslFilter() throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        SSLContext sslContext = this.getSSLContext();
        SSLEngine sslEngine = this.createServerModeSSLEngine();
        return EncryptionArtifactFactory.createSslFilter(sslContext, sslEngine);
    }

    public SslFilter createClientModeSslFilter() throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        SSLContext sslContext = this.getSSLContext();
        SSLEngine sslEngine = this.createClientModeSSLEngine();
        return EncryptionArtifactFactory.createSslFilter(sslContext, sslEngine);
    }

    private static SslFilter createSslFilter(SSLContext sslContext, SSLEngine sslEngine) {
        SslFilter filter = new SslFilter(sslContext);
        filter.setUseClientMode(sslEngine.getUseClientMode());
        filter.setEnabledProtocols(sslEngine.getEnabledProtocols());
        filter.setEnabledCipherSuites(sslEngine.getEnabledCipherSuites());
        if (sslEngine.getNeedClientAuth()) {
            filter.setNeedClientAuth(true);
        } else if (sslEngine.getWantClientAuth()) {
            filter.setWantClientAuth(true);
        }
        return filter;
    }

    public static List<String> getSupportedProtocols() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext context = SSLContext.getInstance("TLSv1");
        context.init(null, null, null);
        return Arrays.asList(context.createSSLEngine().getSupportedProtocols());
    }

    public static List<String> getDefaultProtocols() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext context = SSLContext.getInstance("TLSv1");
        context.init(null, null, null);
        return Arrays.asList(context.createSSLEngine().getEnabledProtocols());
    }

    public static List<String> getSupportedCipherSuites() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext context = SSLContext.getInstance("TLSv1");
        context.init(null, null, null);
        return Arrays.asList(context.createSSLEngine().getSupportedCipherSuites());
    }

    public static List<String> getDefaultCipherSuites() throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext context = SSLContext.getInstance("TLSv1");
        context.init(null, null, null);
        return Arrays.asList(context.createSSLEngine().getEnabledCipherSuites());
    }
}

