/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.session;

import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.jivesoftware.openfire.Connection;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.StreamID;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.AuthToken;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.cluster.ClusterManager;
import org.jivesoftware.openfire.net.SASLAuthentication;
import org.jivesoftware.openfire.privacy.PrivacyList;
import org.jivesoftware.openfire.privacy.PrivacyListManager;
import org.jivesoftware.openfire.roster.RosterManager;
import org.jivesoftware.openfire.session.ClientSession;
import org.jivesoftware.openfire.session.ClientSessionInfo;
import org.jivesoftware.openfire.session.LocalSession;
import org.jivesoftware.openfire.spi.ConnectionConfiguration;
import org.jivesoftware.openfire.user.PresenceEventDispatcher;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.LocaleUtils;
import org.jivesoftware.util.cache.Cache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;
import org.xmpp.packet.Presence;
import org.xmpp.packet.StreamError;

public class LocalClientSession
extends LocalSession
implements ClientSession {
    private static final Logger Log = LoggerFactory.getLogger(LocalClientSession.class);
    private static final String ETHERX_NAMESPACE = "http://etherx.jabber.org/streams";
    private static final String FLASH_NAMESPACE = "http://www.jabber.com/streams/flash";
    private static Set<String> allowedIPs = new HashSet<String>();
    private static Set<String> allowedAnonymIPs = new HashSet<String>();
    private static Set<String> blockedIPs = new HashSet<String>();
    private boolean messageCarbonsEnabled;
    protected AuthToken authToken;
    private boolean initialized;
    private boolean wasAvailable = false;
    private boolean offlineFloodStopped = false;
    private Presence presence = new Presence();
    private int conflictCount = 0;
    private String activeList;
    private String defaultList;

    @Deprecated
    public static Map<String, String> getAllowedIPs() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String item : allowedIPs) {
            result.put(item, null);
        }
        return result;
    }

    public static Set<String> getWhitelistedIPs() {
        return allowedIPs;
    }

    public static Map<String, String> getAllowedAnonymIPs() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String item : allowedAnonymIPs) {
            result.put(item, null);
        }
        return result;
    }

    public static Set<String> getWhitelistedAnonymousIPs() {
        return allowedAnonymIPs;
    }

    public static Set<String> getBlacklistedIPs() {
        return blockedIPs;
    }

    public static LocalClientSession createSession(String serverName, XmlPullParser xpp, Connection connection) throws XmlPullParserException {
        boolean isFlashClient = xpp.getPrefix().equals("flash");
        connection.setFlashClient(isFlashClient);
        if (!xpp.getName().equals("stream") && !isFlashClient) {
            throw new XmlPullParserException(LocaleUtils.getLocalizedString("admin.error.bad-stream"));
        }
        if (!(xpp.getNamespace(xpp.getPrefix()).equals(ETHERX_NAMESPACE) || isFlashClient && xpp.getNamespace(xpp.getPrefix()).equals(FLASH_NAMESPACE))) {
            throw new XmlPullParserException(LocaleUtils.getLocalizedString("admin.error.bad-namespace"));
        }
        if (!LocalClientSession.isAllowed(connection)) {
            String hostAddress = "Unknown";
            try {
                hostAddress = connection.getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            Log.debug("LocalClientSession: Closed connection to client attempting to connect from: " + hostAddress);
            StreamError error = new StreamError(StreamError.Condition.not_authorized);
            connection.deliverRawText(error.toXML());
            connection.close();
            return null;
        }
        Locale language = Locale.forLanguageTag("en");
        int majorVersion = 0;
        int minorVersion = 0;
        for (int i = 0; i < xpp.getAttributeCount(); ++i) {
            if ("lang".equals(xpp.getAttributeName(i))) {
                language = Locale.forLanguageTag(xpp.getAttributeValue(i));
            }
            if (!"version".equals(xpp.getAttributeName(i))) continue;
            try {
                int[] version = LocalClientSession.decodeVersion(xpp.getAttributeValue(i));
                majorVersion = version[0];
                minorVersion = version[1];
                continue;
            }
            catch (Exception e) {
                Log.error(e.getMessage(), (Throwable)e);
            }
        }
        if (majorVersion > 1) {
            majorVersion = 1;
            minorVersion = 0;
        } else if (majorVersion == 1 && minorVersion > 0) {
            minorVersion = 0;
        }
        connection.setXMPPVersion(majorVersion, minorVersion);
        ConnectionConfiguration connectionConfiguration = connection.getConfiguration();
        if (!connection.isSecure()) {
            boolean hasCertificates = false;
            try {
                hasCertificates = connectionConfiguration.getIdentityStore().getAllCertificates().size() > 0;
            }
            catch (Exception e) {
                Log.error(e.getMessage(), (Throwable)e);
            }
            Connection.TLSPolicy tlsPolicy = connectionConfiguration.getTlsPolicy();
            if (Connection.TLSPolicy.required == tlsPolicy && !hasCertificates) {
                Log.error("Client session rejected. TLS is required but no certificates were created.");
                return null;
            }
            connection.setTlsPolicy(hasCertificates ? tlsPolicy : Connection.TLSPolicy.disabled);
        } else {
            connection.setTlsPolicy(Connection.TLSPolicy.disabled);
        }
        connection.setCompressionPolicy(connectionConfiguration.getCompressionPolicy());
        LocalClientSession session = SessionManager.getInstance().createClientSession(connection, language);
        StringBuilder sb = new StringBuilder(200);
        sb.append("<?xml version='1.0' encoding='");
        sb.append(CHARSET);
        sb.append("'?>");
        if (isFlashClient) {
            sb.append("<flash:stream xmlns:flash=\"http://www.jabber.com/streams/flash\" ");
        } else {
            sb.append("<stream:stream ");
        }
        sb.append("xmlns:stream=\"http://etherx.jabber.org/streams\" xmlns=\"jabber:client\" from=\"");
        sb.append(serverName);
        sb.append("\" id=\"");
        sb.append(session.getStreamID().toString());
        sb.append("\" xml:lang=\"");
        sb.append(language.toLanguageTag());
        if (majorVersion != 0) {
            sb.append("\" version=\"");
            sb.append(majorVersion).append('.').append(minorVersion);
        }
        sb.append("\">");
        connection.deliverRawText(sb.toString());
        if (majorVersion == 0) {
            return session;
        }
        sb = new StringBuilder(490);
        sb.append("<stream:features>");
        if (connection.getTlsPolicy() != Connection.TLSPolicy.disabled) {
            sb.append("<starttls xmlns=\"urn:ietf:params:xml:ns:xmpp-tls\">");
            if (connection.getTlsPolicy() == Connection.TLSPolicy.required) {
                sb.append("<required/>");
            }
            sb.append("</starttls>");
        }
        sb.append(SASLAuthentication.getSASLMechanisms(session));
        String specificFeatures = session.getAvailableStreamFeatures();
        if (specificFeatures != null) {
            sb.append(specificFeatures);
        }
        sb.append("</stream:features>");
        connection.deliverRawText(sb.toString());
        return session;
    }

    public static boolean isAllowed(Connection connection) {
        try {
            String hostAddress = connection.getHostAddress();
            byte[] address = connection.getAddress();
            if (blockedIPs.contains(hostAddress) || LocalClientSession.isAddressInRange(address, blockedIPs)) {
                return false;
            }
            return allowedIPs.isEmpty() || allowedIPs.contains(hostAddress) || LocalClientSession.isAddressInRange(address, allowedIPs);
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public static boolean isAllowedAnonymous(Connection connection) {
        try {
            String hostAddress = connection.getHostAddress();
            byte[] address = connection.getAddress();
            if (blockedIPs.contains(hostAddress) || LocalClientSession.isAddressInRange(address, blockedIPs)) {
                return false;
            }
            return allowedAnonymIPs.isEmpty() || allowedAnonymIPs.contains(hostAddress) || LocalClientSession.isAddressInRange(address, allowedAnonymIPs);
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public static boolean isAddressInRange(byte[] address, Set<String> ranges) {
        String range0 = (address[0] & 0xFF) + "." + (address[1] & 0xFF) + "." + (address[2] & 0xFF) + "." + (address[3] & 0xFF);
        String range1 = (address[0] & 0xFF) + "." + (address[1] & 0xFF) + "." + (address[2] & 0xFF) + ".*";
        String range2 = (address[0] & 0xFF) + "." + (address[1] & 0xFF) + ".*.*";
        String range3 = (address[0] & 0xFF) + ".*.*.*";
        return ranges.contains(range0) || ranges.contains(range1) || ranges.contains(range2) || ranges.contains(range3);
    }

    @Deprecated
    public static void setAllowedIPs(Map<String, String> allowed) {
        LocalClientSession.setWhitelistedIPs(allowed.keySet());
    }

    public static void setWhitelistedIPs(Set<String> allowed) {
        if (allowed == null) {
            throw new NullPointerException();
        }
        allowedIPs = allowed;
        if (allowedIPs.isEmpty()) {
            JiveGlobals.deleteProperty("xmpp.client.login.allowed");
        } else {
            StringBuilder buf = new StringBuilder();
            Iterator<String> iter = allowedIPs.iterator();
            if (iter.hasNext()) {
                buf.append(iter.next());
            }
            while (iter.hasNext()) {
                buf.append(", ").append(iter.next());
            }
            JiveGlobals.setProperty("xmpp.client.login.allowed", buf.toString());
        }
    }

    @Deprecated
    public static void setAllowedAnonymIPs(Map<String, String> allowed) {
        LocalClientSession.setWhitelistedAnonymousIPs(allowed.keySet());
    }

    public static void setWhitelistedAnonymousIPs(Set<String> allowed) {
        if (allowed == null) {
            throw new NullPointerException();
        }
        allowedAnonymIPs = allowed;
        if (allowedAnonymIPs.isEmpty()) {
            JiveGlobals.deleteProperty("xmpp.client.login.allowedAnonym");
        } else {
            StringBuilder buf = new StringBuilder();
            Iterator<String> iter = allowedAnonymIPs.iterator();
            if (iter.hasNext()) {
                buf.append(iter.next());
            }
            while (iter.hasNext()) {
                buf.append(", ").append(iter.next());
            }
            JiveGlobals.setProperty("xmpp.client.login.allowedAnonym", buf.toString());
        }
    }

    public static void setBlacklistedIPs(Set<String> blocked) {
        if (blocked == null) {
            throw new NullPointerException();
        }
        blockedIPs = blocked;
        if (blockedIPs.isEmpty()) {
            JiveGlobals.deleteProperty("xmpp.client.login.blocked");
        } else {
            StringBuilder buf = new StringBuilder();
            Iterator<String> iter = blocked.iterator();
            if (iter.hasNext()) {
                buf.append(iter.next());
            }
            while (iter.hasNext()) {
                buf.append(", ").append(iter.next());
            }
            JiveGlobals.setProperty("xmpp.client.login.blocked", buf.toString());
        }
    }

    @Override
    public PrivacyList getActiveList() {
        if (this.activeList != null) {
            try {
                return PrivacyListManager.getInstance().getPrivacyList(this.getUsername(), this.activeList);
            }
            catch (UserNotFoundException e) {
                Log.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void setActiveList(PrivacyList activeList) {
        String string = this.activeList = activeList != null ? activeList.getName() : null;
        if (ClusterManager.isClusteringStarted()) {
            Cache<String, ClientSessionInfo> cache = SessionManager.getInstance().getSessionInfoCache();
            cache.put(this.getAddress().toString(), new ClientSessionInfo(this));
        }
    }

    @Override
    public PrivacyList getDefaultList() {
        if (this.defaultList != null) {
            try {
                return PrivacyListManager.getInstance().getPrivacyList(this.getUsername(), this.defaultList);
            }
            catch (UserNotFoundException e) {
                Log.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void setDefaultList(PrivacyList defaultList) {
        if (this.defaultList == null && defaultList == null || defaultList != null && defaultList.getName().equals(this.defaultList)) {
            return;
        }
        String string = this.defaultList = defaultList != null ? defaultList.getName() : null;
        if (ClusterManager.isClusteringStarted()) {
            Cache<String, ClientSessionInfo> cache = SessionManager.getInstance().getSessionInfoCache();
            cache.put(this.getAddress().toString(), new ClientSessionInfo(this));
        }
    }

    public LocalClientSession(String serverName, Connection connection, StreamID streamID, Locale language) {
        super(serverName, connection, streamID, language);
        this.presence.setType(Presence.Type.unavailable);
    }

    @Override
    public String getUsername() throws UserNotFoundException {
        if (this.authToken == null) {
            throw new UserNotFoundException();
        }
        return this.getAddress().getNode();
    }

    public void setAuthToken(AuthToken auth) {
        this.authToken = auth;
    }

    public void setAuthToken(AuthToken auth, String resource) {
        this.setAddress(new JID(auth.getUsername(), this.getServerName(), resource));
        this.authToken = auth;
        this.setStatus(3);
        this.setDefaultList(PrivacyListManager.getInstance().getDefaultPrivacyList(auth.getUsername()));
        this.sessionManager.addSession(this);
    }

    public void setAnonymousAuth() {
        String resource = this.getAddress().getResource();
        this.setAddress(new JID(resource, this.getServerName(), resource, true));
        this.setStatus(3);
        if (this.authToken == null) {
            this.authToken = new AuthToken(resource, true);
        }
        this.sessionManager.addSession(this);
    }

    public AuthToken getAuthToken() {
        return this.authToken;
    }

    @Override
    public boolean isAnonymousUser() {
        return this.authToken == null || this.authToken.isAnonymous();
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void setInitialized(boolean isInit) {
        this.initialized = isInit;
    }

    public boolean wasAvailable() {
        return this.wasAvailable;
    }

    @Override
    public boolean canFloodOfflineMessages() {
        if (this.offlineFloodStopped || this.presence.getPriority() < 0) {
            return false;
        }
        String username = this.getAddress().getNode();
        for (ClientSession session : this.sessionManager.getSessions(username)) {
            if (!session.isOfflineFloodStopped()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isOfflineFloodStopped() {
        return this.offlineFloodStopped;
    }

    public void setOfflineFloodStopped(boolean offlineFloodStopped) {
        this.offlineFloodStopped = offlineFloodStopped;
        if (ClusterManager.isClusteringStarted()) {
            Cache<String, ClientSessionInfo> cache = SessionManager.getInstance().getSessionInfoCache();
            cache.put(this.getAddress().toString(), new ClientSessionInfo(this));
        }
    }

    @Override
    public Presence getPresence() {
        return this.presence;
    }

    @Override
    public void setPresence(Presence presence) {
        Presence oldPresence = this.presence;
        this.presence = presence;
        if (oldPresence.isAvailable() && !this.presence.isAvailable()) {
            this.sessionManager.sessionUnavailable(this);
            this.setInitialized(false);
            PresenceEventDispatcher.unavailableSession(this, presence);
        } else if (!oldPresence.isAvailable() && this.presence.isAvailable()) {
            this.sessionManager.sessionAvailable(this, presence);
            this.wasAvailable = true;
            PresenceEventDispatcher.availableSession(this, presence);
        } else if (this.presence.isAvailable() && oldPresence.getPriority() != this.presence.getPriority()) {
            this.sessionManager.changePriority(this, oldPresence.getPriority());
            PresenceEventDispatcher.presenceChanged(this, presence);
        } else if (this.presence.isAvailable()) {
            PresenceEventDispatcher.presenceChanged(this, presence);
        }
        if (ClusterManager.isClusteringStarted()) {
            Cache<String, ClientSessionInfo> cache = SessionManager.getInstance().getSessionInfoCache();
            cache.put(this.getAddress().toString(), new ClientSessionInfo(this));
        }
    }

    @Override
    public String getAvailableStreamFeatures() {
        if (this.conn.getTlsPolicy() == Connection.TLSPolicy.required && !this.conn.isSecure()) {
            return null;
        }
        StringBuilder sb = new StringBuilder(200);
        if (this.conn.getCompressionPolicy() != Connection.CompressionPolicy.disabled && !this.conn.isCompressed()) {
            sb.append("<compression xmlns=\"http://jabber.org/features/compress\"><method>zlib</method></compression>");
        }
        if (RosterManager.isRosterVersioningEnabled()) {
            sb.append("<ver xmlns=\"urn:xmpp:features:rosterver\"/>");
        }
        if (this.getAuthToken() == null) {
            if (XMPPServer.getInstance().getIQRouter().supports("jabber:iq:auth")) {
                sb.append("<auth xmlns=\"http://jabber.org/features/iq-auth\"/>");
            }
            if (XMPPServer.getInstance().getIQRegisterHandler().isInbandRegEnabled()) {
                sb.append("<register xmlns=\"http://jabber.org/features/iq-register\"/>");
            }
        } else {
            sb.append("<bind xmlns=\"urn:ietf:params:xml:ns:xmpp-bind\"/>");
            sb.append("<session xmlns=\"urn:ietf:params:xml:ns:xmpp-session\"><optional/></session>");
            if (JiveGlobals.getBooleanProperty("stream.management.active", true)) {
                sb.append(String.format("<sm xmlns='%s'/>", "urn:xmpp:sm:2"));
                sb.append(String.format("<sm xmlns='%s'/>", "urn:xmpp:sm:3"));
            }
        }
        return sb.toString();
    }

    @Override
    public int incrementConflictCount() {
        ++this.conflictCount;
        return this.conflictCount;
    }

    @Override
    public boolean isMessageCarbonsEnabled() {
        return this.messageCarbonsEnabled;
    }

    @Override
    public void setMessageCarbonsEnabled(boolean enabled) {
        this.messageCarbonsEnabled = enabled;
    }

    @Override
    public boolean canProcess(Packet packet) {
        PrivacyList list = this.getActiveList();
        if (list != null) {
            return !list.shouldBlockPacket(packet);
        }
        list = this.getDefaultList();
        return list == null || !list.shouldBlockPacket(packet);
    }

    @Override
    public void deliver(Packet packet) throws UnauthorizedException {
        if (this.conn != null) {
            this.conn.deliver(packet);
        }
        this.streamManager.sentStanza(packet);
    }

    @Override
    public String toString() {
        return super.toString() + " presence: " + this.presence;
    }

    static {
        String allowed = JiveGlobals.getProperty("xmpp.client.login.allowed", "");
        StringTokenizer tokens = new StringTokenizer(allowed, ", ");
        while (tokens.hasMoreTokens()) {
            String address = tokens.nextToken().trim();
            allowedIPs.add(address);
        }
        String allowedAnonym = JiveGlobals.getProperty("xmpp.client.login.allowedAnonym", "");
        tokens = new StringTokenizer(allowedAnonym, ", ");
        while (tokens.hasMoreTokens()) {
            String address = tokens.nextToken().trim();
            allowedAnonymIPs.add(address);
        }
        String blocked = JiveGlobals.getProperty("xmpp.client.login.blocked", "");
        tokens = new StringTokenizer(blocked, ", ");
        while (tokens.hasMoreTokens()) {
            String address = tokens.nextToken().trim();
            blockedIPs.add(address);
        }
    }
}

