/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.server;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import javax.net.ssl.SSLHandshakeException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.XMPPPacketReader;
import org.jivesoftware.openfire.Connection;
import org.jivesoftware.openfire.RemoteConnectionFailedException;
import org.jivesoftware.openfire.RoutingTable;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.StreamID;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.AuthFactory;
import org.jivesoftware.openfire.net.MXParser;
import org.jivesoftware.openfire.net.SASLAuthentication;
import org.jivesoftware.openfire.net.ServerTrafficCounter;
import org.jivesoftware.openfire.net.SocketConnection;
import org.jivesoftware.openfire.net.SocketUtil;
import org.jivesoftware.openfire.net.TLSStreamHandler;
import org.jivesoftware.openfire.server.OutgoingServerSocketReader;
import org.jivesoftware.openfire.server.RemoteServerManager;
import org.jivesoftware.openfire.session.IncomingServerSession;
import org.jivesoftware.openfire.session.LocalIncomingServerSession;
import org.jivesoftware.openfire.session.LocalOutgoingServerSession;
import org.jivesoftware.openfire.spi.BasicStreamIDFactory;
import org.jivesoftware.openfire.spi.ConnectionManagerImpl;
import org.jivesoftware.openfire.spi.ConnectionType;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.StringUtils;
import org.jivesoftware.util.cache.Cache;
import org.jivesoftware.util.cache.CacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.PacketError;
import org.xmpp.packet.StreamError;

public class ServerDialback {
    private static final Logger Log = LoggerFactory.getLogger(ServerDialback.class);
    protected static String CHARSET = "UTF-8";
    private static Cache<String, String> secretKeyCache;
    private static XmlPullParserFactory FACTORY;
    private Connection connection;
    private String serverName;
    private SessionManager sessionManager = SessionManager.getInstance();
    private RoutingTable routingTable = XMPPServer.getInstance().getRoutingTable();

    public static boolean isEnabled() {
        return JiveGlobals.getBooleanProperty("xmpp.server.dialback.enabled", true);
    }

    public static boolean isEnabledForSelfSigned() {
        return JiveGlobals.getBooleanProperty("xmpp.server.certificate.accept-selfsigned", false);
    }

    public static void setEnabledForSelfSigned(boolean enabled) {
        JiveGlobals.setProperty("xmpp.server.certificate.accept-selfsigned", Boolean.toString(enabled));
    }

    public ServerDialback(Connection connection, String serverName) {
        this.connection = connection;
        this.serverName = serverName;
    }

    public ServerDialback() {
    }

    public LocalOutgoingServerSession createOutgoingSession(String localDomain, String remoteDomain, int port) {
        Logger log;
        block7: {
            log = LoggerFactory.getLogger((String)(Log.getName() + "[Acting as Originating Server: Create Outgoing Session from: " + localDomain + " to RS at: " + remoteDomain + " (port: " + port + ")]"));
            log.debug("Creating new outgoing session...");
            Object hostname = null;
            int realPort = port;
            try {
                Socket socket = SocketUtil.createSocketToXmppDomain(remoteDomain, port);
                if (socket == null) {
                    log.info("Unable to create new outgoing session: Cannot create a plain socket connection with any applicable remote host.");
                    return null;
                }
                this.connection = new SocketConnection(XMPPServer.getInstance().getPacketDeliverer(), socket, false);
                log.debug("Send the stream header and wait for response...");
                StringBuilder stream = new StringBuilder();
                stream.append("<stream:stream");
                stream.append(" xmlns:stream=\"http://etherx.jabber.org/streams\"");
                stream.append(" xmlns=\"jabber:server\"");
                stream.append(" to=\"").append(remoteDomain).append("\"");
                stream.append(" from=\"").append(localDomain).append("\"");
                stream.append(" xmlns:db=\"jabber:server:dialback\"");
                stream.append(">");
                this.connection.deliverRawText(stream.toString());
                int soTimeout = socket.getSoTimeout();
                socket.setSoTimeout(RemoteServerManager.getSocketTimeout());
                XMPPPacketReader reader = new XMPPPacketReader();
                reader.setXPPFactory(FACTORY);
                reader.getXPPParser().setInput(new InputStreamReader(ServerTrafficCounter.wrapInputStream(socket.getInputStream()), CHARSET));
                MXParser xpp = reader.getXPPParser();
                int eventType = xpp.getEventType();
                while (eventType != 2) {
                    eventType = xpp.next();
                }
                log.debug("Got a response. Check if the remote server supports dialback...");
                if ("jabber:server:dialback".equals(xpp.getNamespace("db"))) {
                    log.debug("Dialback seems to be supported by the remote server.");
                    socket.setSoTimeout(soTimeout);
                    String id = xpp.getAttributeValue("", "id");
                    OutgoingServerSocketReader socketReader = new OutgoingServerSocketReader(reader);
                    if (this.authenticateDomain(socketReader, localDomain, remoteDomain, id)) {
                        log.debug("Successfully authenticated the connection with dialback.");
                        StreamID streamID = BasicStreamIDFactory.createStreamID(id);
                        LocalOutgoingServerSession session = new LocalOutgoingServerSession(localDomain, this.connection, socketReader, streamID);
                        this.connection.init(session);
                        session.setAddress(new JID(null, remoteDomain, null));
                        log.debug("Successfully created new outgoing session!");
                        return session;
                    }
                    log.debug("Failed to authenticate the connection with dialback.");
                    this.connection.close();
                } else {
                    log.debug("Error! Invalid namespace in packet: '{}'. Closing connection.", (Object)xpp.getText());
                    this.connection.deliverRawText(new StreamError(StreamError.Condition.invalid_namespace).toXML());
                    this.connection.close();
                }
            }
            catch (Exception e) {
                log.error("An exception occurred while creating outgoing session to remote server:", (Throwable)e);
                if (this.connection == null) break block7;
                this.connection.close();
            }
        }
        log.warn("Unable to create a new outgoing session");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticateDomain(OutgoingServerSocketReader socketReader, String localDomain, String remoteDomain, String id) {
        Logger log = LoggerFactory.getLogger((String)(Log.getName() + "[Acting as Originating Server: Authenticate domain: " + localDomain + " with RS: " + remoteDomain + " (id: " + id + ")]"));
        log.debug("Authenticating domain ...");
        String key = AuthFactory.createDigest(id, ServerDialback.getSecretkey());
        OutgoingServerSocketReader outgoingServerSocketReader = socketReader;
        synchronized (outgoingServerSocketReader) {
            log.debug("Sending dialback key and wait for the validation response...");
            StringBuilder sb = new StringBuilder();
            sb.append("<db:result");
            sb.append(" from=\"").append(localDomain).append("\"");
            sb.append(" to=\"").append(remoteDomain).append("\">");
            sb.append(key);
            sb.append("</db:result>");
            this.connection.deliverRawText(sb.toString());
            try {
                while (true) {
                    Element doc;
                    if ((doc = socketReader.getElement(RemoteServerManager.getSocketTimeout(), TimeUnit.MILLISECONDS)) == null) {
                        log.debug("Failed to authenticate domain: Time out waiting for validation response.");
                        return false;
                    }
                    if ("db".equals(doc.getNamespacePrefix()) && "result".equals(doc.getName())) {
                        if ("valid".equals(doc.attributeValue("type"))) {
                            log.debug("Authenticated succeeded!");
                            return true;
                        }
                        log.debug("Failed to authenticate domain: the validation response was received, but did not grant authentication.");
                        return false;
                    }
                    log.warn("Ignoring unexpected answer while waiting for dialback validation: " + doc.asXML());
                }
            }
            catch (InterruptedException e) {
                log.debug("Failed to authenticate domain: An interrupt was received while waiting for validation response (is Openfire shutting down?)");
                return false;
            }
        }
    }

    public LocalIncomingServerSession createIncomingSession(XMPPPacketReader reader) throws IOException, XmlPullParserException {
        MXParser xpp = reader.getXPPParser();
        if ("jabber:server:dialback".equals(xpp.getNamespace("db"))) {
            Log.debug("ServerDialback: Processing incoming session.");
            StreamID streamID = this.sessionManager.nextStreamID();
            StringBuilder sb = new StringBuilder();
            sb.append("<stream:stream");
            sb.append(" xmlns:stream=\"http://etherx.jabber.org/streams\"");
            sb.append(" xmlns=\"jabber:server\" xmlns:db=\"jabber:server:dialback\"");
            sb.append(" id=\"");
            sb.append(streamID.toString());
            sb.append("\">");
            this.connection.deliverRawText(sb.toString());
            try {
                Element doc = reader.parseDocument().getRootElement();
                if ("db".equals(doc.getNamespacePrefix()) && "result".equals(doc.getName())) {
                    String hostname = doc.attributeValue("from");
                    String recipient = doc.attributeValue("to");
                    Log.debug("ServerDialback: RS - Validating remote domain for incoming session from {} to {}", (Object)hostname, (Object)recipient);
                    if (this.validateRemoteDomain(doc, streamID)) {
                        Log.debug("ServerDialback: RS - Validation of remote domain for incoming session from {} to {} was successful.", (Object)hostname, (Object)recipient);
                        LocalIncomingServerSession session = this.sessionManager.createIncomingServerSession(this.connection, streamID, hostname);
                        session.addValidatedDomain(hostname);
                        session.setLocalDomain(recipient);
                        return session;
                    }
                    Log.debug("ServerDialback: RS - Validation of remote domain for incoming session from {} to {} was not successful.", (Object)hostname, (Object)recipient);
                    return null;
                }
                if ("db".equals(doc.getNamespacePrefix()) && "verify".equals(doc.getName())) {
                    ServerDialback.verifyReceivedKey(doc, this.connection);
                    this.connection.close();
                    String verifyFROM = doc.attributeValue("from");
                    String id = doc.attributeValue("id");
                    Log.debug("ServerDialback: AS - Connection closed for host: " + verifyFROM + " id: " + id);
                    return null;
                }
                Log.debug("ServerDialback: Received an invalid/unknown packet while trying to process an incoming session: {}", (Object)doc.asXML());
                this.connection.deliverRawText(new StreamError(StreamError.Condition.invalid_xml).toXML());
                this.connection.close();
                return null;
            }
            catch (Exception e) {
                Log.error("An error occured while creating a server session", (Throwable)e);
                this.connection.close();
                return null;
            }
        }
        Log.debug("ServerDialback: Received a stanza in an invalid namespace while trying to process an incoming session: {}", (Object)xpp.getNamespace("db"));
        this.connection.deliverRawText(new StreamError(StreamError.Condition.invalid_namespace).toXML());
        this.connection.close();
        return null;
    }

    protected void dialbackError(String from, String to, PacketError err) {
        this.connection.deliverRawText("<db:result type=\"error\" from=\"" + from + "\" to=\"" + to + "\">" + err.toXML() + "</db:result>");
    }

    public boolean validateRemoteDomain(Element doc, StreamID streamID) {
        String recipient = doc.attributeValue("to");
        String remoteDomain = doc.attributeValue("from");
        Logger log = LoggerFactory.getLogger((String)(Log.getName() + "[Acting as Receiving Server: Validate domain:" + recipient + "(id " + streamID + ") for OS: " + remoteDomain + "]"));
        log.debug("Validating domain...");
        if (this.connection.getTlsPolicy() == Connection.TLSPolicy.required && !this.connection.isSecure()) {
            this.connection.deliverRawText(new StreamError(StreamError.Condition.policy_violation).toXML());
            this.connection.close();
            return false;
        }
        if (!RemoteServerManager.canAccess(remoteDomain)) {
            this.connection.deliverRawText(new StreamError(StreamError.Condition.policy_violation).toXML());
            this.connection.close();
            log.debug("Unable to validate domain: Remote domain is not allowed to establish a connection to this server.");
            return false;
        }
        if (this.isHostUnknown(recipient)) {
            this.dialbackError(recipient, remoteDomain, new PacketError(PacketError.Condition.item_not_found, PacketError.Type.cancel, "Service not hosted here"));
            log.debug("Unable to validate domain: recipient not recognized as a local domain.");
            return false;
        }
        log.debug("Check if the remote domain already has a connection to the target domain/subdomain");
        boolean alreadyExists = false;
        for (IncomingServerSession session : this.sessionManager.getIncomingServerSessions(remoteDomain)) {
            if (!recipient.equals(session.getLocalDomain())) continue;
            alreadyExists = true;
        }
        if (alreadyExists && !this.sessionManager.isMultipleServerConnectionsAllowed()) {
            this.dialbackError(recipient, remoteDomain, new PacketError(PacketError.Condition.resource_constraint, PacketError.Type.cancel, "Incoming session already exists"));
            log.debug("Unable to validate domain: An incoming connection already exists from this remote domain, and multiple connections are not allowed.");
            return false;
        }
        log.debug("Checking to see if the remote server provides stronger authentication based on SASL. If that's the case, dialback-based authentication can be skipped.");
        if (SASLAuthentication.verifyCertificates(this.connection.getPeerCertificates(), remoteDomain, true)) {
            log.debug("Host authenticated based on SASL. Weaker dialback-based authentication is skipped.");
            StringBuilder sb = new StringBuilder();
            sb.append("<db:result");
            sb.append(" from=\"").append(recipient).append("\"");
            sb.append(" to=\"").append(remoteDomain).append("\"");
            sb.append(" type=\"valid\"");
            sb.append("/>");
            this.connection.deliverRawText(sb.toString());
            log.debug("Domain validated successfully!");
            return true;
        }
        log.debug("Unable to authenticate host based on stronger SASL. Proceeding with dialback...");
        String key = doc.getTextTrim();
        Socket socket = SocketUtil.createSocketToXmppDomain(remoteDomain, RemoteServerManager.getPortForServer(remoteDomain));
        if (socket == null) {
            log.debug("Unable to validate domain: No server available for verifying key of remote server.");
            this.dialbackError(recipient, remoteDomain, new PacketError(PacketError.Condition.remote_server_not_found, PacketError.Type.cancel, "Unable to connect to authoritative server"));
            return false;
        }
        try {
            VerifyResult result;
            log.debug("Verifying dialback key...");
            try {
                result = this.verifyKey(key, streamID, recipient, remoteDomain, socket, false);
            }
            catch (SSLHandshakeException e) {
                log.debug("Verification of dialback key failed due to TLS failure. Retry without TLS...", (Throwable)e);
                SocketAddress oldAddress = socket.getRemoteSocketAddress();
                socket.close();
                log.debug("Re-opening socket (with the same remote peer)...");
                socket = new Socket();
                socket.connect(oldAddress, RemoteServerManager.getSocketTimeout());
                log.debug("Successfully re-opened socket! Try to validate dialback key again (without TLS this time)...");
                result = this.verifyKey(key, streamID, recipient, remoteDomain, socket, true);
            }
            switch (result) {
                case valid: 
                case invalid: {
                    boolean valid = result == VerifyResult.valid;
                    log.debug("Dialback key is" + (valid ? "valid" : "invalid") + ". Sending verification result to remote domain.");
                    StringBuilder sb = new StringBuilder();
                    sb.append("<db:result");
                    sb.append(" from=\"").append(recipient).append("\"");
                    sb.append(" to=\"").append(remoteDomain).append("\"");
                    sb.append(" type=\"");
                    sb.append(valid ? "valid" : "invalid");
                    sb.append("\"/>");
                    this.connection.deliverRawText(sb.toString());
                    if (!valid) {
                        log.debug("Close the underlying connection as key verification failed.");
                        this.connection.close();
                        log.debug("Unable to validate domain: dialback key is invalid.");
                        return false;
                    }
                    log.debug("Successfully validated domain!");
                    return true;
                }
            }
            log.debug("Unable to validate domain: key verification did not complete (the AS likely returned an error or a time out occurred).");
            this.dialbackError(recipient, remoteDomain, new PacketError(PacketError.Condition.remote_server_timeout, PacketError.Type.cancel, "Authoritative server returned error"));
            return false;
        }
        catch (Exception e) {
            this.dialbackError(recipient, remoteDomain, new PacketError(PacketError.Condition.remote_server_timeout, PacketError.Type.cancel, "Authoritative server failed"));
            log.warn("Unable to validate domain: An exception occurred while verifying the dialback key.", (Throwable)e);
            return false;
        }
    }

    private boolean isHostUnknown(String recipient) {
        boolean host_unknown;
        boolean bl = host_unknown = !this.serverName.equals(recipient);
        if (host_unknown && recipient.contains(this.serverName)) {
            host_unknown = !this.routingTable.hasComponentRoute(new JID(recipient));
        }
        return host_unknown;
    }

    private VerifyResult sendVerifyKey(String key, StreamID streamID, String recipient, String remoteDomain, Writer writer, XMPPPacketReader reader, Socket socket, boolean skipTLS) throws IOException, XmlPullParserException, RemoteConnectionFailedException {
        Logger log = LoggerFactory.getLogger((String)(Log.getName() + "[Acting as Receiving Server: Verify key with AS: " + remoteDomain + " for OS: " + recipient + " (id " + streamID + ")]"));
        VerifyResult result = VerifyResult.error;
        log.debug("Send the Authoritative Server a stream header and wait for answer.");
        StringBuilder stream = new StringBuilder();
        stream.append("<stream:stream");
        stream.append(" xmlns:stream=\"http://etherx.jabber.org/streams\"");
        stream.append(" xmlns=\"jabber:server\"");
        stream.append(" xmlns:db=\"jabber:server:dialback\"");
        stream.append(" to=\"");
        stream.append(remoteDomain);
        stream.append("\"");
        stream.append(" from=\"");
        stream.append(recipient);
        stream.append("\"");
        stream.append(" version=\"1.0\">");
        writer.write(stream.toString());
        writer.flush();
        MXParser xpp = reader.getXPPParser();
        int eventType = xpp.getEventType();
        while (eventType != 2) {
            eventType = xpp.next();
        }
        log.debug("Got a response.");
        if (xpp.getAttributeValue("", "version") != null && xpp.getAttributeValue("", "version").equals("1.0")) {
            Document doc;
            log.debug("The remote server is XMPP 1.0 compliant (or at least reports to be).");
            try {
                doc = reader.parseDocument();
            }
            catch (DocumentException e) {
                log.warn("Unable to verify key: XML Error!", (Throwable)e);
                return VerifyResult.error;
            }
            Element features = doc.getRootElement();
            Element starttls = features.element("starttls");
            if (!skipTLS && starttls != null) {
                writer.write("<starttls xmlns='urn:ietf:params:xml:ns:xmpp-tls'/>");
                writer.flush();
                try {
                    doc = reader.parseDocument();
                }
                catch (DocumentException e) {
                    log.warn("Unable to verify key: XML Error!", (Throwable)e);
                    return VerifyResult.error;
                }
                if (!doc.getRootElement().getName().equals("proceed")) {
                    log.warn("Unable to verify key: Got {} instead of proceed for starttls", (Object)doc.getRootElement().getName());
                    log.debug("Like this: {}", (Object)doc.asXML());
                    return VerifyResult.error;
                }
                log.debug("Negotiating TLS with AS... ");
                ConnectionManagerImpl connectionManager = (ConnectionManagerImpl)XMPPServer.getInstance().getConnectionManager();
                TLSStreamHandler tlsStreamHandler = new TLSStreamHandler(socket, connectionManager.getListener(ConnectionType.SOCKET_S2S, false).generateConnectionConfiguration(), true);
                tlsStreamHandler.start();
                writer = new BufferedWriter(new OutputStreamWriter(tlsStreamHandler.getOutputStream(), StandardCharsets.UTF_8));
                reader.getXPPParser().setInput(new InputStreamReader(tlsStreamHandler.getInputStream(), StandardCharsets.UTF_8));
                log.debug("Successfully negotiated TLS with AS... ");
                return this.sendVerifyKey(key, streamID, recipient, remoteDomain, writer, reader, socket, skipTLS);
            }
        }
        if ("jabber:server:dialback".equals(xpp.getNamespace("db"))) {
            log.debug("Request for verification of the key and wait for response");
            StringBuilder sb = new StringBuilder();
            sb.append("<db:verify");
            sb.append(" from=\"").append(recipient).append("\"");
            sb.append(" to=\"").append(remoteDomain).append("\"");
            sb.append(" id=\"").append(streamID.getID()).append("\">");
            sb.append(key);
            sb.append("</db:verify>");
            writer.write(sb.toString());
            writer.flush();
            try {
                Element doc = reader.parseDocument().getRootElement();
                if ("db".equals(doc.getNamespacePrefix()) && "verify".equals(doc.getName())) {
                    if (doc.attributeValue("id") == null || !streamID.equals(BasicStreamIDFactory.createStreamID(doc.attributeValue("id")))) {
                        writer.write(new StreamError(StreamError.Condition.invalid_id).toXML());
                        writer.flush();
                        throw new RemoteConnectionFailedException("Invalid ID");
                    }
                    if (this.isHostUnknown(doc.attributeValue("to"))) {
                        writer.write(new StreamError(StreamError.Condition.host_unknown).toXML());
                        writer.flush();
                        throw new RemoteConnectionFailedException("Host unknown");
                    }
                    if (!remoteDomain.equals(doc.attributeValue("from"))) {
                        writer.write(new StreamError(StreamError.Condition.invalid_from).toXML());
                        writer.flush();
                        throw new RemoteConnectionFailedException("Invalid From");
                    }
                    if ("valid".equals(doc.attributeValue("type"))) {
                        log.debug("Key was VERIFIED by the Authoritative Server.");
                        result = VerifyResult.valid;
                    }
                    if ("invalid".equals(doc.attributeValue("type"))) {
                        log.debug("Key was NOT VERIFIED by the Authoritative Server.");
                        result = VerifyResult.invalid;
                    }
                    log.debug("Key was ERRORED by the Authoritative Server.");
                    result = VerifyResult.error;
                }
                log.debug("db:verify answer was: " + doc.asXML());
            }
            catch (RuntimeException | DocumentException e) {
                log.error("An error occurred while connecting to the Authoritative Server:", e);
                throw new RemoteConnectionFailedException("Error connecting to the Authoritative Server");
            }
        } else {
            writer.write(new StreamError(StreamError.Condition.invalid_namespace).toXML());
            writer.flush();
            throw new RemoteConnectionFailedException("Invalid namespace");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VerifyResult verifyKey(String key, StreamID streamID, String recipient, String remoteDomain, Socket socket, boolean skipTLS) throws IOException, XmlPullParserException, RemoteConnectionFailedException {
        Logger log = LoggerFactory.getLogger((String)(Log.getName() + "[Acting as Receiving Server: Verify key with AS: " + remoteDomain + " for OS: " + recipient + " (id " + streamID + ")]"));
        log.debug("Verifying key ...");
        Writer writer = null;
        socket.setSoTimeout(RemoteServerManager.getSocketTimeout());
        VerifyResult result = VerifyResult.error;
        try {
            XMPPPacketReader reader = new XMPPPacketReader();
            reader.setXPPFactory(FACTORY);
            reader.getXPPParser().setInput(new InputStreamReader(socket.getInputStream(), CHARSET));
            writer = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), CHARSET));
            result = this.sendVerifyKey(key, streamID, recipient, remoteDomain, writer, reader, socket, skipTLS);
        }
        finally {
            try {
                StringBuilder sb = new StringBuilder();
                sb.append("</stream:stream>");
                writer.write(sb.toString());
                writer.flush();
                socket.close();
            }
            catch (IOException iOException) {}
        }
        switch (result) {
            case valid: {
                log.debug("Successfully verified key!");
                break;
            }
            case invalid: {
                log.debug("Unable to verify key: AS reports that the key is invalid.");
                break;
            }
            default: {
                log.debug("Unable to verify key: An error occurred.");
            }
        }
        return result;
    }

    public static boolean verifyReceivedKey(Element doc, Connection connection) {
        String verifyFROM = doc.attributeValue("from");
        String verifyTO = doc.attributeValue("to");
        String key = doc.getTextTrim();
        StreamID streamID = BasicStreamIDFactory.createStreamID(doc.attributeValue("id"));
        Logger log = LoggerFactory.getLogger((String)(Log.getName() + "[Acting as Authoritative Server: Verify key sent by RS: " + verifyFROM + " (id " + streamID + ")]"));
        log.debug("Verifying key... ");
        String expectedKey = AuthFactory.createDigest(streamID.getID(), ServerDialback.getSecretkey());
        boolean verified = expectedKey.equals(key);
        StringBuilder sb = new StringBuilder();
        sb.append("<db:verify");
        sb.append(" from=\"").append(verifyTO).append("\"");
        sb.append(" to=\"").append(verifyFROM).append("\"");
        sb.append(" type=\"");
        sb.append(verified ? "valid" : "invalid");
        sb.append("\" id=\"").append(streamID.getID()).append("\"/>");
        connection.deliverRawText(sb.toString());
        log.debug("Verification successful! Key was: " + (verified ? "VALID" : "INVALID"));
        return verified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getSecretkey() {
        String key = "secretKey";
        Lock lock = CacheFactory.getLock(key, secretKeyCache);
        try {
            lock.lock();
            String secret = (String)secretKeyCache.get(key);
            if (secret == null) {
                secret = StringUtils.randomString(10);
                secretKeyCache.put(key, secret);
            }
            String string = secret;
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    static {
        FACTORY = null;
        try {
            FACTORY = XmlPullParserFactory.newInstance((String)MXParser.class.getName(), null);
        }
        catch (XmlPullParserException e) {
            Log.error("Error creating a parser factory", (Throwable)e);
        }
        secretKeyCache = CacheFactory.createCache("Secret Keys Cache");
    }

    private static enum VerifyResult {
        decline,
        error,
        valid,
        invalid;

    }
}

