/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.server;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import org.jivesoftware.database.DbConnectionManager;
import org.jivesoftware.openfire.SessionManager;
import org.jivesoftware.openfire.server.RemoteServerConfiguration;
import org.jivesoftware.openfire.session.DomainPair;
import org.jivesoftware.openfire.session.OutgoingServerSession;
import org.jivesoftware.openfire.session.Session;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.cache.Cache;
import org.jivesoftware.util.cache.CacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteServerManager {
    private static final Logger Log = LoggerFactory.getLogger(RemoteServerManager.class);
    private static final String ADD_CONFIGURATION = "INSERT INTO ofRemoteServerConf (xmppDomain,remotePort,permission) VALUES (?,?,?)";
    private static final String DELETE_CONFIGURATION = "DELETE FROM ofRemoteServerConf WHERE xmppDomain=?";
    private static final String LOAD_CONFIGURATION = "SELECT remotePort,permission FROM ofRemoteServerConf where xmppDomain=?";
    private static final String LOAD_CONFIGURATIONS = "SELECT xmppDomain,remotePort FROM ofRemoteServerConf where permission=?";
    private static Cache configurationsCache = CacheFactory.createCache("Remote Server Configurations");

    public static void allowAccess(RemoteServerConfiguration configuration) {
        RemoteServerManager.deleteConfiguration(configuration.getDomain());
        configuration.setPermission(RemoteServerConfiguration.Permission.allowed);
        RemoteServerManager.addConfiguration(configuration);
    }

    public static void blockAccess(String domain) {
        RemoteServerManager.deleteConfiguration(domain);
        RemoteServerConfiguration config = new RemoteServerConfiguration(domain);
        config.setPermission(RemoteServerConfiguration.Permission.blocked);
        RemoteServerManager.addConfiguration(config);
        for (Session session : SessionManager.getInstance().getIncomingServerSessions(domain)) {
            session.close();
        }
        for (DomainPair domainPair : SessionManager.getInstance().getOutgoingDomainPairs()) {
            if (!domainPair.getRemote().equals(domain)) continue;
            OutgoingServerSession session = SessionManager.getInstance().getOutgoingServerSession(domainPair);
            session.close();
        }
    }

    public static boolean canAccess(String domain) {
        if (!JiveGlobals.getBooleanProperty("xmpp.server.socket.active", true)) {
            return false;
        }
        RemoteServerConfiguration.Permission permission = null;
        RemoteServerConfiguration config = RemoteServerManager.getConfiguration(domain);
        if (config != null) {
            permission = config.getPermission();
        }
        if (PermissionPolicy.blacklist == RemoteServerManager.getPermissionPolicy()) {
            return RemoteServerConfiguration.Permission.blocked != permission;
        }
        return RemoteServerConfiguration.Permission.allowed == permission;
    }

    public static Collection<RemoteServerConfiguration> getAllowedServers() {
        return RemoteServerManager.getConfigurations(RemoteServerConfiguration.Permission.allowed);
    }

    public static Collection<RemoteServerConfiguration> getBlockedServers() {
        return RemoteServerManager.getConfigurations(RemoteServerConfiguration.Permission.blocked);
    }

    public static int getSocketTimeout() {
        return JiveGlobals.getIntProperty("xmpp.server.read.timeout", 120000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteConfiguration(String domain) {
        configurationsCache.remove(domain);
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(DELETE_CONFIGURATION);
            pstmt.setString(1, domain);
            pstmt.executeUpdate();
        }
        catch (SQLException sqle) {
            try {
                Log.error(sqle.getMessage(), (Throwable)sqle);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
        DbConnectionManager.closeConnection(pstmt, con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addConfiguration(RemoteServerConfiguration configuration) {
        configurationsCache.put(configuration.getDomain(), configuration);
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(ADD_CONFIGURATION);
            pstmt.setString(1, configuration.getDomain());
            pstmt.setInt(2, configuration.getRemotePort());
            pstmt.setString(3, configuration.getPermission().toString());
            pstmt.executeUpdate();
        }
        catch (SQLException sqle) {
            try {
                Log.error(sqle.getMessage(), (Throwable)sqle);
            }
            catch (Throwable throwable) {
                DbConnectionManager.closeConnection(pstmt, con);
                throw throwable;
            }
            DbConnectionManager.closeConnection(pstmt, con);
        }
        DbConnectionManager.closeConnection(pstmt, con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RemoteServerConfiguration getConfiguration(String domain) {
        Object value = configurationsCache.get(domain);
        if ("null".equals(value)) {
            return null;
        }
        RemoteServerConfiguration configuration = (RemoteServerConfiguration)value;
        if (configuration == null) {
            Connection con = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                con = DbConnectionManager.getConnection();
                pstmt = con.prepareStatement(LOAD_CONFIGURATION);
                pstmt.setString(1, domain);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    configuration = new RemoteServerConfiguration(domain);
                    configuration.setRemotePort(rs.getInt(1));
                    configuration.setPermission(RemoteServerConfiguration.Permission.valueOf(rs.getString(2)));
                }
                DbConnectionManager.closeConnection(rs, pstmt, con);
            }
            catch (SQLException sqle) {
                Log.error(sqle.getMessage(), (Throwable)sqle);
            }
            finally {
                DbConnectionManager.closeConnection(rs, pstmt, con);
            }
            if (configuration != null) {
                configurationsCache.put(domain, configuration);
            } else {
                configurationsCache.put(domain, "null");
            }
        }
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<RemoteServerConfiguration> getConfigurations(RemoteServerConfiguration.Permission permission) {
        ArrayList<RemoteServerConfiguration> answer = new ArrayList<RemoteServerConfiguration>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(LOAD_CONFIGURATIONS);
            pstmt.setString(1, permission.toString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                RemoteServerConfiguration configuration = new RemoteServerConfiguration(rs.getString(1));
                configuration.setRemotePort(rs.getInt(2));
                configuration.setPermission(permission);
                answer.add(configuration);
            }
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        catch (SQLException sqle) {
            Log.error(sqle.getMessage(), (Throwable)sqle);
        }
        finally {
            DbConnectionManager.closeConnection(rs, pstmt, con);
        }
        return answer;
    }

    public static int getPortForServer(String domain) {
        int port = JiveGlobals.getIntProperty("xmpp.server.socket.remotePort", 5269);
        RemoteServerConfiguration config = RemoteServerManager.getConfiguration(domain);
        if (config != null && (port = config.getRemotePort()) == 0) {
            port = JiveGlobals.getIntProperty("xmpp.server.socket.remotePort", 5269);
        }
        return port;
    }

    public static PermissionPolicy getPermissionPolicy() {
        try {
            return PermissionPolicy.valueOf(JiveGlobals.getProperty("xmpp.server.permission", PermissionPolicy.blacklist.toString()));
        }
        catch (Exception e) {
            Log.error(e.getMessage(), (Throwable)e);
            return PermissionPolicy.blacklist;
        }
    }

    public static void setPermissionPolicy(PermissionPolicy policy) {
        JiveGlobals.setProperty("xmpp.server.permission", policy.toString());
        for (String hostname : SessionManager.getInstance().getIncomingServers()) {
            if (RemoteServerManager.canAccess(hostname)) continue;
            for (Session session : SessionManager.getInstance().getIncomingServerSessions(hostname)) {
                session.close();
            }
        }
        for (DomainPair domainPair : SessionManager.getInstance().getOutgoingDomainPairs()) {
            if (RemoteServerManager.canAccess(domainPair.getRemote())) continue;
            OutgoingServerSession session = SessionManager.getInstance().getOutgoingServerSession(domainPair);
            session.close();
        }
    }

    public static void setPermissionPolicy(String policy) {
        RemoteServerManager.setPermissionPolicy(PermissionPolicy.valueOf(policy));
    }

    public static enum PermissionPolicy {
        blacklist,
        whitelist;

    }
}

