/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.server;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jivesoftware.util.cache.CacheSizes;
import org.jivesoftware.util.cache.Cacheable;
import org.jivesoftware.util.cache.ExternalizableUtil;

public class RemoteServerConfiguration
implements Cacheable,
Externalizable {
    private String domain;
    private Permission permission;
    private int remotePort;

    public RemoteServerConfiguration() {
    }

    public RemoteServerConfiguration(String domain) {
        this.domain = domain;
    }

    public String getDomain() {
        return this.domain;
    }

    public Permission getPermission() {
        return this.permission;
    }

    public void setPermission(Permission permission) {
        this.permission = permission;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    @Override
    public int getCachedSize() {
        int size = 0;
        size += CacheSizes.sizeOfObject();
        size += CacheSizes.sizeOfString(this.domain);
        return size += CacheSizes.sizeOfInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ExternalizableUtil.getInstance().writeSafeUTF(out, this.domain);
        ExternalizableUtil.getInstance().writeBoolean(out, this.permission != null);
        if (this.permission != null) {
            ExternalizableUtil.getInstance().writeInt(out, this.permission.ordinal());
        }
        ExternalizableUtil.getInstance().writeInt(out, this.remotePort);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.domain = ExternalizableUtil.getInstance().readSafeUTF(in);
        if (ExternalizableUtil.getInstance().readBoolean(in)) {
            this.permission = Permission.values()[ExternalizableUtil.getInstance().readInt(in)];
        }
        this.remotePort = ExternalizableUtil.getInstance().readInt(in);
    }

    public static enum Permission {
        allowed,
        blocked;

    }
}

