/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.resultsetmanager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.jivesoftware.openfire.resultsetmanager.Result;
import org.jivesoftware.openfire.resultsetmanager.ResultSet;

@Deprecated
public class ResultSetImpl<E extends Result>
extends ResultSet<E> {
    public final List<E> resultList;
    public final Map<String, Integer> uidToIndex;

    public ResultSetImpl(Collection<E> results) {
        this(results, null);
    }

    public ResultSetImpl(Collection<E> results, Comparator<E> comparator) {
        if (results == null) {
            throw new NullPointerException("Argument 'results' cannot be null.");
        }
        int size = results.size();
        this.resultList = new ArrayList(size);
        this.uidToIndex = new Hashtable<String, Integer>(size);
        ArrayList<E> sortedResults = null;
        if (comparator != null) {
            sortedResults = new ArrayList<E>(results);
            Collections.sort(sortedResults, comparator);
        }
        int index = 0;
        for (Result result : sortedResults != null ? sortedResults : results) {
            if (result == null) {
                throw new NullPointerException("The result set must not contain 'null' elements.");
            }
            String uid = result.getUID();
            if (this.uidToIndex.containsKey(uid)) {
                throw new IllegalArgumentException("The result set can not contain elements that have the same UID.");
            }
            this.resultList.add(result);
            this.uidToIndex.put(uid, index);
            ++index;
        }
    }

    @Override
    public int size() {
        return this.resultList.size();
    }

    @Override
    public List<E> getAfter(String uid, int maxAmount) {
        if (uid == null || uid.length() == 0) {
            throw new NullPointerException("Argument 'uid' cannot be null or an empty String.");
        }
        if (maxAmount < 1) {
            throw new IllegalArgumentException("Argument 'maxAmount' must be a integer higher than zero.");
        }
        int index = this.uidToIndex.get(uid) + 1;
        return this.get(index, maxAmount);
    }

    @Override
    public List<E> getBefore(String uid, int maxAmount) {
        if (uid == null || uid.length() == 0) {
            throw new NullPointerException("Argument 'uid' cannot be null or an empty String.");
        }
        if (maxAmount < 1) {
            throw new IllegalArgumentException("Argument 'maxAmount' must be a integer higher than zero.");
        }
        int indexOfLastElement = this.uidToIndex.get(uid);
        int indexOfFirstElement = indexOfLastElement - maxAmount;
        if (indexOfFirstElement < 0) {
            return this.get(0, indexOfLastElement);
        }
        return this.get(indexOfFirstElement, maxAmount);
    }

    @Override
    public E get(int index) {
        return (E)((Result)this.resultList.get(index));
    }

    @Override
    public List<E> getFirst(int maxAmount) {
        if (maxAmount < 1) {
            throw new IllegalArgumentException("Argument 'maxAmount' must be a integer higher than zero.");
        }
        return this.get(0, maxAmount);
    }

    @Override
    public List<E> getLast(int maxAmount) {
        if (maxAmount < 1) {
            throw new IllegalArgumentException("Argument 'maxAmount' must be a integer higher than zero.");
        }
        int indexOfFirstElement = this.size() - maxAmount;
        if (indexOfFirstElement < 0) {
            return this.get(0, maxAmount);
        }
        return this.get(indexOfFirstElement, maxAmount);
    }

    @Override
    public List<E> get(int fromIndex, int maxAmount) {
        if (fromIndex < 0) {
            throw new IllegalArgumentException("Argument 'fromIndex' must be zero or higher.");
        }
        if (maxAmount < 1) {
            throw new IllegalArgumentException("Argument 'maxAmount' must be a integer higher than zero.");
        }
        if (fromIndex >= this.size()) {
            return new ArrayList(0);
        }
        int absoluteTo = fromIndex + maxAmount;
        int toIndex = absoluteTo > this.size() ? this.size() : absoluteTo;
        return this.resultList.subList(fromIndex, toIndex);
    }

    @Override
    public int indexOf(String uid) {
        return this.uidToIndex.get(uid);
    }
}

