/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.pubsub.models;

import org.dom4j.Element;
import org.jivesoftware.openfire.pubsub.Node;
import org.jivesoftware.openfire.pubsub.models.AuthorizeAccess;
import org.jivesoftware.openfire.pubsub.models.OpenAccess;
import org.jivesoftware.openfire.pubsub.models.PresenceAccess;
import org.jivesoftware.openfire.pubsub.models.RosterAccess;
import org.jivesoftware.openfire.pubsub.models.WhitelistAccess;
import org.xmpp.packet.JID;
import org.xmpp.packet.PacketError;

public abstract class AccessModel {
    public static final AccessModel whitelist = new WhitelistAccess();
    public static final AccessModel open = new OpenAccess();
    public static final AccessModel authorize = new AuthorizeAccess();
    public static final AccessModel presence = new PresenceAccess();
    public static final AccessModel roster = new RosterAccess();

    public static AccessModel valueOf(String name) {
        if ("open".equals(name)) {
            return open;
        }
        if ("whitelist".equals(name)) {
            return whitelist;
        }
        if ("authorize".equals(name)) {
            return authorize;
        }
        if ("presence".equals(name)) {
            return presence;
        }
        if ("roster".equals(name)) {
            return roster;
        }
        throw new IllegalArgumentException("Unknown access model: " + name);
    }

    public abstract String getName();

    public abstract boolean canSubscribe(Node var1, JID var2, JID var3);

    public abstract boolean canAccessItems(Node var1, JID var2, JID var3);

    public abstract PacketError.Condition getSubsriptionError();

    public abstract Element getSubsriptionErrorDetail();

    public abstract boolean isAuthorizationRequired();
}

