/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.pubsub.cluster;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.jivesoftware.openfire.pubsub.Node;
import org.jivesoftware.openfire.pubsub.NodeAffiliate;
import org.jivesoftware.openfire.pubsub.cluster.NodeTask;
import org.jivesoftware.util.cache.ExternalizableUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

public class AffiliationTask
extends NodeTask {
    private static final Logger log = LoggerFactory.getLogger(AffiliationTask.class);
    private JID jid;
    private NodeAffiliate.Affiliation affiliation;

    public AffiliationTask() {
    }

    public AffiliationTask(Node node, JID jid, NodeAffiliate.Affiliation affiliation) {
        super(node);
        this.jid = jid;
        this.affiliation = affiliation;
    }

    public JID getJID() {
        return this.jid;
    }

    public NodeAffiliate.Affiliation getAffilation() {
        return this.affiliation;
    }

    @Override
    public void run() {
        log.debug("[TASK] New affiliation : {}", (Object)this.toString());
        Node node = this.getNode();
        NodeAffiliate affiliate = node.getAffiliate(this.jid);
        if (affiliate == null) {
            affiliate = new NodeAffiliate(node, this.jid);
            affiliate.setAffiliation(this.affiliation);
            node.addAffiliate(affiliate);
        } else {
            affiliate.setAffiliation(this.affiliation);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        ExternalizableUtil.getInstance().writeSerializable(out, (Serializable)this.jid);
        ExternalizableUtil.getInstance().writeSerializable(out, (Serializable)((Object)this.affiliation));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.jid = (JID)ExternalizableUtil.getInstance().readSerializable(in);
        this.affiliation = (NodeAffiliate.Affiliation)((Object)ExternalizableUtil.getInstance().readSerializable(in));
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [(service=" + this.serviceId + "), (nodeId=" + this.nodeId + "), (JID=" + this.jid + "),(affiliation=" + (Object)((Object)this.affiliation) + ")]";
    }
}

