/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.pubsub;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.openfire.pubsub.CollectionNode;
import org.jivesoftware.openfire.pubsub.Node;
import org.jivesoftware.openfire.pubsub.PubSubModule;
import org.jivesoftware.openfire.pubsub.PubSubService;
import org.jivesoftware.openfire.user.UserManager;
import org.jivesoftware.util.LocaleUtils;
import org.jivesoftware.util.ParamUtils;
import org.xmpp.forms.DataForm;
import org.xmpp.forms.FormField;
import org.xmpp.packet.JID;

public class PubSubServiceInfo {
    private PubSubService pubSubService;
    private PubSubModule pubSubModule;
    private XMPPServer xmppServer;
    private UserManager userManager;
    private GroupManager groupManager;
    private String labelPreFix = "pubsub.service.form.";
    private String variablePreFix = "pubsub#";

    public PubSubServiceInfo(PubSubService pubSubService) {
        if (pubSubService == null) {
            throw new IllegalArgumentException("Argument 'pubSubService' cannot be null.");
        }
        this.pubSubService = pubSubService;
        this.xmppServer = XMPPServer.getInstance();
        this.pubSubModule = this.xmppServer.getPubSubModule();
        this.groupManager = GroupManager.getInstance();
        this.userManager = this.xmppServer.getUserManager();
    }

    public Collection<Node> getNodes() {
        return this.pubSubService.getNodes();
    }

    public Node getNode(String nodeID) {
        return this.pubSubService.getNode(nodeID);
    }

    public List<Node> getLeafNodes() {
        ArrayList<Node> leafNodes = new ArrayList<Node>();
        for (Node node : this.pubSubService.getNodes()) {
            if (node.isCollectionNode()) continue;
            leafNodes.add(node);
        }
        return leafNodes;
    }

    public CollectionNode getRootCollectionNode() {
        return this.pubSubService.getRootCollectionNode();
    }

    public String getServiceID() {
        return this.pubSubService.getServiceID();
    }

    public DataForm getServiceConfigurationForm() {
        DataForm form = new DataForm(DataForm.Type.result);
        FormField formField = form.addField();
        formField.setVariable(this.variablePreFix + "serviceEnabled");
        formField.setType(FormField.Type.boolean_type);
        formField.setLabel(LocaleUtils.getLocalizedString(this.labelPreFix + "serviceEnabled"));
        formField.addValue((Object)this.pubSubModule.isServiceEnabled());
        formField = form.addField();
        formField.setVariable(this.variablePreFix + "nodeCreationRestricted");
        formField.setType(FormField.Type.boolean_type);
        formField.setLabel(LocaleUtils.getLocalizedString(this.labelPreFix + "nodeCreationRestricted"));
        formField.addValue((Object)this.pubSubModule.isNodeCreationRestricted());
        formField = form.addField();
        formField.setVariable(this.variablePreFix + "allowedToCreate");
        formField.setType(FormField.Type.jid_multi);
        formField.setLabel(LocaleUtils.getLocalizedString(this.labelPreFix + "allowedToCreate"));
        for (String jid : this.pubSubModule.getUsersAllowedToCreate()) {
            formField.addValue((Object)jid);
        }
        formField = form.addField();
        formField.setVariable(this.variablePreFix + "sysadmins");
        formField.setType(FormField.Type.jid_multi);
        formField.setLabel(LocaleUtils.getLocalizedString(this.labelPreFix + "sysadmins"));
        for (String jid : this.pubSubModule.getSysadmins()) {
            formField.addValue((Object)jid);
        }
        return form;
    }

    public JID getValidJID(String username) {
        if (username != null && !username.isEmpty()) {
            try {
                if (username.contains("@")) {
                    JID jid = new JID(username);
                    if (this.userManager.isRegisteredUser(jid)) {
                        return jid;
                    }
                } else if (this.userManager.isRegisteredUser(username)) {
                    return this.xmppServer.createJID(username, null);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean isValidGroup(String groupName) {
        if (groupName != null && !groupName.isEmpty()) {
            try {
                Group group = this.groupManager.getGroup(groupName);
                if (group != null) {
                    return true;
                }
            }
            catch (GroupNotFoundException groupNotFoundException) {
                // empty catch block
            }
        }
        return false;
    }

    public DataForm processForm(DataForm form, HttpServletRequest request, Collection<String> excludedFields) {
        DataForm completedForm = new DataForm(DataForm.Type.submit);
        for (FormField field : form.getFields()) {
            if (excludedFields != null && excludedFields.contains(field.getVariable())) continue;
            FormField completedField = completedForm.addField(field.getVariable(), field.getLabel(), field.getType());
            switch (field.getType()) {
                case boolean_type: {
                    completedField.addValue((Object)ParamUtils.getBooleanParameter(request, field.getVariable()));
                    break;
                }
                case jid_multi: {
                    for (String param : ParamUtils.getParameters(request, field.getVariable())) {
                        completedField.addValue((Object)param);
                    }
                    break;
                }
                case list_multi: {
                    for (String param : ParamUtils.getParameters(request, field.getVariable())) {
                        completedField.addValue((Object)param);
                    }
                    break;
                }
                case list_single: {
                    completedField.addValue((Object)ParamUtils.getParameter(request, field.getVariable()));
                    break;
                }
                case text_single: {
                    completedField.addValue((Object)ParamUtils.getParameter(request, field.getVariable()));
                    break;
                }
            }
            for (FormField.Option option : field.getOptions()) {
                completedField.addOption(option.getLabel(), option.getValue());
            }
        }
        return completedForm;
    }

    public void configureService(DataForm form) {
        for (FormField field : form.getFields()) {
            switch (field.getVariable().substring(field.getVariable().indexOf("#") + 1)) {
                case "serviceEnabled": {
                    if (field.getFirstValue() == null) break;
                    this.pubSubModule.setServiceEnabled("1".equals(field.getFirstValue()));
                    break;
                }
                case "nodeCreationRestricted": {
                    if (field.getFirstValue() == null) break;
                    this.pubSubModule.setNodeCreationRestricted("1".equals(field.getFirstValue()));
                    break;
                }
                case "allowedToCreate": {
                    this.pubSubModule.setUserAllowedToCreate(field.getValues());
                    break;
                }
                case "sysadmins": {
                    this.pubSubModule.setSysadmins(field.getValues());
                    break;
                }
            }
        }
    }

    public void validateAdditions(DataForm form, HttpServletRequest request, Map<String, listType> listTypes, Map<String, String> errors) {
        for (FormField field : form.getFields()) {
            if (!listTypes.containsKey(field.getVariable())) continue;
            switch (listTypes.get(field.getVariable())) {
                case group: {
                    if (ParamUtils.getParameter(request, field.getVariable() + "-Add") == null) break;
                    String groupName = ParamUtils.getParameter(request, field.getVariable() + "-Additional");
                    if (this.isValidGroup(groupName)) {
                        if (!field.getValues().contains(groupName)) {
                            field.addValue((Object)groupName);
                            break;
                        }
                        errors.put(field.getVariable(), LocaleUtils.getLocalizedString("pubsub.form.already_in_list", Arrays.asList(LocaleUtils.getLocalizedString("pubsub.form.group"), groupName)));
                        break;
                    }
                    errors.put(field.getVariable(), LocaleUtils.getLocalizedString("pubsub.form.not_valid", Arrays.asList(groupName, LocaleUtils.getLocalizedString("pubsub.form.group"))));
                    break;
                }
                case user: {
                    if (ParamUtils.getParameter(request, field.getVariable() + "-Add") == null) break;
                    String username = ParamUtils.getParameter(request, field.getVariable() + "-Additional");
                    JID newUser = this.getValidJID(username);
                    if (newUser != null) {
                        if (!field.getValues().contains(newUser.toBareJID())) {
                            field.addValue((Object)newUser.toBareJID());
                            break;
                        }
                        errors.put(field.getVariable(), LocaleUtils.getLocalizedString("pubsub.form.already_in_list", Arrays.asList(LocaleUtils.getLocalizedString("pubsub.form.user"), username)));
                        break;
                    }
                    errors.put(field.getVariable(), LocaleUtils.getLocalizedString("pubsub.form.not_valid", Arrays.asList(username, LocaleUtils.getLocalizedString("pubsub.form.user"))));
                    break;
                }
            }
        }
    }

    public static enum listType {
        user,
        group;

    }
}

