/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.pubsub;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.dom4j.Element;
import org.jivesoftware.openfire.pubsub.LeafNode;
import org.jivesoftware.openfire.pubsub.Node;
import org.jivesoftware.openfire.pubsub.NodeAffiliate;
import org.jivesoftware.openfire.pubsub.PubSubPersistenceManager;
import org.jivesoftware.openfire.pubsub.PublishedItem;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.LocaleUtils;
import org.jivesoftware.util.XMPPDateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.forms.DataForm;
import org.xmpp.forms.FormField;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;
import org.xmpp.packet.PacketExtension;
import org.xmpp.packet.Presence;

public class NodeSubscription {
    private static final Logger Log = LoggerFactory.getLogger(NodeSubscription.class);
    private static final XMPPDateTimeFormat xmppDateTime = new XMPPDateTimeFormat();
    private Node node;
    private JID jid;
    private JID owner;
    private String id;
    private State state;
    private boolean deliverNotifications = true;
    private boolean usingDigest = false;
    private int digestFrequency = 86400000;
    private Date expire = null;
    private boolean includingBody = false;
    private Collection<String> presenceStates = new ArrayList<String>();
    private Type type = Type.nodes;
    private int depth = 1;
    private String keyword = null;
    private boolean savedToDB = false;

    public NodeSubscription(Node node, JID owner, JID jid, State state, String id) {
        this.node = node;
        this.jid = jid;
        this.owner = owner;
        this.state = state;
        this.id = id;
    }

    public Node getNode() {
        return this.node;
    }

    public String getID() {
        return this.id;
    }

    public JID getJID() {
        return this.jid;
    }

    public JID getOwner() {
        return this.owner;
    }

    public State getState() {
        return this.state;
    }

    public boolean isConfigurationPending() {
        return this.state == State.unconfigured;
    }

    public boolean isAuthorizationPending() {
        return this.state == State.pending;
    }

    public boolean shouldDeliverNotifications() {
        return this.deliverNotifications;
    }

    public boolean isUsingDigest() {
        return this.usingDigest;
    }

    public int getDigestFrequency() {
        return this.digestFrequency;
    }

    public Date getExpire() {
        return this.expire;
    }

    public boolean isIncludingBody() {
        return this.includingBody;
    }

    public Collection<String> getPresenceStates() {
        return this.presenceStates;
    }

    public Type getType() {
        return this.type;
    }

    public int getDepth() {
        return this.depth;
    }

    public String getKeyword() {
        return this.keyword;
    }

    void setShouldDeliverNotifications(boolean deliverNotifications) {
        this.deliverNotifications = deliverNotifications;
    }

    void setUsingDigest(boolean usingDigest) {
        this.usingDigest = usingDigest;
    }

    void setDigestFrequency(int digestFrequency) {
        this.digestFrequency = digestFrequency;
    }

    void setExpire(Date expire) {
        this.expire = expire;
    }

    void setIncludingBody(boolean includingBody) {
        this.includingBody = includingBody;
    }

    void setPresenceStates(Collection<String> presenceStates) {
        this.presenceStates = presenceStates;
    }

    void setType(Type type) {
        this.type = type;
    }

    void setDepth(int depth) {
        this.depth = depth;
    }

    void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    void setSavedToDB(boolean savedToDB) {
        this.savedToDB = savedToDB;
    }

    public void configure(IQ originalIQ, DataForm options) {
        boolean wasUnconfigured = this.isConfigurationPending();
        this.configure(options);
        if (originalIQ != null) {
            this.node.getService().send((Packet)IQ.createResultIQ((IQ)originalIQ));
        }
        if (wasUnconfigured) {
            PublishedItem lastItem;
            if (this.isAuthorizationPending()) {
                this.sendAuthorizationRequest();
            }
            if (this.node.isSendItemSubscribe() && this.isActive() && (lastItem = this.node.getLastPublishedItem()) != null) {
                this.sendLastPublishedItem(lastItem);
            }
        }
    }

    void configure(DataForm options) {
        List values;
        boolean wasUsingPresence = !this.presenceStates.isEmpty();
        options.removeField("FORM_TYPE");
        FormField collectionField = options.getField("pubsub#subscription_type");
        if (collectionField != null) {
            values = collectionField.getValues();
            if (values.size() > 0) {
                this.type = Type.valueOf((String)values.get(0));
            }
            options.removeField("pubsub#subscription_type");
        }
        if ((collectionField = options.getField("pubsub#subscription_depth")) != null) {
            values = collectionField.getValues();
            this.depth = "all".equals(values.get(0)) ? 0 : 1;
            options.removeField("pubsub#subscription_depth");
        }
        for (FormField field : options.getFields()) {
            String booleanValue;
            boolean fieldExists = true;
            if ("pubsub#deliver".equals(field.getVariable())) {
                values = field.getValues();
                booleanValue = values.size() > 0 ? (String)values.get(0) : "1";
                this.deliverNotifications = "1".equals(booleanValue);
            } else if ("pubsub#digest".equals(field.getVariable())) {
                values = field.getValues();
                booleanValue = values.size() > 0 ? (String)values.get(0) : "1";
                this.usingDigest = "1".equals(booleanValue);
            } else if ("pubsub#digest_frequency".equals(field.getVariable())) {
                values = field.getValues();
                this.digestFrequency = values.size() > 0 ? Integer.parseInt((String)values.get(0)) : 86400000;
            } else if ("pubsub#expire".equals(field.getVariable())) {
                values = field.getValues();
                try {
                    this.expire = xmppDateTime.parseString((String)values.get(0));
                }
                catch (ParseException e) {
                    Log.error("Error parsing date", (Throwable)e);
                }
            } else if ("pubsub#include_body".equals(field.getVariable())) {
                values = field.getValues();
                booleanValue = values.size() > 0 ? (String)values.get(0) : "1";
                this.includingBody = "1".equals(booleanValue);
            } else if ("pubsub#show-values".equals(field.getVariable())) {
                this.presenceStates = new ArrayList<String>();
                for (String value : field.getValues()) {
                    try {
                        this.presenceStates.add(value);
                    }
                    catch (Exception exception) {}
                }
            } else if ("x-pubsub#keywords".equals(field.getVariable())) {
                values = field.getValues();
                this.keyword = values.isEmpty() ? null : (String)values.get(0);
            } else {
                fieldExists = false;
            }
            if (!fieldExists) continue;
            if (this.node.getAccessModel().isAuthorizationRequired() && !this.node.isAdmin(this.owner)) {
                this.state = State.pending;
                continue;
            }
            this.state = State.subscribed;
        }
        if (this.savedToDB) {
            PubSubPersistenceManager.saveSubscription(this.node, this, false);
        }
        if (!this.node.isPresenceBasedDelivery() && wasUsingPresence != !this.presenceStates.isEmpty()) {
            if (this.presenceStates.isEmpty()) {
                this.node.getService().presenceSubscriptionNotRequired(this.node, this.owner);
            } else {
                this.node.getService().presenceSubscriptionRequired(this.node, this.owner);
            }
        }
    }

    public DataForm getConfigurationForm() {
        DataForm form = new DataForm(DataForm.Type.form);
        form.setTitle(LocaleUtils.getLocalizedString("pubsub.form.subscription.title"));
        ArrayList<String> params = new ArrayList<String>();
        params.add(this.node.getNodeID());
        form.addInstruction(LocaleUtils.getLocalizedString("pubsub.form.subscription.instruction", params));
        FormField formField = form.addField();
        formField.setVariable("FORM_TYPE");
        formField.setType(FormField.Type.hidden);
        formField.addValue((Object)"http://jabber.org/protocol/pubsub#subscribe_options");
        formField = form.addField();
        formField.setVariable("pubsub#deliver");
        formField.setType(FormField.Type.boolean_type);
        formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.subscription.deliver"));
        formField.addValue((Object)this.deliverNotifications);
        formField = form.addField();
        formField.setVariable("pubsub#digest");
        formField.setType(FormField.Type.boolean_type);
        formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.subscription.digest"));
        formField.addValue((Object)this.usingDigest);
        formField = form.addField();
        formField.setVariable("pubsub#digest_frequency");
        formField.setType(FormField.Type.text_single);
        formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.subscription.digest_frequency"));
        formField.addValue((Object)this.digestFrequency);
        formField = form.addField();
        formField.setVariable("pubsub#expire");
        formField.setType(FormField.Type.text_single);
        formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.subscription.expire"));
        if (this.expire != null) {
            formField.addValue((Object)XMPPDateTimeFormat.format(this.expire));
        }
        formField = form.addField();
        formField.setVariable("pubsub#include_body");
        formField.setType(FormField.Type.boolean_type);
        formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.subscription.include_body"));
        formField.addValue((Object)this.includingBody);
        formField = form.addField();
        formField.setVariable("pubsub#show-values");
        formField.setType(FormField.Type.list_multi);
        formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.subscription.show-values"));
        formField.addOption(null, Presence.Show.away.name());
        formField.addOption(null, Presence.Show.chat.name());
        formField.addOption(null, Presence.Show.dnd.name());
        formField.addOption(null, "online");
        formField.addOption(null, Presence.Show.xa.name());
        for (String value : this.presenceStates) {
            formField.addValue((Object)value);
        }
        if (this.node.isCollectionNode()) {
            formField = form.addField();
            formField.setVariable("pubsub#subscription_type");
            formField.setType(FormField.Type.list_single);
            formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.subscription.subscription_type"));
            formField.addOption(null, Type.items.name());
            formField.addOption(null, Type.nodes.name());
            formField.addValue((Object)this.type);
            formField = form.addField();
            formField.setVariable("pubsub#subscription_depth");
            formField.setType(FormField.Type.list_single);
            formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.subscription.subscription_depth"));
            formField.addOption(null, "1");
            formField.addOption(null, "all");
            formField.addValue((Object)(this.depth == 1 ? "1" : "all"));
        }
        if (!this.node.isCollectionNode() || this.type == Type.items) {
            formField = form.addField();
            formField.setVariable("x-pubsub#keywords");
            formField.setType(FormField.Type.text_single);
            formField.setLabel(LocaleUtils.getLocalizedString("pubsub.form.subscription.keywords"));
            if (this.keyword != null) {
                formField.addValue((Object)this.keyword);
            }
        }
        return form;
    }

    public boolean canSendPublicationEvent(LeafNode leafNode, PublishedItem publishedItem) {
        if (!this.canSendEvents()) {
            return false;
        }
        if (publishedItem != null && !this.isKeywordMatched(publishedItem)) {
            return false;
        }
        if (this.node.isCollectionNode()) {
            if (Type.items != this.type) {
                return false;
            }
            if (this.getDepth() == 1 && !this.node.isChildNode(leafNode)) {
                return false;
            }
            if (this.getDepth() == 0 && !this.node.isDescendantNode(leafNode)) {
                return false;
            }
        }
        return true;
    }

    boolean canSendChildNodeEvent(Node originatingNode) {
        if (!this.node.isCollectionNode()) {
            return false;
        }
        if (!this.canSendEvents()) {
            return false;
        }
        if (Type.nodes != this.type) {
            return false;
        }
        if (this.getDepth() == 1 && !this.node.isChildNode(originatingNode)) {
            return false;
        }
        return this.getDepth() != 0 || this.node.isDescendantNode(originatingNode);
    }

    boolean canSendNodeEvents() {
        return this.canSendEvents();
    }

    private boolean canSendEvents() {
        Collection<String> shows;
        if (!this.isActive()) {
            return false;
        }
        if (!this.shouldDeliverNotifications()) {
            return false;
        }
        if (!this.getPresenceStates().isEmpty() && ((shows = this.node.getService().getShowPresences(this.jid)).isEmpty() || Collections.disjoint(this.getPresenceStates(), shows))) {
            return false;
        }
        return !this.node.isPresenceBasedDelivery() || !this.node.getService().getShowPresences(this.jid).isEmpty();
    }

    boolean isKeywordMatched(PublishedItem publishedItem) {
        return this.keyword == null || this.keyword.length() <= 0 || publishedItem.containsKeyword(this.keyword);
    }

    public boolean isActive() {
        if (this.state != State.subscribed) {
            return false;
        }
        return this.expire == null || !new Date().after(this.expire);
    }

    void sendSubscriptionState(IQ originalRequest) {
        IQ result = IQ.createResultIQ((IQ)originalRequest);
        Element child = result.setChildElement("pubsub", "http://jabber.org/protocol/pubsub");
        Element entity = child.addElement("subscription");
        if (!this.node.isRootCollectionNode()) {
            entity.addAttribute("node", this.node.getNodeID());
        }
        entity.addAttribute("jid", this.getJID().toString());
        if (this.node.isMultipleSubscriptionsEnabled()) {
            entity.addAttribute("subid", this.getID());
        }
        entity.addAttribute("subscription", this.getState().name());
        Element subscribeOptions = entity.addElement("subscribe-options");
        if (this.node.isSubscriptionConfigurationRequired() && this.isConfigurationPending()) {
            subscribeOptions.addElement("required");
        }
        this.node.getService().send((Packet)result);
    }

    void sendLastPublishedItem(PublishedItem publishedItem) {
        if (JiveGlobals.getBooleanProperty("xmpp.pubsub.disable-delayed-delivery", false)) {
            return;
        }
        if (!this.canSendPublicationEvent(publishedItem.getNode(), publishedItem)) {
            return;
        }
        Message notification = new Message();
        Element event = notification.getElement().addElement("event", "http://jabber.org/protocol/pubsub#event");
        Element items = event.addElement("items");
        items.addAttribute("node", this.node.getNodeID());
        Element item = items.addElement("item");
        if (((LeafNode)this.node).isItemRequired()) {
            item.addAttribute("id", publishedItem.getID());
        }
        if (this.node.isPayloadDelivered() && publishedItem.getPayload() != null) {
            item.add(publishedItem.getPayload().createCopy());
        }
        if (this.isIncludingBody()) {
            notification.setBody(LocaleUtils.getLocalizedString("pubsub.notification.message.body"));
        }
        notification.getElement().addElement("delay", "urn:xmpp:delay").addAttribute("stamp", XMPPDateTimeFormat.format(publishedItem.getCreationDate()));
        this.node.getService().sendNotification(this.node, notification, this.jid);
    }

    boolean canModify(JID user) {
        return user.equals((Object)this.getJID()) || user.equals((Object)this.getOwner()) || this.node.getService().isServiceAdmin(user);
    }

    public NodeAffiliate getAffiliate() {
        return this.node.getAffiliate(this.getOwner());
    }

    public String toString() {
        return super.toString() + " - JID: " + this.getJID() + " - State: " + this.getState().name();
    }

    void approved() {
        PublishedItem lastItem;
        if (this.state == State.subscribed) {
            return;
        }
        this.state = State.subscribed;
        if (this.savedToDB) {
            PubSubPersistenceManager.saveSubscription(this.node, this, false);
        }
        if (this.node.isSendItemSubscribe() && this.isActive() && (lastItem = this.node.getLastPublishedItem()) != null) {
            this.sendLastPublishedItem(lastItem);
        }
    }

    public void sendAuthorizationRequest(JID owner) {
        Message authRequest = new Message();
        authRequest.addExtension((PacketExtension)this.node.getAuthRequestForm(this));
        authRequest.setTo(owner);
        authRequest.setFrom(this.node.getService().getAddress());
        this.node.getService().send((Packet)authRequest);
    }

    public void sendAuthorizationRequest() {
        Message authRequest = new Message();
        authRequest.addExtension((PacketExtension)this.node.getAuthRequestForm(this));
        this.node.getService().broadcast(this.node, authRequest, this.node.getOwners());
    }

    public static enum Type {
        items,
        nodes;

    }

    public static enum State {
        none,
        pending,
        unconfigured,
        subscribed;

    }
}

