/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.nio;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.security.cert.Certificate;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.compression.CompressionFilter;
import org.apache.mina.filter.ssl.SslFilter;
import org.jivesoftware.openfire.Connection;
import org.jivesoftware.openfire.ConnectionCloseListener;
import org.jivesoftware.openfire.PacketDeliverer;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.net.StanzaHandler;
import org.jivesoftware.openfire.session.LocalSession;
import org.jivesoftware.openfire.spi.ConnectionConfiguration;
import org.jivesoftware.openfire.spi.EncryptionArtifactFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.Packet;

public class NIOConnection
implements Connection {
    private static final Logger Log = LoggerFactory.getLogger(NIOConnection.class);
    private ConnectionConfiguration configuration;
    public static final String CHARSET = "UTF-8";
    private LocalSession session;
    private IoSession ioSession;
    private ConnectionCloseListener closeListener;
    private PacketDeliverer backupDeliverer;
    private boolean flashClient = false;
    private int majorVersion = 1;
    private int minorVersion = 0;
    private String language = null;
    private Connection.TLSPolicy tlsPolicy = Connection.TLSPolicy.optional;
    private boolean usingSelfSignedCertificate;
    private Connection.CompressionPolicy compressionPolicy = Connection.CompressionPolicy.disabled;
    private static final ThreadLocal<CharsetEncoder> encoder = new ThreadLocalEncoder();
    private AtomicReference<Connection.State> state = new AtomicReference<Connection.State>(Connection.State.OPEN);
    private final ReentrantLock ioSessionLock = new ReentrantLock(true);

    public NIOConnection(IoSession session, PacketDeliverer packetDeliverer, ConnectionConfiguration configuration) {
        this.ioSession = session;
        this.backupDeliverer = packetDeliverer;
        this.configuration = configuration;
    }

    @Override
    public boolean validate() {
        if (this.isClosed()) {
            return false;
        }
        this.deliverRawText(" ");
        return !this.isClosed();
    }

    @Override
    public void registerCloseListener(ConnectionCloseListener listener, Object ignore) {
        if (this.closeListener != null) {
            throw new IllegalStateException("Close listener already configured");
        }
        if (this.isClosed()) {
            listener.onConnectionClose(this.session);
        } else {
            this.closeListener = listener;
        }
    }

    @Override
    public void removeCloseListener(ConnectionCloseListener listener) {
        if (this.closeListener == listener) {
            this.closeListener = null;
        }
    }

    @Override
    public byte[] getAddress() throws UnknownHostException {
        SocketAddress remoteAddress = this.ioSession.getRemoteAddress();
        if (remoteAddress == null) {
            throw new UnknownHostException();
        }
        InetSocketAddress socketAddress = (InetSocketAddress)remoteAddress;
        InetAddress address = socketAddress.getAddress();
        return address.getAddress();
    }

    @Override
    public String getHostAddress() throws UnknownHostException {
        SocketAddress remoteAddress = this.ioSession.getRemoteAddress();
        if (remoteAddress == null) {
            throw new UnknownHostException();
        }
        InetSocketAddress socketAddress = (InetSocketAddress)remoteAddress;
        InetAddress inetAddress = socketAddress.getAddress();
        return inetAddress.getHostAddress();
    }

    @Override
    public String getHostName() throws UnknownHostException {
        SocketAddress remoteAddress = this.ioSession.getRemoteAddress();
        if (remoteAddress == null) {
            throw new UnknownHostException();
        }
        InetSocketAddress socketAddress = (InetSocketAddress)remoteAddress;
        InetAddress inetAddress = socketAddress.getAddress();
        return inetAddress.getHostName();
    }

    @Override
    public Certificate[] getLocalCertificates() {
        SSLSession sslSession = (SSLSession)this.ioSession.getAttribute((Object)SslFilter.SSL_SESSION);
        if (sslSession != null) {
            return sslSession.getLocalCertificates();
        }
        return new Certificate[0];
    }

    @Override
    public Certificate[] getPeerCertificates() {
        block3: {
            try {
                SSLSession sslSession = (SSLSession)this.ioSession.getAttribute((Object)SslFilter.SSL_SESSION);
                if (sslSession != null) {
                    return sslSession.getPeerCertificates();
                }
            }
            catch (SSLPeerUnverifiedException e) {
                if (!Log.isTraceEnabled()) break block3;
                Log.trace("Peer does not offer certificates in session: " + this.session, (Throwable)e);
            }
        }
        return new Certificate[0];
    }

    @Override
    public void setUsingSelfSignedCertificate(boolean isSelfSigned) {
        this.usingSelfSignedCertificate = isSelfSigned;
    }

    @Override
    public boolean isUsingSelfSignedCertificate() {
        return this.usingSelfSignedCertificate;
    }

    @Override
    public PacketDeliverer getPacketDeliverer() {
        return this.backupDeliverer;
    }

    @Override
    public void close() {
        if (this.state.compareAndSet(Connection.State.OPEN, Connection.State.CLOSED)) {
            if (this.session != null) {
                this.session.setStatus(-1);
            }
            try {
                this.deliverRawText0(this.flashClient ? "</flash:stream>" : "</stream:stream>");
            }
            catch (Exception e) {
                Log.error("Failed to deliver stream close tag: " + e.getMessage());
            }
            try {
                this.ioSession.close(true);
            }
            catch (Exception e) {
                Log.error("Exception while closing MINA session", (Throwable)e);
            }
            this.notifyCloseListeners();
        }
    }

    @Override
    public void systemShutdown() {
        this.deliverRawText("<stream:error><system-shutdown xmlns='urn:ietf:params:xml:ns:xmpp-streams'/></stream:error>");
        this.close();
    }

    private void notifyCloseListeners() {
        if (this.closeListener != null) {
            try {
                this.closeListener.onConnectionClose(this.session);
            }
            catch (Exception e) {
                Log.error("Error notifying listener: " + this.closeListener, (Throwable)e);
            }
        }
    }

    @Override
    public void init(LocalSession owner) {
        this.session = owner;
    }

    @Override
    public void reinit(LocalSession owner) {
        this.session = owner;
        StanzaHandler stanzaHandler = this.getStanzaHandler();
        stanzaHandler.setSession(owner);
    }

    protected StanzaHandler getStanzaHandler() {
        return (StanzaHandler)this.ioSession.getAttribute((Object)"HANDLER");
    }

    @Override
    public boolean isClosed() {
        return this.state.get() == Connection.State.CLOSED;
    }

    @Override
    public boolean isSecure() {
        return this.ioSession.getFilterChain().contains("tls");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deliver(Packet packet) throws UnauthorizedException {
        if (this.isClosed()) {
            this.backupDeliverer.deliver(packet);
        } else {
            boolean errorDelivering = false;
            IoBuffer buffer = IoBuffer.allocate((int)4096);
            buffer.setAutoExpand(true);
            try {
                buffer.putString((CharSequence)packet.getElement().asXML(), encoder.get());
                if (this.flashClient) {
                    buffer.put((byte)0);
                }
                buffer.flip();
                this.ioSessionLock.lock();
                try {
                    this.ioSession.write((Object)buffer);
                }
                finally {
                    this.ioSessionLock.unlock();
                }
            }
            catch (Exception e) {
                Log.debug("Error delivering packet:\n" + packet, (Throwable)e);
                errorDelivering = true;
            }
            if (errorDelivering) {
                this.close();
                this.backupDeliverer.deliver(packet);
            } else {
                this.session.incrementServerPacketCount();
            }
        }
    }

    @Override
    public void deliverRawText(String text) {
        if (!this.isClosed()) {
            this.deliverRawText0(text);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverRawText0(String text) {
        boolean errorDelivering = false;
        IoBuffer buffer = IoBuffer.allocate((int)text.length());
        buffer.setAutoExpand(true);
        try {
            buffer.put(text.getBytes(StandardCharsets.UTF_8));
            if (this.flashClient) {
                buffer.put((byte)0);
            }
            buffer.flip();
            this.ioSessionLock.lock();
            try {
                this.ioSession.write((Object)buffer);
            }
            finally {
                this.ioSessionLock.unlock();
            }
        }
        catch (Exception e) {
            Log.debug("Error delivering raw text:\n" + text, (Throwable)e);
            errorDelivering = true;
        }
        if (errorDelivering) {
            this.close();
        }
    }

    @Override
    @Deprecated
    public void startTLS(boolean clientMode, String remoteServer, Connection.ClientAuth authentication) throws Exception {
        this.startTLS(clientMode);
    }

    @Override
    public void startTLS(boolean clientMode) throws Exception {
        EncryptionArtifactFactory factory = new EncryptionArtifactFactory(this.configuration);
        SslFilter filter = clientMode ? factory.createClientModeSslFilter() : factory.createServerModeSslFilter();
        this.ioSession.getFilterChain().addBefore("threadModel", "tls", (IoFilter)filter);
        this.ioSession.setAttribute((Object)SslFilter.DISABLE_ENCRYPTION_ONCE, (Object)Boolean.TRUE);
        if (!clientMode) {
            this.deliverRawText("<proceed xmlns=\"urn:ietf:params:xml:ns:xmpp-tls\"/>");
        }
    }

    @Override
    public void addCompression() {
        IoFilterChain chain = this.ioSession.getFilterChain();
        String baseFilter = "threadModel";
        if (chain.contains("tls")) {
            baseFilter = "tls";
        }
        chain.addAfter(baseFilter, "compression", (IoFilter)new CompressionFilter(true, false, 9));
    }

    @Override
    public void startCompression() {
        CompressionFilter ioFilter = (CompressionFilter)this.ioSession.getFilterChain().get("compression");
        ioFilter.setCompressOutbound(true);
    }

    @Override
    public ConnectionConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public boolean isFlashClient() {
        return this.flashClient;
    }

    @Override
    public void setFlashClient(boolean flashClient) {
        this.flashClient = flashClient;
    }

    @Override
    public int getMajorXMPPVersion() {
        return this.majorVersion;
    }

    @Override
    public int getMinorXMPPVersion() {
        return this.minorVersion;
    }

    @Override
    public void setXMPPVersion(int majorVersion, int minorVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    @Override
    public boolean isCompressed() {
        return this.ioSession.getFilterChain().contains("compression");
    }

    @Override
    public Connection.CompressionPolicy getCompressionPolicy() {
        return this.compressionPolicy;
    }

    @Override
    public void setCompressionPolicy(Connection.CompressionPolicy compressionPolicy) {
        this.compressionPolicy = compressionPolicy;
    }

    @Override
    public Connection.TLSPolicy getTlsPolicy() {
        return this.tlsPolicy;
    }

    @Override
    public void setTlsPolicy(Connection.TLSPolicy tlsPolicy) {
        this.tlsPolicy = tlsPolicy;
    }

    public String toString() {
        return super.toString() + " MINA Session: " + this.ioSession;
    }

    private static class ThreadLocalEncoder
    extends ThreadLocal<CharsetEncoder> {
        private ThreadLocalEncoder() {
        }

        @Override
        protected CharsetEncoder initialValue() {
            return StandardCharsets.UTF_8.newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        }
    }
}

