/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.nio;

import java.nio.charset.StandardCharsets;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.dom4j.io.XMPPPacketReader;
import org.jivesoftware.openfire.Connection;
import org.jivesoftware.openfire.net.MXParser;
import org.jivesoftware.openfire.net.ServerTrafficCounter;
import org.jivesoftware.openfire.net.StanzaHandler;
import org.jivesoftware.openfire.nio.NIOConnection;
import org.jivesoftware.openfire.nio.XMLLightweightParser;
import org.jivesoftware.openfire.nio.XMLNotWellFormedException;
import org.jivesoftware.openfire.spi.ConnectionConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmpp.packet.StreamError;

public abstract class ConnectionHandler
extends IoHandlerAdapter {
    private static final Logger Log = LoggerFactory.getLogger(ConnectionHandler.class);
    static final String XML_PARSER = "XML-PARSER";
    static final String HANDLER = "HANDLER";
    static final String CONNECTION = "CONNECTION";
    private static final ThreadLocal<XMPPPacketReader> PARSER_CACHE = new ThreadLocal<XMPPPacketReader>(){

        @Override
        protected XMPPPacketReader initialValue() {
            XMPPPacketReader parser = new XMPPPacketReader();
            parser.setXPPFactory(factory);
            return parser;
        }
    };
    private static XmlPullParserFactory factory = null;
    protected final ConnectionConfiguration configuration;

    protected ConnectionHandler(ConnectionConfiguration configuration) {
        this.configuration = configuration;
    }

    public void sessionOpened(IoSession session) throws Exception {
        XMLLightweightParser parser = new XMLLightweightParser(StandardCharsets.UTF_8);
        session.setAttribute((Object)XML_PARSER, (Object)parser);
        NIOConnection connection = this.createNIOConnection(session);
        session.setAttribute((Object)CONNECTION, (Object)connection);
        session.setAttribute((Object)HANDLER, (Object)this.createStanzaHandler(connection));
        int idleTime = this.getMaxIdleTime() / 2;
        if (idleTime > 0) {
            session.getConfig().setIdleTime(IdleStatus.READER_IDLE, idleTime);
        }
    }

    public void sessionClosed(IoSession session) throws Exception {
        Connection connection = (Connection)session.getAttribute((Object)CONNECTION);
        if (connection != null) {
            connection.close();
        }
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        Connection connection;
        if (session.getIdleCount(status) > 1 && (connection = (Connection)session.getAttribute((Object)CONNECTION)) != null) {
            if (Log.isDebugEnabled()) {
                Log.debug("ConnectionHandler: Closing connection that has been idle: " + connection);
            }
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        Log.warn("Closing connection due to exception in session: " + session, cause);
        try {
            StreamError error = cause != null && (cause instanceof XMLNotWellFormedException || cause.getCause() != null && cause.getCause() instanceof XMLNotWellFormedException) ? new StreamError(StreamError.Condition.not_well_formed) : new StreamError(StreamError.Condition.internal_server_error);
            Connection connection = (Connection)session.getAttribute((Object)CONNECTION);
            connection.deliverRawText(error.toXML());
        }
        finally {
            Connection connection = (Connection)session.getAttribute((Object)CONNECTION);
            if (connection != null) {
                connection.close();
            }
        }
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        block2: {
            StanzaHandler handler = (StanzaHandler)session.getAttribute((Object)HANDLER);
            XMPPPacketReader parser = PARSER_CACHE.get();
            this.updateReadBytesCounter(session);
            try {
                handler.process((String)message, parser);
            }
            catch (Exception e) {
                Log.error("Closing connection due to error while processing message: " + message, (Throwable)e);
                Connection connection = (Connection)session.getAttribute((Object)CONNECTION);
                if (connection == null) break block2;
                connection.close();
            }
        }
    }

    public void messageSent(IoSession session, Object message) throws Exception {
        super.messageSent(session, message);
        this.updateWrittenBytesCounter(session);
    }

    abstract NIOConnection createNIOConnection(IoSession var1);

    abstract StanzaHandler createStanzaHandler(NIOConnection var1);

    abstract int getMaxIdleTime();

    private void updateReadBytesCounter(IoSession session) {
        long currentBytes = session.getReadBytes();
        Long prevBytes = (Long)session.getAttribute((Object)"_read_bytes");
        long delta = prevBytes == null ? currentBytes : currentBytes - prevBytes;
        session.setAttribute((Object)"_read_bytes", (Object)currentBytes);
        ServerTrafficCounter.incrementIncomingCounter(delta);
    }

    private void updateWrittenBytesCounter(IoSession session) {
        long currentBytes = session.getWrittenBytes();
        Long prevBytes = (Long)session.getAttribute((Object)"_written_bytes");
        long delta = prevBytes == null ? currentBytes : currentBytes - prevBytes;
        session.setAttribute((Object)"_written_bytes", (Object)currentBytes);
        ServerTrafficCounter.incrementOutgoingCounter(delta);
    }

    static {
        try {
            factory = XmlPullParserFactory.newInstance((String)MXParser.class.getName(), null);
            factory.setNamespaceAware(true);
        }
        catch (XmlPullParserException e) {
            Log.error("Error creating a parser factory", (Throwable)e);
        }
    }
}

