/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.net;

import java.nio.ByteBuffer;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.jivesoftware.openfire.Connection;
import org.jivesoftware.openfire.net.TLSStatus;
import org.jivesoftware.openfire.spi.ConnectionConfiguration;
import org.jivesoftware.openfire.spi.EncryptionArtifactFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TLSWrapper {
    private static final Logger Log = LoggerFactory.getLogger(TLSWrapper.class);
    private boolean logging = false;
    private SSLEngine tlsEngine;
    private SSLEngineResult tlsEngineResult;
    private int netBuffSize;
    private int appBuffSize;
    private boolean resultOnce = true;

    @Deprecated
    public TLSWrapper(Connection connection, boolean clientMode, boolean needClientAuth, String remoteServer) {
        this(connection.getConfiguration(), clientMode);
    }

    public TLSWrapper(ConnectionConfiguration configuration, boolean clientMode) {
        try {
            EncryptionArtifactFactory factory = new EncryptionArtifactFactory(configuration);
            this.tlsEngine = clientMode ? factory.createClientModeSSLEngine() : factory.createServerModeSSLEngine();
            SSLSession sslSession = this.tlsEngine.getSession();
            this.netBuffSize = sslSession.getPacketBufferSize();
            this.appBuffSize = sslSession.getApplicationBufferSize();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException ex) {
            Log.error("TLSHandler startup problem. SSLContext initialisation failed.", (Throwable)ex);
        }
    }

    public int getNetBuffSize() {
        return this.netBuffSize;
    }

    public int getAppBuffSize() {
        return this.appBuffSize;
    }

    public boolean isEngineClosed() {
        return this.tlsEngine.isOutboundDone() && this.tlsEngine.isInboundDone();
    }

    public void enableLogging(boolean logging) {
        this.logging = logging;
    }

    public ByteBuffer unwrap(ByteBuffer net, ByteBuffer app) throws SSLException {
        ByteBuffer out = app;
        out = this.resizeApplicationBuffer(out);
        try {
            this.tlsEngineResult = this.tlsEngine.unwrap(net, out);
        }
        catch (SSLException e) {
            if (e.getMessage().startsWith("Unsupported record version Unknown-")) {
                throw new SSLException("We appear to have received plain text data where we expected encrypted data. A common cause for this is a peer sending us a plain-text error message when it shouldn't send a message, but close the socket instead).", e);
            }
            throw e;
        }
        this.log("server unwrap: ", this.tlsEngineResult);
        if (this.tlsEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            this.doTasks();
        }
        return out;
    }

    public void wrap(ByteBuffer app, ByteBuffer net) throws SSLException {
        this.tlsEngineResult = this.tlsEngine.wrap(app, net);
        this.log("server wrap: ", this.tlsEngineResult);
        if (this.tlsEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            this.doTasks();
        }
    }

    public void close() throws SSLException {
        this.tlsEngine.closeOutbound();
    }

    public TLSStatus getStatus() {
        if (this.tlsEngineResult != null && this.tlsEngineResult.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
            return TLSStatus.UNDERFLOW;
        }
        if (this.tlsEngineResult != null && this.tlsEngineResult.getStatus() == SSLEngineResult.Status.CLOSED) {
            return TLSStatus.CLOSED;
        }
        switch (this.tlsEngine.getHandshakeStatus()) {
            case NEED_WRAP: {
                return TLSStatus.NEED_WRITE;
            }
            case NEED_UNWRAP: {
                return TLSStatus.NEED_READ;
            }
        }
        return TLSStatus.OK;
    }

    private ByteBuffer resizeApplicationBuffer(ByteBuffer app) {
        if (app.remaining() < this.appBuffSize) {
            ByteBuffer bb = ByteBuffer.allocate(app.capacity() + this.appBuffSize);
            app.flip();
            bb.put(app);
            return bb;
        }
        return app;
    }

    private SSLEngineResult.HandshakeStatus doTasks() {
        Runnable runnable;
        while ((runnable = this.tlsEngine.getDelegatedTask()) != null) {
            runnable.run();
        }
        return this.tlsEngine.getHandshakeStatus();
    }

    private void log(String str, SSLEngineResult result) {
        if (!this.logging) {
            return;
        }
        if (this.resultOnce) {
            this.resultOnce = false;
            Log.info("The format of the SSLEngineResult is: \n\t\"getStatus() / getHandshakeStatus()\" +\n\t\"bytesConsumed() / bytesProduced()\"\n");
        }
        SSLEngineResult.HandshakeStatus hsStatus = result.getHandshakeStatus();
        Log.info(str + (Object)((Object)result.getStatus()) + "/" + (Object)((Object)hsStatus) + ", " + result.bytesConsumed() + "/" + result.bytesProduced() + " bytes");
        if (hsStatus == SSLEngineResult.HandshakeStatus.FINISHED) {
            Log.info("\t...ready for application data");
        }
    }

    protected SSLEngine getTlsEngine() {
        return this.tlsEngine;
    }
}

