/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.net;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.jivesoftware.openfire.net.ServerTrafficCounter;
import org.jivesoftware.openfire.net.TLSWrapper;

public class TLSStreamWriter {
    private TLSWrapper wrapper;
    private WritableByteChannel wbc;
    private ByteBuffer outAppData;

    public TLSStreamWriter(TLSWrapper tlsWrapper, Socket socket) throws IOException {
        this.wrapper = tlsWrapper;
        this.wbc = socket.getChannel() != null ? ServerTrafficCounter.wrapWritableChannel(socket.getChannel()) : Channels.newChannel(ServerTrafficCounter.wrapOutputStream(socket.getOutputStream()));
        this.outAppData = ByteBuffer.allocate(tlsWrapper.getAppBuffSize());
    }

    private void doWrite(ByteBuffer buff) throws IOException {
        if (buff == null) {
            buff = ByteBuffer.allocate(0);
        }
        if (this.wrapper == null) {
            this.writeToSocket(buff);
        } else {
            this.tlsWrite(buff);
        }
    }

    private void tlsWrite(ByteBuffer buf) throws IOException {
        do {
            ByteBuffer tlsBuffer = ByteBuffer.allocate(Math.min(buf.remaining(), this.wrapper.getAppBuffSize()));
            ByteBuffer tlsOutput = ByteBuffer.allocate(this.wrapper.getNetBuffSize());
            while (tlsBuffer.hasRemaining() && buf.hasRemaining()) {
                tlsBuffer.put(buf.get());
            }
            tlsBuffer.flip();
            this.wrapper.wrap(tlsBuffer, tlsOutput);
            tlsOutput.flip();
            this.writeToSocket(tlsOutput);
            tlsOutput.clear();
        } while (buf.hasRemaining());
    }

    private boolean writeToSocket(ByteBuffer outNetData) throws IOException {
        this.wbc.write(outNetData);
        return !outNetData.hasRemaining();
    }

    public OutputStream getOutputStream() {
        return this.createOutputStream();
    }

    private OutputStream createOutputStream() {
        return new OutputStream(){

            @Override
            public synchronized void write(int b) throws IOException {
                TLSStreamWriter.this.outAppData.put((byte)b);
                TLSStreamWriter.this.outAppData.flip();
                TLSStreamWriter.this.doWrite(TLSStreamWriter.this.outAppData);
                TLSStreamWriter.this.outAppData.clear();
            }

            @Override
            public synchronized void write(byte[] bytes, int off, int len) throws IOException {
                TLSStreamWriter.this.outAppData = TLSStreamWriter.this.resizeApplicationBuffer(bytes.length);
                TLSStreamWriter.this.outAppData.put(bytes, off, len);
                TLSStreamWriter.this.outAppData.flip();
                TLSStreamWriter.this.doWrite(TLSStreamWriter.this.outAppData);
                TLSStreamWriter.this.outAppData.clear();
            }
        };
    }

    private ByteBuffer resizeApplicationBuffer(int increment) {
        if (this.outAppData.remaining() < increment) {
            ByteBuffer bb = ByteBuffer.allocate(this.outAppData.capacity() + this.wrapper.getAppBuffSize());
            this.outAppData.flip();
            bb.put(this.outAppData);
            return bb;
        }
        return this.outAppData;
    }
}

