/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.net;

import com.jcraft.jzlib.ZOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.Channels;
import java.nio.charset.StandardCharsets;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.jivesoftware.openfire.Connection;
import org.jivesoftware.openfire.ConnectionCloseListener;
import org.jivesoftware.openfire.PacketDeliverer;
import org.jivesoftware.openfire.PacketException;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.net.ServerTrafficCounter;
import org.jivesoftware.openfire.net.SocketReader;
import org.jivesoftware.openfire.net.TLSStreamHandler;
import org.jivesoftware.openfire.net.XMLSocketWriter;
import org.jivesoftware.openfire.session.IncomingServerSession;
import org.jivesoftware.openfire.session.LocalSession;
import org.jivesoftware.openfire.spi.ConnectionConfiguration;
import org.jivesoftware.openfire.spi.ConnectionManagerImpl;
import org.jivesoftware.openfire.spi.ConnectionType;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.LocaleUtils;
import org.jivesoftware.util.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.Packet;

public class SocketConnection
implements Connection {
    private static final Logger Log = LoggerFactory.getLogger(SocketConnection.class);
    private static Map<SocketConnection, String> instances = new ConcurrentHashMap<SocketConnection, String>();
    private long idleTimeout = -1L;
    private final Map<ConnectionCloseListener, Object> listeners = new HashMap<ConnectionCloseListener, Object>();
    private Socket socket;
    private SocketReader socketReader;
    private Writer writer;
    private AtomicBoolean writing = new AtomicBoolean(false);
    private AtomicReference<Connection.State> state = new AtomicReference<Connection.State>(Connection.State.OPEN);
    private PacketDeliverer backupDeliverer;
    private LocalSession session;
    private boolean secure;
    private boolean compressed;
    private XMLWriter xmlSerializer;
    private boolean flashClient = false;
    private int majorVersion = 1;
    private int minorVersion = 0;
    private String language = null;
    private TLSStreamHandler tlsStreamHandler;
    private long writeStarted = -1L;
    private Connection.TLSPolicy tlsPolicy = Connection.TLSPolicy.optional;
    private boolean usingSelfSignedCertificate;
    private Connection.CompressionPolicy compressionPolicy = Connection.CompressionPolicy.disabled;

    public static Collection<SocketConnection> getInstances() {
        return instances.keySet();
    }

    public SocketConnection(PacketDeliverer backupDeliverer, Socket socket, boolean isSecure) throws IOException {
        if (socket == null) {
            throw new NullPointerException("Socket channel must be non-null");
        }
        this.secure = isSecure;
        this.socket = socket;
        this.writer = socket.getChannel() != null ? Channels.newWriter(ServerTrafficCounter.wrapWritableChannel(socket.getChannel()), StandardCharsets.UTF_8.newEncoder(), -1) : new BufferedWriter(new OutputStreamWriter(ServerTrafficCounter.wrapOutputStream(socket.getOutputStream()), StandardCharsets.UTF_8));
        this.backupDeliverer = backupDeliverer;
        this.xmlSerializer = new XMLSocketWriter(this.writer, this);
        instances.put(this, "");
        this.tlsPolicy = this.getConfiguration().getTlsPolicy();
    }

    public TLSStreamHandler getTLSStreamHandler() {
        return this.tlsStreamHandler;
    }

    @Override
    @Deprecated
    public void startTLS(boolean clientMode, String remoteServer, Connection.ClientAuth authentication) throws Exception {
        this.startTLS(clientMode);
    }

    @Override
    public void startTLS(boolean clientMode) throws IOException {
        if (!this.secure) {
            this.secure = true;
            if (this.session instanceof IncomingServerSession) {
                Connection.ClientAuth clientAuth = Connection.ClientAuth.needed;
            } else {
                Connection.ClientAuth clientAuth = Connection.ClientAuth.wanted;
            }
            this.tlsStreamHandler = new TLSStreamHandler(this.socket, this.getConfiguration(), clientMode);
            if (!clientMode) {
                this.deliverRawText("<proceed xmlns=\"urn:ietf:params:xml:ns:xmpp-tls\"/>");
            }
            this.tlsStreamHandler.start();
            this.writer = new BufferedWriter(new OutputStreamWriter(this.tlsStreamHandler.getOutputStream(), StandardCharsets.UTF_8));
            this.xmlSerializer = new XMLSocketWriter(this.writer, this);
        }
    }

    @Override
    public void addCompression() {
    }

    @Override
    public void startCompression() {
        this.compressed = true;
        try {
            if (this.tlsStreamHandler == null) {
                ZOutputStream out = new ZOutputStream(ServerTrafficCounter.wrapOutputStream(this.socket.getOutputStream()), 9);
                out.setFlushMode(1);
                this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8));
                this.xmlSerializer = new XMLSocketWriter(this.writer, this);
            } else {
                ZOutputStream out = new ZOutputStream(this.tlsStreamHandler.getOutputStream(), 9);
                out.setFlushMode(1);
                this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8));
                this.xmlSerializer = new XMLSocketWriter(this.writer, this);
            }
        }
        catch (IOException e) {
            Log.error("Error while starting compression", (Throwable)e);
            this.compressed = false;
        }
    }

    @Override
    public ConnectionConfiguration getConfiguration() {
        ConnectionManagerImpl connectionManager = (ConnectionManagerImpl)XMPPServer.getInstance().getConnectionManager();
        return connectionManager.getListener(ConnectionType.SOCKET_S2S, false).generateConnectionConfiguration();
    }

    @Override
    public boolean validate() {
        if (this.isClosed()) {
            return false;
        }
        boolean allowedToWrite = false;
        try {
            this.requestWriting();
            allowedToWrite = true;
            this.writeStarted();
            this.writer.write(" ");
            this.writer.flush();
        }
        catch (Exception e) {
            Log.warn("Closing no longer valid connection\n" + this.toString(), (Throwable)e);
            this.close();
        }
        finally {
            this.writeFinished();
            if (allowedToWrite) {
                this.releaseWriting();
            }
        }
        return !this.isClosed();
    }

    @Override
    public void init(LocalSession owner) {
        this.session = owner;
    }

    @Override
    public void reinit(LocalSession owner) {
        this.session = owner;
    }

    @Override
    public void registerCloseListener(ConnectionCloseListener listener, Object handbackMessage) {
        if (this.isClosed()) {
            listener.onConnectionClose(handbackMessage);
        } else {
            this.listeners.put(listener, handbackMessage);
        }
    }

    @Override
    public void removeCloseListener(ConnectionCloseListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public byte[] getAddress() throws UnknownHostException {
        return this.socket.getInetAddress().getAddress();
    }

    @Override
    public String getHostAddress() throws UnknownHostException {
        return this.socket.getInetAddress().getHostAddress();
    }

    @Override
    public String getHostName() throws UnknownHostException {
        return this.socket.getInetAddress().getHostName();
    }

    public int getPort() {
        return this.socket.getPort();
    }

    public Writer getWriter() {
        return this.writer;
    }

    @Override
    public boolean isClosed() {
        return this.state.get() == Connection.State.CLOSED;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    @Override
    public boolean isCompressed() {
        return this.compressed;
    }

    @Override
    public Connection.TLSPolicy getTlsPolicy() {
        return this.tlsPolicy;
    }

    @Override
    public void setTlsPolicy(Connection.TLSPolicy tlsPolicy) {
        this.tlsPolicy = tlsPolicy;
    }

    @Override
    public Connection.CompressionPolicy getCompressionPolicy() {
        return this.compressionPolicy;
    }

    @Override
    public void setCompressionPolicy(Connection.CompressionPolicy compressionPolicy) {
        this.compressionPolicy = compressionPolicy;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long timeout) {
        this.idleTimeout = timeout;
    }

    @Override
    public int getMajorXMPPVersion() {
        return this.majorVersion;
    }

    @Override
    public int getMinorXMPPVersion() {
        return this.minorVersion;
    }

    @Override
    public void setXMPPVersion(int majorVersion, int minorVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    @Override
    public boolean isFlashClient() {
        return this.flashClient;
    }

    @Override
    public void setFlashClient(boolean flashClient) {
        this.flashClient = flashClient;
    }

    @Override
    public Certificate[] getLocalCertificates() {
        if (this.tlsStreamHandler != null) {
            return this.tlsStreamHandler.getSSLSession().getLocalCertificates();
        }
        return new Certificate[0];
    }

    @Override
    public Certificate[] getPeerCertificates() {
        if (this.tlsStreamHandler != null) {
            try {
                return this.tlsStreamHandler.getSSLSession().getPeerCertificates();
            }
            catch (SSLPeerUnverifiedException e) {
                Log.debug("Peer certificates have not been verified - there are no certificates to return for: {}", (Object)this.tlsStreamHandler.getSSLSession().getPeerHost(), (Object)e);
            }
        }
        return new Certificate[0];
    }

    @Override
    public void setUsingSelfSignedCertificate(boolean isSelfSigned) {
        this.usingSelfSignedCertificate = isSelfSigned;
    }

    @Override
    public boolean isUsingSelfSignedCertificate() {
        return this.usingSelfSignedCertificate;
    }

    @Override
    public PacketDeliverer getPacketDeliverer() {
        return this.backupDeliverer;
    }

    public void forceClose() {
        this.close(true);
    }

    @Override
    public void close() {
        this.close(false);
    }

    private void close(boolean force) {
        if (this.state.compareAndSet(Connection.State.OPEN, Connection.State.CLOSED)) {
            if (this.session != null) {
                this.session.setStatus(-1);
            }
            if (!force) {
                boolean allowedToWrite = false;
                try {
                    this.requestWriting();
                    allowedToWrite = true;
                    this.writeStarted();
                    this.writer.write("</stream:stream>");
                    if (this.flashClient) {
                        this.writer.write(0);
                    }
                    this.writer.flush();
                }
                catch (Exception e) {
                    Log.debug("Failed to deliver stream close tag: " + e.getMessage());
                }
                this.writeFinished();
                if (allowedToWrite) {
                    this.releaseWriting();
                }
            }
            this.closeConnection();
            this.notifyCloseListeners();
        }
    }

    @Override
    public void systemShutdown() {
        this.deliverRawText("<stream:error><system-shutdown xmlns='urn:ietf:params:xml:ns:xmpp-streams'/></stream:error>");
        this.close();
    }

    void writeStarted() {
        this.writeStarted = System.currentTimeMillis();
    }

    void writeFinished() {
        this.writeStarted = -1L;
    }

    boolean checkHealth() {
        long writeTimestamp = this.writeStarted;
        if (writeTimestamp > -1L && System.currentTimeMillis() - writeTimestamp > (long)JiveGlobals.getIntProperty("xmpp.session.sending-limit", 60000)) {
            if (Log.isDebugEnabled()) {
                Log.debug("Closing connection: " + this + " that started sending data at: " + new Date(writeTimestamp));
            }
            this.forceClose();
            return true;
        }
        if (this.idleTimeout > -1L && this.socketReader != null && System.currentTimeMillis() - this.socketReader.getLastActive() > this.idleTimeout) {
            if (Log.isDebugEnabled()) {
                Log.debug("Closing connection that has been idle: " + this);
            }
            this.forceClose();
            return true;
        }
        return false;
    }

    private void release() {
        this.writeStarted = -1L;
        instances.remove(this);
    }

    private void closeConnection() {
        this.release();
        try {
            if (this.tlsStreamHandler == null) {
                this.socket.close();
            } else {
                this.tlsStreamHandler.close();
            }
        }
        catch (Exception e) {
            Log.error(LocaleUtils.getLocalizedString("admin.error.close") + "\n" + this.toString(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deliver(Packet packet) throws UnauthorizedException, PacketException {
        if (this.isClosed()) {
            this.backupDeliverer.deliver(packet);
        } else {
            boolean errorDelivering = false;
            boolean allowedToWrite = false;
            try {
                this.requestWriting();
                allowedToWrite = true;
                this.xmlSerializer.write(packet.getElement());
                if (this.flashClient) {
                    this.writer.write(0);
                }
                this.xmlSerializer.flush();
            }
            catch (Exception e) {
                Log.debug("Error delivering packet\n" + this.toString(), (Throwable)e);
                errorDelivering = true;
            }
            finally {
                if (allowedToWrite) {
                    this.releaseWriting();
                }
            }
            if (errorDelivering) {
                this.close();
                this.backupDeliverer.deliver(packet);
            } else {
                this.session.incrementServerPacketCount();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deliverRawText(String text) {
        if (!this.isClosed()) {
            boolean errorDelivering = false;
            boolean allowedToWrite = false;
            try {
                this.requestWriting();
                allowedToWrite = true;
                this.writeStarted();
                this.writer.write(text);
                if (this.flashClient) {
                    this.writer.write(0);
                }
                this.writer.flush();
            }
            catch (Exception e) {
                Log.debug("Error delivering raw text\n" + this.toString(), (Throwable)e);
                errorDelivering = true;
            }
            finally {
                this.writeFinished();
                if (allowedToWrite) {
                    this.releaseWriting();
                }
            }
            if (errorDelivering) {
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCloseListeners() {
        Map<ConnectionCloseListener, Object> map = this.listeners;
        synchronized (map) {
            for (ConnectionCloseListener listener : this.listeners.keySet()) {
                try {
                    listener.onConnectionClose(this.listeners.get(listener));
                }
                catch (Exception e) {
                    Log.error("Error notifying listener: " + listener, (Throwable)e);
                }
            }
        }
    }

    private void requestWriting() throws Exception {
        while (!this.writing.compareAndSet(false, true)) {
            if (this.checkHealth()) {
                throw new Exception("Probable dead connection was closed");
            }
            Thread.sleep(1L);
        }
        return;
    }

    private void releaseWriting() {
        this.writing.compareAndSet(true, false);
    }

    public String toString() {
        return super.toString() + " socket: " + this.socket + " session: " + this.session;
    }

    public void setSocketReader(SocketReader socketReader) {
        this.socketReader = socketReader;
    }
}

