/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.net;

import java.io.IOException;
import java.net.Socket;
import org.dom4j.Element;
import org.jivesoftware.openfire.PacketRouter;
import org.jivesoftware.openfire.RoutingTable;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.interceptor.PacketRejectedException;
import org.jivesoftware.openfire.net.SocketConnection;
import org.jivesoftware.openfire.net.SocketReader;
import org.jivesoftware.openfire.session.LocalIncomingServerSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParserException;
import org.xmpp.packet.IQ;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;
import org.xmpp.packet.Presence;
import org.xmpp.packet.StreamError;

public class ServerSocketReader
extends SocketReader {
    private static final Logger Log = LoggerFactory.getLogger(ServerSocketReader.class);

    public ServerSocketReader(PacketRouter router, RoutingTable routingTable, String serverName, Socket socket, SocketConnection connection, boolean useBlockingMode) {
        super(router, routingTable, serverName, socket, connection, useBlockingMode);
    }

    @Override
    protected void processIQ(IQ packet) throws UnauthorizedException {
        try {
            this.packetReceived((Packet)packet);
            try {
                super.processIQ(packet);
            }
            catch (UnauthorizedException e) {
                Log.error("Error processing packet", (Throwable)e);
            }
        }
        catch (PacketRejectedException e) {
            Log.debug("IQ rejected: " + packet.toXML(), (Throwable)e);
        }
    }

    @Override
    protected void processPresence(Presence packet) throws UnauthorizedException {
        try {
            this.packetReceived((Packet)packet);
            try {
                super.processPresence(packet);
            }
            catch (UnauthorizedException e) {
                Log.error("Error processing packet", (Throwable)e);
            }
        }
        catch (PacketRejectedException e) {
            Log.debug("Presence rejected: " + packet.toXML(), (Throwable)e);
        }
    }

    @Override
    protected void processMessage(Message packet) throws UnauthorizedException {
        try {
            this.packetReceived((Packet)packet);
            try {
                ServerSocketReader.super.processMessage(packet);
            }
            catch (UnauthorizedException e) {
                Log.error("Error processing packet", (Throwable)e);
            }
        }
        catch (PacketRejectedException e) {
            Log.debug("Message rejected: " + packet.toXML(), (Throwable)e);
        }
    }

    @Override
    protected boolean processUnknowPacket(Element doc) {
        if ("db".equals(doc.getNamespacePrefix()) && "result".equals(doc.getName())) {
            if (!((LocalIncomingServerSession)this.session).validateSubsequentDomain(doc)) {
                this.open = false;
            }
            return true;
        }
        if ("db".equals(doc.getNamespacePrefix()) && "verify".equals(doc.getName())) {
            ((LocalIncomingServerSession)this.session).verifyReceivedKey(doc);
            return true;
        }
        return false;
    }

    private void packetReceived(Packet packet) throws PacketRejectedException {
        if (packet.getTo() == null || packet.getFrom() == null) {
            Log.debug("Closing IncomingServerSession due to packet with no TO or FROM: " + packet.toXML());
            StreamError error = new StreamError(StreamError.Condition.improper_addressing);
            this.connection.deliverRawText(error.toXML());
            this.connection.close();
            this.open = false;
            throw new PacketRejectedException("Packet with no TO or FROM attributes");
        }
        if (!((LocalIncomingServerSession)this.session).isValidDomain(packet.getFrom().getDomain())) {
            Log.debug("Closing IncomingServerSession due to packet with invalid domain: " + packet.toXML());
            StreamError error = new StreamError(StreamError.Condition.invalid_from);
            this.connection.deliverRawText(error.toXML());
            this.connection.close();
            this.open = false;
            throw new PacketRejectedException("Packet with no TO or FROM attributes");
        }
    }

    @Override
    protected void shutdown() {
        super.shutdown();
    }

    @Override
    boolean createSession(String namespace) throws UnauthorizedException, XmlPullParserException, IOException {
        if ("jabber:server".equals(namespace)) {
            this.session = LocalIncomingServerSession.createSession(this.serverName, this.reader, this.connection);
            return true;
        }
        return false;
    }

    @Override
    String getNamespace() {
        return "jabber:server";
    }

    @Override
    public String getExtraNamespaces() {
        return "xmlns:db=\"jabber:server:dialback\"";
    }

    @Override
    String getName() {
        return "Server SR - " + this.hashCode();
    }

    @Override
    boolean validateHost() {
        return true;
    }
}

