/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.net;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DNSUtil {
    private static DirContext context;
    private static final Logger logger;
    private static Map<String, HostAddress> dnsOverride;

    public static List<HostAddress> resolveXMPPDomain(String domain, int defaultPort) {
        LinkedList<HostAddress> results = new LinkedList<HostAddress>();
        if (dnsOverride != null) {
            HostAddress hostAddress = dnsOverride.get(domain);
            if (hostAddress == null) {
                hostAddress = dnsOverride.get("*");
            }
            if (hostAddress != null) {
                results.add(hostAddress);
                return results;
            }
        }
        results.addAll(DNSUtil.srvLookup("xmpp-server", "tcp", domain));
        if (results.isEmpty()) {
            results.addAll(DNSUtil.srvLookup("jabber", "tcp", domain));
        }
        if (results.isEmpty()) {
            results.add(new HostAddress(domain, defaultPort));
        }
        return results;
    }

    public static Map<String, HostAddress> getDnsOverride() {
        return dnsOverride;
    }

    public static void setDnsOverride(Map<String, HostAddress> dnsOverride) {
        DNSUtil.dnsOverride = dnsOverride;
        JiveGlobals.setProperty("dnsutil.dnsOverride", DNSUtil.encode(dnsOverride));
    }

    private static String encode(Map<String, HostAddress> internalDNS) {
        if (internalDNS == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(100);
        for (String key : internalDNS.keySet()) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append('{').append(key).append(',');
            sb.append(internalDNS.get(key).getHost()).append(':');
            sb.append(internalDNS.get(key).getPort()).append('}');
        }
        return sb.toString();
    }

    private static Map<String, HostAddress> decode(String encodedValue) {
        HashMap<String, HostAddress> answer = new HashMap<String, HostAddress>();
        StringTokenizer st = new StringTokenizer(encodedValue, "{},:");
        while (st.hasMoreElements()) {
            String key = st.nextToken();
            answer.put(key, new HostAddress(st.nextToken(), Integer.parseInt(st.nextToken())));
        }
        return answer;
    }

    public static List<WeightedHostAddress> srvLookup(String service, String proto, String name) {
        if (service == null || proto == null || name == null) {
            throw new NullPointerException("DNS lookup can't be null");
        }
        if (!service.startsWith("_")) {
            service = "_" + service;
        }
        if (!service.endsWith(".")) {
            service = service + ".";
        }
        if (!proto.startsWith("_")) {
            proto = "_" + proto;
        }
        if (!proto.endsWith(".")) {
            proto = proto + ".";
        }
        if (!name.endsWith(".")) {
            name = name + ".";
        }
        String lookup = (service + proto + name).toLowerCase();
        try {
            Attributes dnsLookup = context.getAttributes(lookup, new String[]{"SRV"});
            Attribute srvRecords = dnsLookup.get("SRV");
            if (srvRecords == null) {
                logger.debug("No SRV record found for domain: " + lookup);
                return Collections.emptyList();
            }
            WeightedHostAddress[] hosts = new WeightedHostAddress[srvRecords.size()];
            for (int i = 0; i < srvRecords.size(); ++i) {
                hosts[i] = new WeightedHostAddress(((String)srvRecords.get(i)).split(" "));
            }
            return DNSUtil.prioritize(hosts);
        }
        catch (NameNotFoundException e) {
            logger.debug("No SRV record found for: " + lookup, (Throwable)e);
        }
        catch (NamingException e) {
            logger.error("Can't process DNS lookup!", (Throwable)e);
        }
        return Collections.emptyList();
    }

    public static boolean isNameCoveredByPattern(String name, String pattern) {
        String hayStack;
        if (name == null || name.isEmpty() || pattern == null || pattern.isEmpty()) {
            throw new IllegalArgumentException("Arguments cannot be null or empty.");
        }
        String needle = name.toLowerCase();
        if (needle.equals(hayStack = pattern.toLowerCase())) {
            return true;
        }
        if (hayStack.startsWith("*.")) {
            return needle.endsWith(hayStack.substring(2));
        }
        return false;
    }

    public static List<WeightedHostAddress> prioritize(WeightedHostAddress[] records) {
        LinkedList<WeightedHostAddress> result = new LinkedList<WeightedHostAddress>();
        TreeMap byPriority = new TreeMap();
        for (WeightedHostAddress record : records) {
            if (byPriority.containsKey(record.getPriority())) {
                ((Set)byPriority.get(record.getPriority())).add(record);
                continue;
            }
            HashSet<WeightedHostAddress> set = new HashSet<WeightedHostAddress>();
            set.add(record);
            byPriority.put(record.getPriority(), set);
        }
        for (Map.Entry entry : byPriority.entrySet()) {
            LinkedList<WeightedHostAddress> zeroWeights = new LinkedList<WeightedHostAddress>();
            int totalWeight = 0;
            Iterator i = ((Set)entry.getValue()).iterator();
            while (i.hasNext()) {
                WeightedHostAddress next = (WeightedHostAddress)i.next();
                if (next.weight == 0) {
                    zeroWeights.add(next);
                    i.remove();
                    continue;
                }
                totalWeight += next.getWeight();
            }
            int iterationWeight = totalWeight;
            Iterator iter = ((Set)entry.getValue()).iterator();
            while (iter.hasNext()) {
                WeightedHostAddress record;
                int needle = new Random().nextInt(iterationWeight);
                while ((needle -= (record = (WeightedHostAddress)iter.next()).getWeight()) > 0) {
                }
                result.add(record);
                iter.remove();
                iterationWeight -= record.getWeight();
                iter = ((Set)entry.getValue()).iterator();
            }
            Collections.shuffle(zeroWeights);
            for (WeightedHostAddress zero : zeroWeights) {
                result.add(zero);
            }
        }
        return result;
    }

    static {
        logger = LoggerFactory.getLogger(DNSUtil.class);
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            context = new InitialDirContext(env);
            String property = JiveGlobals.getProperty("dnsutil.dnsOverride");
            if (property != null) {
                dnsOverride = DNSUtil.decode(property);
            }
        }
        catch (Exception e) {
            logger.error("Can't initialize DNS context!", (Throwable)e);
        }
    }

    public static class WeightedHostAddress
    extends HostAddress {
        private final int priority;
        private final int weight;

        private WeightedHostAddress(String[] srvRecordEntries) {
            super(srvRecordEntries[srvRecordEntries.length - 1], Integer.parseInt(srvRecordEntries[srvRecordEntries.length - 2]));
            this.weight = Integer.parseInt(srvRecordEntries[srvRecordEntries.length - 3]);
            this.priority = Integer.parseInt(srvRecordEntries[srvRecordEntries.length - 4]);
        }

        WeightedHostAddress(String host, int port, int priority, int weight) {
            super(host, port);
            this.priority = priority;
            this.weight = weight;
        }

        public int getPriority() {
            return this.priority;
        }

        public int getWeight() {
            return this.weight;
        }
    }

    public static class HostAddress {
        private final String host;
        private final int port;

        private HostAddress(String host, int port) {
            this.host = host.endsWith(".") ? host.substring(0, host.length() - 1) : host;
            this.port = port;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String toString() {
            return this.host + ":" + this.port;
        }
    }
}

