/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.net;

import org.dom4j.Element;
import org.jivesoftware.openfire.Connection;
import org.jivesoftware.openfire.PacketRouter;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.component.InternalComponentManager;
import org.jivesoftware.openfire.net.StanzaHandler;
import org.jivesoftware.openfire.session.ComponentSession;
import org.jivesoftware.openfire.session.LocalComponentSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmpp.component.ComponentException;
import org.xmpp.packet.IQ;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;
import org.xmpp.packet.PacketError;
import org.xmpp.packet.Presence;

public class ComponentStanzaHandler
extends StanzaHandler {
    private static final Logger Log = LoggerFactory.getLogger(ComponentStanzaHandler.class);

    public ComponentStanzaHandler(PacketRouter router, Connection connection) {
        super(router, connection);
    }

    @Deprecated
    public ComponentStanzaHandler(PacketRouter router, String serverName, Connection connection) {
        super(router, connection);
    }

    @Override
    boolean processUnknowPacket(Element doc) throws UnauthorizedException {
        String tag = doc.getName();
        if ("handshake".equals(tag)) {
            if (!((LocalComponentSession)this.session).authenticate(doc.getStringValue())) {
                this.session.close();
            }
            return true;
        }
        if ("error".equals(tag) && "stream".equals(doc.getNamespacePrefix())) {
            this.session.close();
            return true;
        }
        if ("bind".equals(tag)) {
            LocalComponentSession componentSession = (LocalComponentSession)this.session;
            ComponentSession.ExternalComponent component = componentSession.getExternalComponent();
            String initialDomain = component.getInitialSubdomain();
            String extraDomain = doc.attributeValue("name");
            String allowMultiple = doc.attributeValue("allowMultiple");
            if (extraDomain == null || "".equals(extraDomain)) {
                Element reply = doc.createCopy();
                reply.add(new PacketError(PacketError.Condition.bad_request).getElement());
                this.connection.deliverRawText(reply.asXML());
            } else if (extraDomain.equals(initialDomain)) {
                this.connection.deliverRawText("<bind/>");
            } else if (extraDomain.endsWith(initialDomain)) {
                if (allowMultiple != null && component.getSubdomains().contains(extraDomain)) {
                    Element reply = doc.createCopy();
                    reply.add(new PacketError(PacketError.Condition.conflict).getElement());
                    this.connection.deliverRawText(reply.asXML());
                } else {
                    try {
                        String subdomain = extraDomain;
                        int index = extraDomain.indexOf(XMPPServer.getInstance().getServerInfo().getXMPPDomain());
                        if (index > -1) {
                            subdomain = extraDomain.substring(0, index - 1);
                        }
                        InternalComponentManager.getInstance().addComponent(subdomain, component);
                        this.connection.deliverRawText("<bind/>");
                    }
                    catch (ComponentException e) {
                        Log.error("Error binding extra domain: " + extraDomain + " to component: " + component, (Throwable)e);
                        Element reply = doc.createCopy();
                        reply.add(new PacketError(PacketError.Condition.internal_server_error).getElement());
                        this.connection.deliverRawText(reply.asXML());
                    }
                }
            } else {
                Element reply = doc.createCopy();
                reply.add(new PacketError(PacketError.Condition.forbidden).getElement());
                this.connection.deliverRawText(reply.asXML());
            }
            return true;
        }
        return false;
    }

    @Override
    protected void processIQ(IQ packet) throws UnauthorizedException {
        if (this.session.getStatus() != 3) {
            IQ reply = new IQ();
            reply.setChildElement(packet.getChildElement().createCopy());
            reply.setID(packet.getID());
            reply.setTo(packet.getFrom());
            reply.setFrom(packet.getTo());
            reply.setError(PacketError.Condition.not_authorized);
            this.session.process((Packet)reply);
            return;
        }
        if (packet.getType() == IQ.Type.get || packet.getType() == IQ.Type.set) {
            LocalComponentSession componentSession = (LocalComponentSession)this.session;
            LocalComponentSession.LocalExternalComponent component = (LocalComponentSession.LocalExternalComponent)componentSession.getExternalComponent();
            component.track(packet);
        }
        super.processIQ(packet);
    }

    @Override
    protected void processPresence(Presence packet) throws UnauthorizedException {
        if (this.session.getStatus() != 3) {
            Presence reply = new Presence();
            reply.setID(packet.getID());
            reply.setTo(packet.getFrom());
            reply.setFrom(packet.getTo());
            reply.setError(PacketError.Condition.not_authorized);
            this.session.process((Packet)reply);
            return;
        }
        super.processPresence(packet);
    }

    @Override
    protected void processMessage(Message packet) throws UnauthorizedException {
        if (this.session.getStatus() != 3) {
            Message reply = new Message();
            reply.setID(packet.getID());
            reply.setTo(packet.getFrom());
            reply.setFrom(packet.getTo());
            reply.setError(PacketError.Condition.not_authorized);
            this.session.process((Packet)reply);
            return;
        }
        super.processMessage(packet);
    }

    @Override
    void startTLS() throws Exception {
        this.connection.startTLS(false);
    }

    @Override
    String getNamespace() {
        return "jabber:component:accept";
    }

    @Override
    boolean validateHost() {
        return false;
    }

    @Override
    boolean validateJIDs() {
        return false;
    }

    @Override
    boolean createSession(String namespace, String serverName, XmlPullParser xpp, Connection connection) throws XmlPullParserException {
        if (this.getNamespace().equals(namespace)) {
            this.session = LocalComponentSession.createSession(serverName, xpp, connection);
            return true;
        }
        return false;
    }
}

