/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.multiplex;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.dom4j.Element;
import org.jivesoftware.openfire.StreamID;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.multiplex.ConnectionMultiplexerManager;
import org.jivesoftware.openfire.multiplex.Route;
import org.jivesoftware.openfire.net.VirtualConnection;
import org.jivesoftware.openfire.session.ConnectionMultiplexerSession;
import org.jivesoftware.openfire.spi.ConnectionConfiguration;
import org.jivesoftware.openfire.spi.ConnectionManagerImpl;
import org.jivesoftware.openfire.spi.ConnectionType;
import org.xmpp.packet.IQ;
import org.xmpp.packet.Packet;

public class ClientSessionConnection
extends VirtualConnection {
    private String connectionManagerName;
    private String serverName;
    private ConnectionMultiplexerManager multiplexerManager;
    private String hostName;
    private String hostAddress;

    public ClientSessionConnection(String connectionManagerName, String hostName, String hostAddress) {
        this.connectionManagerName = connectionManagerName;
        this.multiplexerManager = ConnectionMultiplexerManager.getInstance();
        this.serverName = XMPPServer.getInstance().getServerInfo().getXMPPDomain();
        this.hostName = hostName;
        this.hostAddress = hostAddress;
    }

    @Override
    public void deliver(Packet packet) {
        StreamID streamID = this.session.getStreamID();
        ConnectionMultiplexerSession multiplexerSession = this.multiplexerManager.getMultiplexerSession(this.connectionManagerName, streamID);
        if (multiplexerSession != null) {
            Route wrapper = new Route(streamID);
            wrapper.setFrom(this.serverName);
            wrapper.setTo(this.connectionManagerName);
            wrapper.setChildElement(packet.getElement().createCopy());
            multiplexerSession.process(wrapper);
            this.session.incrementServerPacketCount();
        }
    }

    @Override
    public void deliverRawText(String text) {
        StreamID streamID = this.session.getStreamID();
        ConnectionMultiplexerSession multiplexerSession = this.multiplexerManager.getMultiplexerSession(this.connectionManagerName, streamID);
        if (multiplexerSession != null) {
            StringBuilder sb = new StringBuilder(200 + text.length());
            sb.append("<route from=\"").append(this.serverName);
            sb.append("\" to=\"").append(this.connectionManagerName);
            sb.append("\" streamid=\"").append(streamID.getID()).append("\">");
            sb.append(text);
            sb.append("</route>");
            multiplexerSession.deliverRawText(sb.toString());
        }
    }

    @Override
    public ConnectionConfiguration getConfiguration() {
        ConnectionManagerImpl connectionManager = (ConnectionManagerImpl)XMPPServer.getInstance().getConnectionManager();
        return connectionManager.getListener(ConnectionType.SOCKET_C2S, true).generateConnectionConfiguration();
    }

    @Override
    public byte[] getAddress() throws UnknownHostException {
        if (this.hostAddress != null) {
            return InetAddress.getByName(this.hostAddress).getAddress();
        }
        return null;
    }

    @Override
    public String getHostAddress() throws UnknownHostException {
        if (this.hostAddress != null) {
            return this.hostAddress;
        }
        ConnectionMultiplexerSession multiplexerSession = this.multiplexerManager.getMultiplexerSession(this.connectionManagerName);
        if (multiplexerSession != null) {
            return multiplexerSession.getHostAddress();
        }
        return null;
    }

    @Override
    public String getHostName() throws UnknownHostException {
        if (this.hostName != null) {
            return this.hostName;
        }
        ConnectionMultiplexerSession multiplexerSession = this.multiplexerManager.getMultiplexerSession(this.connectionManagerName);
        if (multiplexerSession != null) {
            return multiplexerSession.getHostName();
        }
        return null;
    }

    @Override
    public void systemShutdown() {
    }

    @Override
    public void closeVirtualConnection() {
        ConnectionMultiplexerSession multiplexerSession;
        StreamID streamID = this.session.getStreamID();
        if (this.multiplexerManager.getClientSession(this.connectionManagerName, streamID) != null && (multiplexerSession = this.multiplexerManager.getMultiplexerSession(this.connectionManagerName, streamID)) != null) {
            IQ closeRequest = new IQ(IQ.Type.set);
            closeRequest.setFrom(this.serverName);
            closeRequest.setTo(this.connectionManagerName);
            Element child = closeRequest.setChildElement("session", "http://jabber.org/protocol/connectionmanager");
            child.addAttribute("id", streamID.getID());
            child.addElement("close");
            multiplexerSession.process((Packet)closeRequest);
        }
    }
}

