/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.muc.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.jivesoftware.openfire.PacketRouter;
import org.jivesoftware.openfire.RoutingTable;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.XMPPServerListener;
import org.jivesoftware.openfire.auth.UnauthorizedException;
import org.jivesoftware.openfire.cluster.ClusterManager;
import org.jivesoftware.openfire.disco.DiscoInfoProvider;
import org.jivesoftware.openfire.disco.DiscoItem;
import org.jivesoftware.openfire.disco.DiscoItemsProvider;
import org.jivesoftware.openfire.disco.DiscoServerItem;
import org.jivesoftware.openfire.disco.ServerItemsProvider;
import org.jivesoftware.openfire.event.GroupEventDispatcher;
import org.jivesoftware.openfire.group.ConcurrentGroupList;
import org.jivesoftware.openfire.group.GroupAwareList;
import org.jivesoftware.openfire.group.GroupJID;
import org.jivesoftware.openfire.handler.IQHandler;
import org.jivesoftware.openfire.muc.HistoryStrategy;
import org.jivesoftware.openfire.muc.MUCEventDelegate;
import org.jivesoftware.openfire.muc.MUCEventDispatcher;
import org.jivesoftware.openfire.muc.MUCRole;
import org.jivesoftware.openfire.muc.MUCRoom;
import org.jivesoftware.openfire.muc.MUCUser;
import org.jivesoftware.openfire.muc.MultiUserChatService;
import org.jivesoftware.openfire.muc.NotAllowedException;
import org.jivesoftware.openfire.muc.cluster.GetNumberConnectedUsers;
import org.jivesoftware.openfire.muc.cluster.OccupantAddedEvent;
import org.jivesoftware.openfire.muc.cluster.RoomAvailableEvent;
import org.jivesoftware.openfire.muc.cluster.RoomRemovedEvent;
import org.jivesoftware.openfire.muc.spi.ConversationLogEntry;
import org.jivesoftware.openfire.muc.spi.IQMUCRegisterHandler;
import org.jivesoftware.openfire.muc.spi.IQMUCSearchHandler;
import org.jivesoftware.openfire.muc.spi.LocalMUCRole;
import org.jivesoftware.openfire.muc.spi.LocalMUCRoom;
import org.jivesoftware.openfire.muc.spi.LocalMUCRoomManager;
import org.jivesoftware.openfire.muc.spi.LocalMUCUser;
import org.jivesoftware.openfire.muc.spi.MUCPersistenceManager;
import org.jivesoftware.openfire.muc.spi.RemoteMUCUser;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.JiveProperties;
import org.jivesoftware.util.LocaleUtils;
import org.jivesoftware.util.TaskEngine;
import org.jivesoftware.util.XMPPDateTimeFormat;
import org.jivesoftware.util.cache.CacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.component.Component;
import org.xmpp.component.ComponentManager;
import org.xmpp.forms.DataForm;
import org.xmpp.forms.FormField;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;
import org.xmpp.packet.Packet;
import org.xmpp.packet.PacketError;
import org.xmpp.packet.Presence;

public class MultiUserChatServiceImpl
implements Component,
MultiUserChatService,
ServerItemsProvider,
DiscoInfoProvider,
DiscoItemsProvider,
XMPPServerListener {
    private static final Logger Log = LoggerFactory.getLogger(MultiUserChatServiceImpl.class);
    private int user_timeout = 300000;
    private int user_idle = -1;
    private UserTimeoutTask userTimeoutTask;
    private int log_timeout = 300000;
    private int log_batch_size = 50;
    private LogConversationTask logConversationTask;
    private final String chatServiceName;
    private String chatDescription = null;
    private LocalMUCRoomManager localMUCRoomManager = new LocalMUCRoomManager();
    private Map<JID, LocalMUCUser> users = new ConcurrentHashMap<JID, LocalMUCUser>();
    private HistoryStrategy historyStrategy;
    private RoutingTable routingTable = null;
    private PacketRouter router = null;
    private IQMUCRegisterHandler registerHandler = null;
    private IQMUCSearchHandler searchHandler = null;
    private Map<String, IQHandler> iqHandlers = null;
    public long totalChatTime;
    private boolean allowToDiscoverLockedRooms = true;
    private boolean allowToDiscoverMembersOnlyRooms = false;
    private boolean roomCreationRestricted = false;
    private GroupAwareList<JID> allowedToCreate = new ConcurrentGroupList<JID>();
    private GroupAwareList<JID> sysadmins = new ConcurrentGroupList<JID>();
    private Queue<ConversationLogEntry> logQueue = new LinkedBlockingQueue<ConversationLogEntry>(100000);
    private long emptyLimit = 720L;
    private CleanupTask cleanupTask;
    private static final long CLEANUP_FREQUENCY = 3600000L;
    private AtomicInteger inMessages = new AtomicInteger(0);
    private AtomicLong outMessages = new AtomicLong(0L);
    private boolean serviceEnabled = true;
    private boolean isHidden = true;
    protected MUCEventDelegate mucEventDelegate;
    private List<String> extraDiscoFeatures = new ArrayList<String>();
    private List<Element> extraDiscoIdentities = new ArrayList<Element>();

    public MultiUserChatServiceImpl(String subdomain, String description, Boolean isHidden) {
        new JID(null, subdomain + "." + XMPPServer.getInstance().getServerInfo().getXMPPDomain(), null);
        this.chatServiceName = subdomain;
        this.chatDescription = description != null && description.trim().length() > 0 ? description : LocaleUtils.getLocalizedString("muc.service-name");
        this.isHidden = isHidden;
        this.historyStrategy = new HistoryStrategy(null);
    }

    @Override
    public void addIQHandler(IQHandler iqHandler) {
        if (this.iqHandlers == null) {
            this.iqHandlers = new HashMap<String, IQHandler>();
        }
        this.iqHandlers.put(iqHandler.getInfo().getNamespace(), iqHandler);
    }

    @Override
    public void removeIQHandler(IQHandler iqHandler) {
        if (this.iqHandlers != null && iqHandler == this.iqHandlers.get(iqHandler.getInfo().getNamespace())) {
            this.iqHandlers.remove(iqHandler.getInfo().getNamespace());
        }
    }

    public String getDescription() {
        return this.chatDescription;
    }

    public void setDescription(String desc) {
        this.chatDescription = desc;
    }

    public void processPacket(Packet packet) {
        if (!this.isServiceEnabled()) {
            return;
        }
        try {
            Presence pres;
            if (packet instanceof IQ) {
                if (this.process((IQ)packet)) {
                    return;
                }
            } else if (packet instanceof Message) {
                Message msg = (Message)packet;
                if (msg.getType() == Message.Type.error) {
                    this.removeUser(packet.getFrom());
                    return;
                }
            } else if (packet instanceof Presence && (pres = (Presence)packet).getType() == Presence.Type.error) {
                this.removeUser(packet.getFrom());
                return;
            }
            if (packet.getTo().getNode() == null) {
                if (packet instanceof IQ && ((IQ)packet).isRequest()) {
                    IQ reply = IQ.createResultIQ((IQ)((IQ)packet));
                    reply.setChildElement(((IQ)packet).getChildElement().createCopy());
                    reply.setError(PacketError.Condition.feature_not_implemented);
                    this.router.route(reply);
                }
                Log.debug("Ignoring stanza addressed at conference service: {}", (Object)packet.toXML());
            } else {
                JID recipient = packet.getTo();
                String roomName = recipient != null ? recipient.getNode() : null;
                this.getChatUser(packet.getFrom(), roomName).process(packet);
            }
        }
        catch (Exception e) {
            Log.error(LocaleUtils.getLocalizedString("admin.error"), (Throwable)e);
        }
    }

    private boolean process(IQ iq) {
        Element childElement = iq.getChildElement();
        String namespace = null;
        if (IQ.Type.error == iq.getType()) {
            return false;
        }
        if (iq.getTo().getResource() != null) {
            return false;
        }
        if (childElement != null) {
            namespace = childElement.getNamespaceURI();
        }
        if ("jabber:iq:register".equals(namespace)) {
            IQ reply = this.registerHandler.handleIQ(iq);
            this.router.route(reply);
        } else if ("jabber:iq:search".equals(namespace)) {
            IQ reply = this.searchHandler.handleIQ(iq);
            this.router.route(reply);
        } else if ("http://jabber.org/protocol/disco#info".equals(namespace)) {
            IQ reply = XMPPServer.getInstance().getIQDiscoInfoHandler().handleIQ(iq);
            this.router.route(reply);
        } else if ("http://jabber.org/protocol/disco#items".equals(namespace)) {
            IQ reply = XMPPServer.getInstance().getIQDiscoItemsHandler().handleIQ(iq);
            this.router.route(reply);
        } else if ("urn:xmpp:ping".equals(namespace)) {
            this.router.route(IQ.createResultIQ((IQ)iq));
        } else {
            if (this.iqHandlers != null) {
                IQHandler h = this.iqHandlers.get(namespace);
                if (h != null) {
                    try {
                        IQ reply = h.handleIQ(iq);
                        if (reply != null) {
                            this.router.route(reply);
                        }
                    }
                    catch (UnauthorizedException e) {
                        IQ reply = IQ.createResultIQ((IQ)iq);
                        reply.setType(IQ.Type.error);
                        reply.setError(PacketError.Condition.service_unavailable);
                        this.router.route(reply);
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    public void initialize(JID jid, ComponentManager componentManager) {
        this.initialize(XMPPServer.getInstance());
    }

    public void shutdown() {
        this.enableService(false, false);
    }

    @Override
    public String getServiceDomain() {
        return this.chatServiceName + "." + XMPPServer.getInstance().getServerInfo().getXMPPDomain();
    }

    public JID getAddress() {
        return new JID(null, this.getServiceDomain(), null, true);
    }

    @Override
    public void serverStarted() {
    }

    @Override
    public void serverStopping() {
        this.shutdown();
    }

    private void broadcastShutdown() {
        Log.debug("Notifying all local users about the imminent destruction of chat service '{}'", (Object)this.chatServiceName);
        if (this.users.isEmpty()) {
            return;
        }
        ExecutorService service = Executors.newFixedThreadPool(Math.min(this.users.size(), 10));
        for (final LocalMUCUser user : this.users.values()) {
            service.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        for (LocalMUCRole role : user.getRoles()) {
                            MUCRoom room = role.getChatRoom();
                            Presence presence = room.createPresence(Presence.Type.unavailable);
                            presence.setFrom(role.getRoleAddress());
                            Element fragment = presence.addChildElement("x", "http://jabber.org/protocol/muc#user");
                            Element item = fragment.addElement("item");
                            item.addAttribute("affiliation", "none");
                            item.addAttribute("role", "none");
                            fragment.addElement("status").addAttribute("code", "332");
                            role.send((Packet)presence);
                        }
                    }
                    catch (Exception e) {
                        Log.debug("Unable to inform {} about the imminent destruction of chat service '{}'", new Object[]{user.getAddress(), MultiUserChatServiceImpl.this.chatServiceName, e});
                    }
                }
            });
        }
        service.shutdown();
        try {
            service.awaitTermination(JiveGlobals.getIntProperty("xmpp.muc.await-termination-millis", 500), TimeUnit.MILLISECONDS);
            Log.debug("Successfully notified all {} local users about the imminent destruction of chat service '{}'", (Object)this.users.size(), (Object)this.chatServiceName);
        }
        catch (InterruptedException e) {
            Log.debug("Interrupted while waiting for all users to be notified of shutdown of chat service '{}'. Shutting down immediately.", (Object)this.chatServiceName);
        }
        service.shutdownNow();
    }

    private void checkForTimedOutUsers() {
        long deadline = System.currentTimeMillis() - (long)this.user_idle;
        for (LocalMUCUser user : this.users.values()) {
            try {
                if (!user.isJoined()) {
                    this.removeUser(user.getAddress());
                    continue;
                }
                if (this.user_idle == -1 || user.getLastPacketTime() >= deadline) continue;
                for (LocalMUCRole role : user.getRoles()) {
                    MUCRoom room = role.getChatRoom();
                    try {
                        Presence kickedPresence = room.kickOccupant(user.getAddress(), null, null, null);
                        room.send((Packet)kickedPresence);
                    }
                    catch (NotAllowedException notAllowedException) {}
                }
            }
            catch (Throwable e) {
                Log.error(LocaleUtils.getLocalizedString("admin.error"), e);
            }
        }
    }

    private void logConversation() {
        for (int index = 0; index <= this.log_batch_size && !this.logQueue.isEmpty(); ++index) {
            boolean success;
            ConversationLogEntry entry = this.logQueue.poll();
            if (entry == null || (success = MUCPersistenceManager.saveConversationLogEntry(entry))) continue;
            this.logQueue.add(entry);
        }
    }

    private void logAllConversation() {
        while (!this.logQueue.isEmpty()) {
            ConversationLogEntry entry = this.logQueue.poll();
            if (entry == null) continue;
            MUCPersistenceManager.saveConversationLogEntry(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MUCRoom getChatRoom(String roomName, JID userjid) throws NotAllowedException {
        LocalMUCRoom room;
        boolean loaded = false;
        boolean created = false;
        String string = roomName.intern();
        synchronized (string) {
            room = this.localMUCRoomManager.getRoom(roomName);
            if (room == null) {
                room = new LocalMUCRoom(this, roomName, this.router);
                try {
                    MUCPersistenceManager.loadFromDB(room);
                    loaded = true;
                }
                catch (IllegalArgumentException e) {
                    if (this.mucEventDelegate != null && this.mucEventDelegate.shouldRecreate(roomName, userjid)) {
                        if (this.mucEventDelegate.loadConfig(room)) {
                            loaded = true;
                            if (room.isPersistent()) {
                                MUCPersistenceManager.saveToDB(room);
                            }
                        }
                        throw new NotAllowedException();
                    }
                    JID bareJID = userjid.asBareJID();
                    if (this.isRoomCreationRestricted() && !this.sysadmins.includes(bareJID) && !this.allowedToCreate.includes(bareJID)) {
                        throw new NotAllowedException();
                    }
                    room.addFirstOwner(userjid);
                    created = true;
                }
                this.localMUCRoomManager.addRoom(roomName, room);
            }
        }
        if (created) {
            MUCEventDispatcher.roomCreated(room.getRole().getRoleAddress());
        }
        if (loaded || created) {
            CacheFactory.doClusterTask(new RoomAvailableEvent(room));
            for (MUCRole role : room.getOccupants()) {
                if (!(role instanceof LocalMUCRole)) continue;
                CacheFactory.doClusterTask(new OccupantAddedEvent(room, role));
            }
        }
        return room;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MUCRoom getChatRoom(String roomName) {
        boolean loaded = false;
        LocalMUCRoom room = this.localMUCRoomManager.getRoom(roomName);
        if (room == null) {
            String string = roomName.intern();
            synchronized (string) {
                room = this.localMUCRoomManager.getRoom(roomName);
                if (room == null) {
                    room = new LocalMUCRoom(this, roomName, this.router);
                    try {
                        MUCPersistenceManager.loadFromDB(room);
                        loaded = true;
                        this.localMUCRoomManager.addRoom(roomName, room);
                    }
                    catch (IllegalArgumentException e) {
                        room = null;
                    }
                }
            }
        }
        if (loaded) {
            CacheFactory.doClusterTask(new RoomAvailableEvent(room));
        }
        return room;
    }

    @Override
    public void refreshChatRoom(String roomName) {
        this.localMUCRoomManager.removeRoom(roomName);
        this.getChatRoom(roomName);
    }

    public LocalMUCRoom getLocalChatRoom(String roomName) {
        return this.localMUCRoomManager.getRoom(roomName);
    }

    @Override
    public List<MUCRoom> getChatRooms() {
        return new ArrayList<MUCRoom>(this.localMUCRoomManager.getRooms());
    }

    @Override
    public boolean hasChatRoom(String roomName) {
        return this.getChatRoom(roomName) != null;
    }

    @Override
    public void removeChatRoom(String roomName) {
        this.removeChatRoom(roomName, true);
    }

    @Override
    public void chatRoomRemoved(LocalMUCRoom room) {
        this.removeChatRoom(room.getName(), false);
    }

    @Override
    public void chatRoomAdded(LocalMUCRoom room) {
        this.localMUCRoomManager.addRoom(room.getName(), room);
    }

    private void removeChatRoom(String roomName, boolean notify) {
        MUCRoom room = this.localMUCRoomManager.removeRoom(roomName);
        if (room != null) {
            Log.info("removing chat room:" + roomName + "|" + room.getClass().getName());
            if (room instanceof LocalMUCRoom) {
                GroupEventDispatcher.removeListener((LocalMUCRoom)room);
            }
            this.totalChatTime += room.getChatLength();
            if (notify) {
                CacheFactory.doClusterTask(new RoomRemovedEvent((LocalMUCRoom)room));
            }
        } else {
            Log.info("No chatroom {} during removal.", (Object)roomName);
        }
    }

    @Override
    public String getServiceName() {
        return this.chatServiceName;
    }

    public String getName() {
        return this.getServiceName();
    }

    @Override
    public HistoryStrategy getHistoryStrategy() {
        return this.historyStrategy;
    }

    private void removeUser(JID jabberID) {
        LocalMUCUser user = this.users.remove(jabberID);
        if (user != null) {
            for (LocalMUCRole role : user.getRoles()) {
                try {
                    role.getChatRoom().leaveRoom(role);
                }
                catch (Exception e) {
                    Log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MUCUser getChatUser(JID userjid, String roomName) {
        LocalMUCUser user;
        if (this.router == null) {
            throw new IllegalStateException("Not initialized");
        }
        String string = userjid.toString().intern();
        synchronized (string) {
            user = this.users.get(userjid);
            if (user == null) {
                MUCRole occupant;
                LocalMUCRoom localMUCRoom;
                if (roomName != null && (localMUCRoom = this.localMUCRoomManager.getRoom(roomName)) != null && (occupant = localMUCRoom.getOccupantByFullJID(userjid)) != null && !occupant.isLocal()) {
                    return new RemoteMUCUser(userjid, localMUCRoom);
                }
                user = new LocalMUCUser(this, this.router, userjid);
                this.users.put(userjid, user);
            }
        }
        return user;
    }

    @Override
    public Collection<MUCRole> getMUCRoles(JID user) {
        ArrayList<MUCRole> userRoles = new ArrayList<MUCRole>();
        for (LocalMUCRoom room : this.localMUCRoomManager.getRooms()) {
            MUCRole role = room.getOccupantByFullJID(user);
            if (role == null) continue;
            userRoles.add(role);
        }
        return userRoles;
    }

    private Date getCleanupDate() {
        return new Date(System.currentTimeMillis() - this.emptyLimit * 3600000L);
    }

    @Override
    public void setKickIdleUsersTimeout(int timeout) {
        if (this.user_timeout == timeout) {
            return;
        }
        if (this.userTimeoutTask != null) {
            this.userTimeoutTask.cancel();
        }
        this.user_timeout = timeout;
        this.userTimeoutTask = new UserTimeoutTask();
        TaskEngine.getInstance().schedule((TimerTask)this.userTimeoutTask, this.user_timeout, (long)this.user_timeout);
        MUCPersistenceManager.setProperty(this.chatServiceName, "tasks.user.timeout", Integer.toString(timeout));
    }

    @Override
    public int getKickIdleUsersTimeout() {
        return this.user_timeout;
    }

    @Override
    public void setUserIdleTime(int idleTime) {
        if (this.user_idle == idleTime) {
            return;
        }
        this.user_idle = idleTime;
        MUCPersistenceManager.setProperty(this.chatServiceName, "tasks.user.idle", Integer.toString(idleTime));
    }

    @Override
    public int getUserIdleTime() {
        return this.user_idle;
    }

    @Override
    public void setLogConversationsTimeout(int timeout) {
        if (this.log_timeout == timeout) {
            return;
        }
        if (this.logConversationTask != null) {
            this.logConversationTask.cancel();
        }
        this.log_timeout = timeout;
        this.logConversationTask = new LogConversationTask();
        TaskEngine.getInstance().schedule((TimerTask)this.logConversationTask, this.log_timeout, (long)this.log_timeout);
        MUCPersistenceManager.setProperty(this.chatServiceName, "tasks.log.timeout", Integer.toString(timeout));
    }

    @Override
    public int getLogConversationsTimeout() {
        return this.log_timeout;
    }

    @Override
    public void setLogConversationBatchSize(int size) {
        if (this.log_batch_size == size) {
            return;
        }
        this.log_batch_size = size;
        MUCPersistenceManager.setProperty(this.chatServiceName, "tasks.log.batchsize", Integer.toString(size));
    }

    @Override
    public int getLogConversationBatchSize() {
        return this.log_batch_size;
    }

    @Override
    public Collection<JID> getUsersAllowedToCreate() {
        return Collections.unmodifiableCollection(this.allowedToCreate);
    }

    @Override
    public Collection<JID> getSysadmins() {
        return Collections.unmodifiableCollection(this.sysadmins);
    }

    @Override
    public boolean isSysadmin(JID bareJID) {
        return this.sysadmins.includes(bareJID);
    }

    @Override
    public void addSysadmins(Collection<JID> userJIDs) {
        for (JID userJID : userJIDs) {
            this.addSysadmin(userJID);
        }
    }

    @Override
    public void addSysadmin(JID userJID) {
        JID bareJID = userJID.asBareJID();
        if (!this.sysadmins.contains(userJID)) {
            this.sysadmins.add(bareJID);
        }
        ArrayList<JID> tempList = new ArrayList<JID>(this.sysadmins);
        Collections.sort(tempList);
        this.sysadmins = new ConcurrentGroupList<JID>((Collection<JID>)tempList);
        String[] jids = new String[this.sysadmins.size()];
        for (int i = 0; i < jids.length; ++i) {
            jids[i] = ((JID)this.sysadmins.get(i)).toBareJID();
        }
        MUCPersistenceManager.setProperty(this.chatServiceName, "sysadmin.jid", MultiUserChatServiceImpl.fromArray(jids));
    }

    @Override
    public void removeSysadmin(JID userJID) {
        JID bareJID = userJID.asBareJID();
        this.sysadmins.remove(bareJID);
        String[] jids = new String[this.sysadmins.size()];
        for (int i = 0; i < jids.length; ++i) {
            jids[i] = ((JID)this.sysadmins.get(i)).toBareJID();
        }
        MUCPersistenceManager.setProperty(this.chatServiceName, "sysadmin.jid", MultiUserChatServiceImpl.fromArray(jids));
    }

    public boolean isAllowToDiscoverMembersOnlyRooms() {
        return this.allowToDiscoverMembersOnlyRooms;
    }

    public void setAllowToDiscoverMembersOnlyRooms(boolean allowToDiscoverMembersOnlyRooms) {
        this.allowToDiscoverMembersOnlyRooms = allowToDiscoverMembersOnlyRooms;
        MUCPersistenceManager.setProperty(this.chatServiceName, "discover.membersOnly", Boolean.toString(allowToDiscoverMembersOnlyRooms));
    }

    public boolean isAllowToDiscoverLockedRooms() {
        return this.allowToDiscoverLockedRooms;
    }

    public void setAllowToDiscoverLockedRooms(boolean allowToDiscoverLockedRooms) {
        this.allowToDiscoverLockedRooms = allowToDiscoverLockedRooms;
        MUCPersistenceManager.setProperty(this.chatServiceName, "discover.locked", Boolean.toString(allowToDiscoverLockedRooms));
    }

    @Override
    public boolean isRoomCreationRestricted() {
        return this.roomCreationRestricted;
    }

    @Override
    public void setRoomCreationRestricted(boolean roomCreationRestricted) {
        this.roomCreationRestricted = roomCreationRestricted;
        MUCPersistenceManager.setProperty(this.chatServiceName, "create.anyone", Boolean.toString(roomCreationRestricted));
    }

    @Override
    public void addUsersAllowedToCreate(Collection<JID> userJIDs) {
        boolean listChanged = false;
        for (JID userJID : userJIDs) {
            if (this.allowedToCreate.contains(userJID)) continue;
            this.allowedToCreate.add(userJID);
            listChanged = true;
        }
        if (listChanged) {
            ArrayList<JID> tempList = new ArrayList<JID>(this.allowedToCreate);
            Collections.sort(tempList);
            this.allowedToCreate = new ConcurrentGroupList<JID>((Collection<JID>)tempList);
            MUCPersistenceManager.setProperty(this.chatServiceName, "create.jid", MultiUserChatServiceImpl.fromCollection(this.allowedToCreate));
        }
    }

    @Override
    public void addUserAllowedToCreate(JID userJID) {
        ArrayList<JID> asList = new ArrayList<JID>();
        asList.add(userJID);
        this.addUsersAllowedToCreate(asList);
    }

    @Override
    public void removeUsersAllowedToCreate(Collection<JID> userJIDs) {
        boolean listChanged = false;
        for (JID userJID : userJIDs) {
            listChanged |= this.allowedToCreate.remove(userJID);
        }
        if (listChanged) {
            MUCPersistenceManager.setProperty(this.chatServiceName, "create.jid", MultiUserChatServiceImpl.fromCollection(this.allowedToCreate));
        }
    }

    @Override
    public void removeUserAllowedToCreate(JID userJID) {
        this.removeUsersAllowedToCreate(Collections.singleton(userJID));
    }

    public void initialize(XMPPServer server) {
        this.initializeSettings();
        this.routingTable = server.getRoutingTable();
        this.router = server.getPacketRouter();
        this.registerHandler = new IQMUCRegisterHandler(this);
        this.searchHandler = new IQMUCSearchHandler(this);
    }

    public void initializeSettings() {
        String[] jids;
        this.serviceEnabled = JiveProperties.getInstance().getBooleanProperty("xmpp.muc.enabled", true);
        this.serviceEnabled = MUCPersistenceManager.getBooleanProperty(this.chatServiceName, "enabled", this.serviceEnabled);
        this.historyStrategy.setContext(this.chatServiceName, "history");
        String property = MUCPersistenceManager.getProperty(this.chatServiceName, "sysadmin.jid");
        this.sysadmins.clear();
        if (property != null && property.trim().length() > 0) {
            for (String jid : jids = property.split(",")) {
                if (jid == null || jid.trim().length() == 0) continue;
                try {
                    this.sysadmins.add(GroupJID.fromString(jid.trim().toLowerCase()).asBareJID());
                }
                catch (IllegalArgumentException e) {
                    Log.warn("The 'sysadmin.jid' property contains a value that is not a valid JID. It is ignored. Offending value: '" + jid + "'.", (Throwable)e);
                }
            }
        }
        this.allowToDiscoverLockedRooms = MUCPersistenceManager.getBooleanProperty(this.chatServiceName, "discover.locked", true);
        this.allowToDiscoverMembersOnlyRooms = MUCPersistenceManager.getBooleanProperty(this.chatServiceName, "discover.membersOnly", true);
        this.roomCreationRestricted = MUCPersistenceManager.getBooleanProperty(this.chatServiceName, "create.anyone", false);
        property = MUCPersistenceManager.getProperty(this.chatServiceName, "create.jid");
        this.allowedToCreate.clear();
        if (property != null && property.trim().length() > 0) {
            for (String jid : jids = property.split(",")) {
                if (jid == null || jid.trim().length() == 0) continue;
                try {
                    this.allowedToCreate.add(GroupJID.fromString(jid.trim().toLowerCase()).asBareJID());
                }
                catch (IllegalArgumentException e) {
                    Log.warn("The 'create.jid' property contains a value that is not a valid JID. It is ignored. Offending value: '" + jid + "'.", (Throwable)e);
                }
            }
        }
        String value = MUCPersistenceManager.getProperty(this.chatServiceName, "tasks.user.timeout");
        this.user_timeout = 300000;
        if (value != null) {
            try {
                this.user_timeout = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                Log.error("Wrong number format of property tasks.user.timeout for service " + this.chatServiceName, (Throwable)e);
            }
        }
        value = MUCPersistenceManager.getProperty(this.chatServiceName, "tasks.user.idle");
        this.user_idle = -1;
        if (value != null) {
            try {
                this.user_idle = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                Log.error("Wrong number format of property tasks.user.idle for service " + this.chatServiceName, (Throwable)e);
            }
        }
        value = MUCPersistenceManager.getProperty(this.chatServiceName, "tasks.log.timeout");
        this.log_timeout = 300000;
        if (value != null) {
            try {
                this.log_timeout = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                Log.error("Wrong number format of property tasks.log.timeout for service " + this.chatServiceName, (Throwable)e);
            }
        }
        value = MUCPersistenceManager.getProperty(this.chatServiceName, "tasks.log.batchsize");
        this.log_batch_size = 50;
        if (value != null) {
            try {
                this.log_batch_size = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                Log.error("Wrong number format of property tasks.log.batchsize for service " + this.chatServiceName, (Throwable)e);
            }
        }
        value = MUCPersistenceManager.getProperty(this.chatServiceName, "unload.empty_days");
        this.emptyLimit = 720L;
        if (value != null) {
            try {
                this.emptyLimit = Integer.parseInt(value) * 24;
            }
            catch (NumberFormatException e) {
                Log.error("Wrong number format of property unload.empty_days for service " + this.chatServiceName, (Throwable)e);
            }
        }
    }

    public void start() {
        XMPPServer.getInstance().addServerListener(this);
        this.userTimeoutTask = new UserTimeoutTask();
        TaskEngine.getInstance().schedule((TimerTask)this.userTimeoutTask, this.user_timeout, (long)this.user_timeout);
        this.logConversationTask = new LogConversationTask();
        TaskEngine.getInstance().schedule((TimerTask)this.logConversationTask, this.log_timeout, (long)this.log_timeout);
        this.cleanupTask = new CleanupTask();
        TaskEngine.getInstance().schedule((TimerTask)this.cleanupTask, 3600000L, 3600000L);
        XMPPServer.getInstance().getIQDiscoItemsHandler().addServerItemsProvider(this);
        XMPPServer.getInstance().getIQDiscoInfoHandler().setServerNodeInfoProvider(this.getServiceDomain(), this);
        XMPPServer.getInstance().getServerItemsProviders().add(this);
        ArrayList<String> params = new ArrayList<String>();
        params.clear();
        params.add(this.getServiceDomain());
        Log.info(LocaleUtils.getLocalizedString("startup.starting.muc", params));
        for (LocalMUCRoom room : MUCPersistenceManager.loadRoomsFromDB(this, this.getCleanupDate(), this.router)) {
            this.localMUCRoomManager.addRoom(room.getName().toLowerCase(), room);
        }
    }

    private void stop() {
        XMPPServer.getInstance().getIQDiscoItemsHandler().removeServerItemsProvider(this);
        XMPPServer.getInstance().getIQDiscoInfoHandler().removeServerNodeInfoProvider(this.getServiceDomain());
        XMPPServer.getInstance().getServerItemsProviders().remove(this);
        this.routingTable.removeComponentRoute(this.getAddress());
        this.broadcastShutdown();
        this.logAllConversation();
        XMPPServer.getInstance().removeServerListener(this);
    }

    @Override
    public void enableService(boolean enabled, boolean persistent) {
        if (this.isServiceEnabled() == enabled) {
            return;
        }
        if (!enabled) {
            this.stop();
        }
        if (persistent) {
            MUCPersistenceManager.setProperty(this.chatServiceName, "enabled", Boolean.toString(enabled));
        }
        this.serviceEnabled = enabled;
        if (enabled) {
            this.start();
        }
    }

    @Override
    public boolean isServiceEnabled() {
        return this.serviceEnabled;
    }

    @Override
    public long getTotalChatTime() {
        return this.totalChatTime;
    }

    @Override
    public int getNumberChatRooms() {
        return this.localMUCRoomManager.getNumberChatRooms();
    }

    @Override
    public int getNumberConnectedUsers(boolean onlyLocal) {
        int total = 0;
        for (LocalMUCUser user : this.users.values()) {
            if (!user.isJoined()) continue;
            ++total;
        }
        if (!onlyLocal) {
            Collection<Object> results = CacheFactory.doSynchronousClusterTask(new GetNumberConnectedUsers(), false);
            for (Object result : results) {
                if (result == null) continue;
                total += ((Integer)result).intValue();
            }
        }
        return total;
    }

    @Override
    public int getNumberRoomOccupants() {
        int total = 0;
        for (MUCRoom mUCRoom : this.localMUCRoomManager.getRooms()) {
            total += mUCRoom.getOccupantsCount();
        }
        return total;
    }

    @Override
    public long getIncomingMessageCount(boolean resetAfter) {
        if (resetAfter) {
            return this.inMessages.getAndSet(0);
        }
        return this.inMessages.get();
    }

    @Override
    public long getOutgoingMessageCount(boolean resetAfter) {
        if (resetAfter) {
            return this.outMessages.getAndSet(0L);
        }
        return this.outMessages.get();
    }

    @Override
    public void logConversation(MUCRoom room, Message message, JID sender) {
        if (message.getSubject() != null || message.getBody() != null) {
            this.logQueue.add(new ConversationLogEntry(new Date(), room, message, sender));
        }
    }

    @Override
    public void messageBroadcastedTo(int numOccupants) {
        this.inMessages.incrementAndGet();
        this.outMessages.addAndGet(numOccupants);
    }

    @Override
    public Iterator<DiscoServerItem> getItems() {
        if (!this.isServiceEnabled()) {
            return null;
        }
        ArrayList<DiscoServerItem> items = new ArrayList<DiscoServerItem>();
        DiscoServerItem item = new DiscoServerItem(new JID(this.getServiceDomain()), this.getDescription(), null, null, this, this);
        items.add(item);
        return items.iterator();
    }

    @Override
    public Iterator<Element> getIdentities(String name, String node, JID senderJID) {
        String reservedNick;
        MUCRoom room;
        ArrayList<Element> identities = new ArrayList<Element>();
        if (name == null && node == null) {
            Element identity = DocumentHelper.createElement((String)"identity");
            identity.addAttribute("category", "conference");
            identity.addAttribute("name", this.getDescription());
            identity.addAttribute("type", "text");
            identities.add(identity);
            Element searchId = DocumentHelper.createElement((String)"identity");
            searchId.addAttribute("category", "directory");
            searchId.addAttribute("name", "Public Chatroom Search");
            searchId.addAttribute("type", "chatroom");
            identities.add(searchId);
            if (!this.extraDiscoIdentities.isEmpty()) {
                identities.addAll(this.extraDiscoIdentities);
            }
        } else if (name != null && node == null) {
            MUCRoom room2 = this.getChatRoom(name);
            if (room2 != null) {
                Element identity = DocumentHelper.createElement((String)"identity");
                identity.addAttribute("category", "conference");
                identity.addAttribute("name", room2.getNaturalLanguageName());
                identity.addAttribute("type", "text");
                identities.add(identity);
            }
        } else if (name != null && "x-roomuser-item".equals(node) && (room = this.getChatRoom(name)) != null && (reservedNick = room.getReservedNickname(senderJID)) != null) {
            Element identity = DocumentHelper.createElement((String)"identity");
            identity.addAttribute("category", "conference");
            identity.addAttribute("name", reservedNick);
            identity.addAttribute("type", "text");
            identities.add(identity);
        }
        return identities.iterator();
    }

    @Override
    public Iterator<String> getFeatures(String name, String node, JID senderJID) {
        MUCRoom room;
        ArrayList<String> features = new ArrayList<String>();
        if (name == null && node == null) {
            features.add("http://jabber.org/protocol/muc");
            features.add("http://jabber.org/protocol/disco#info");
            features.add("http://jabber.org/protocol/disco#items");
            features.add("jabber:iq:search");
            features.add("http://jabber.org/protocol/rsm");
            if (!this.extraDiscoFeatures.isEmpty()) {
                features.addAll(this.extraDiscoFeatures);
            }
        } else if (name != null && node == null && (room = this.getChatRoom(name)) != null) {
            features.add("http://jabber.org/protocol/muc");
            if (room.isPublicRoom()) {
                features.add("muc_public");
            } else {
                features.add("muc_hidden");
            }
            if (room.isMembersOnly()) {
                features.add("muc_membersonly");
            } else {
                features.add("muc_open");
            }
            if (room.isModerated()) {
                features.add("muc_moderated");
            } else {
                features.add("muc_unmoderated");
            }
            if (room.canAnyoneDiscoverJID()) {
                features.add("muc_nonanonymous");
            } else {
                features.add("muc_semianonymous");
            }
            if (room.isPasswordProtected()) {
                features.add("muc_passwordprotected");
            } else {
                features.add("muc_unsecured");
            }
            if (room.isPersistent()) {
                features.add("muc_persistent");
            } else {
                features.add("muc_temporary");
            }
            if (!this.extraDiscoFeatures.isEmpty()) {
                features.addAll(this.extraDiscoFeatures);
            }
        }
        return features.iterator();
    }

    @Override
    public DataForm getExtendedInfo(String name, String node, JID senderJID) {
        MUCRoom room;
        if (name != null && node == null && (room = this.getChatRoom(name)) != null) {
            DataForm dataForm = new DataForm(DataForm.Type.result);
            FormField fieldType = dataForm.addField();
            fieldType.setVariable("FORM_TYPE");
            fieldType.setType(FormField.Type.hidden);
            fieldType.addValue((Object)"http://jabber.org/protocol/muc#roominfo");
            FormField fieldDescr = dataForm.addField();
            fieldDescr.setVariable("muc#roominfo_description");
            fieldDescr.setLabel(LocaleUtils.getLocalizedString("muc.extended.info.desc"));
            fieldDescr.addValue((Object)room.getDescription());
            FormField fieldSubj = dataForm.addField();
            fieldSubj.setVariable("muc#roominfo_subject");
            fieldSubj.setLabel(LocaleUtils.getLocalizedString("muc.extended.info.subject"));
            fieldSubj.addValue((Object)room.getSubject());
            FormField fieldOcc = dataForm.addField();
            fieldOcc.setVariable("muc#roominfo_occupants");
            fieldOcc.setLabel(LocaleUtils.getLocalizedString("muc.extended.info.occupants"));
            fieldOcc.addValue((Object)Integer.toString(room.getOccupantsCount()));
            FormField fieldDate = dataForm.addField();
            fieldDate.setVariable("x-muc#roominfo_creationdate");
            fieldDate.setLabel(LocaleUtils.getLocalizedString("muc.extended.info.creationdate"));
            fieldDate.addValue((Object)XMPPDateTimeFormat.format(room.getCreationDate()));
            return dataForm;
        }
        return null;
    }

    @Override
    public void addExtraFeature(String feature) {
        this.extraDiscoFeatures.add(feature);
    }

    @Override
    public void removeExtraFeature(String feature) {
        this.extraDiscoFeatures.remove(feature);
    }

    @Override
    public void addExtraIdentity(String category, String name, String type) {
        Element identity = DocumentHelper.createElement((String)"identity");
        identity.addAttribute("category", category);
        identity.addAttribute("name", name);
        identity.addAttribute("type", type);
        this.extraDiscoIdentities.add(identity);
    }

    @Override
    public void removeExtraIdentity(String name) {
        Iterator<Element> iter = this.extraDiscoIdentities.iterator();
        while (iter.hasNext()) {
            Element elem = iter.next();
            if (!name.equals(elem.attribute("name").getStringValue())) continue;
            iter.remove();
            break;
        }
    }

    public void setMUCDelegate(MUCEventDelegate delegate) {
        this.mucEventDelegate = delegate;
    }

    public MUCEventDelegate getMUCDelegate() {
        return this.mucEventDelegate;
    }

    @Override
    public boolean hasInfo(String name, String node, JID senderJID) {
        if (!this.isServiceEnabled()) {
            return false;
        }
        if (name == null && node == null) {
            return true;
        }
        if (name != null && node == null) {
            return this.hasChatRoom(name);
        }
        if (name != null && "x-roomuser-item".equals(node)) {
            return this.hasChatRoom(name);
        }
        return false;
    }

    @Override
    public Iterator<DiscoItem> getItems(String name, String node, JID senderJID) {
        HashSet<DiscoItem> answer;
        block4: {
            MUCRoom room;
            block3: {
                if (!this.isServiceEnabled()) {
                    return null;
                }
                answer = new HashSet<DiscoItem>();
                if (name != null || node != null) break block3;
                for (MUCRoom mUCRoom : this.localMUCRoomManager.getRooms()) {
                    if (!this.canDiscoverRoom(mUCRoom, senderJID)) continue;
                    answer.add(new DiscoItem(mUCRoom.getRole().getRoleAddress(), mUCRoom.getNaturalLanguageName(), null, null));
                }
                break block4;
            }
            if (name == null || node != null || (room = this.getChatRoom(name)) == null || !this.canDiscoverRoom(room, senderJID)) break block4;
            for (MUCRole role : room.getOccupants()) {
                answer.add(new DiscoItem(role.getRoleAddress(), null, null, null));
            }
        }
        return answer.iterator();
    }

    private boolean canDiscoverRoom(MUCRoom room, JID senderJID) {
        if (!this.allowToDiscoverLockedRooms && room.isLocked()) {
            return false;
        }
        if (!room.isPublicRoom()) {
            if (!this.allowToDiscoverMembersOnlyRooms && room.isMembersOnly()) {
                return false;
            }
            MUCRole.Affiliation affiliation = room.getAffiliation(senderJID.asBareJID());
            if (affiliation != MUCRole.Affiliation.owner && affiliation != MUCRole.Affiliation.admin && affiliation != MUCRole.Affiliation.member) {
                return false;
            }
        }
        return true;
    }

    private static String fromArray(String[] array) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            buf.append(array[i]);
            if (i == array.length - 1) continue;
            buf.append(',');
        }
        return buf.toString();
    }

    private static String fromCollection(Collection<JID> coll) {
        StringBuilder buf = new StringBuilder();
        for (JID elem : coll) {
            buf.append(elem.toBareJID()).append(',');
        }
        int endPos = buf.length() > 1 ? buf.length() - 1 : 0;
        return buf.substring(0, endPos);
    }

    @Override
    public boolean isHidden() {
        return this.isHidden;
    }

    private class CleanupTask
    extends TimerTask {
        private CleanupTask() {
        }

        @Override
        public void run() {
            if (ClusterManager.isClusteringStarted() && !ClusterManager.isSeniorClusterMember()) {
                return;
            }
            try {
                MultiUserChatServiceImpl.this.localMUCRoomManager.cleanupRooms(MultiUserChatServiceImpl.this.getCleanupDate());
            }
            catch (Throwable e) {
                Log.error(LocaleUtils.getLocalizedString("admin.error"), e);
            }
        }
    }

    private class LogConversationTask
    extends TimerTask {
        private LogConversationTask() {
        }

        @Override
        public void run() {
            try {
                MultiUserChatServiceImpl.this.logConversation();
            }
            catch (Throwable e) {
                Log.error(LocaleUtils.getLocalizedString("admin.error"), e);
            }
        }
    }

    private class UserTimeoutTask
    extends TimerTask {
        private UserTimeoutTask() {
        }

        @Override
        public void run() {
            MultiUserChatServiceImpl.this.checkForTimedOutUsers();
        }
    }
}

