/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.muc.spi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;
import org.jivesoftware.openfire.PacketRouter;
import org.jivesoftware.openfire.group.Group;
import org.jivesoftware.openfire.group.GroupJID;
import org.jivesoftware.openfire.group.GroupManager;
import org.jivesoftware.openfire.group.GroupNotFoundException;
import org.jivesoftware.openfire.muc.CannotBeInvitedException;
import org.jivesoftware.openfire.muc.ConflictException;
import org.jivesoftware.openfire.muc.ForbiddenException;
import org.jivesoftware.openfire.muc.MUCRole;
import org.jivesoftware.openfire.muc.NotAllowedException;
import org.jivesoftware.openfire.muc.spi.LocalMUCRoom;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.IQ;
import org.xmpp.packet.JID;
import org.xmpp.packet.Packet;
import org.xmpp.packet.PacketError;
import org.xmpp.packet.Presence;

public class IQAdminHandler {
    private static final Logger logger = LoggerFactory.getLogger(IQAdminHandler.class);
    private final LocalMUCRoom room;
    private final PacketRouter router;
    private final boolean skipInvite;

    public IQAdminHandler(LocalMUCRoom chatroom, PacketRouter packetRouter) {
        this.room = chatroom;
        this.router = packetRouter;
        this.skipInvite = JiveGlobals.getBooleanProperty("xmpp.muc.skipInvite", false);
    }

    public void handleIQ(IQ packet, MUCRole role) throws ForbiddenException, ConflictException, NotAllowedException, CannotBeInvitedException {
        IQ reply = IQ.createResultIQ((IQ)packet);
        Element element = packet.getChildElement();
        List itemsList = element.elements("item");
        if (!itemsList.isEmpty()) {
            this.handleItemsElement(role, itemsList, reply);
        } else {
            reply.setChildElement(packet.getChildElement().createCopy());
            reply.setError(PacketError.Condition.bad_request);
        }
        if (reply.getTo() != null) {
            this.router.route(reply);
        }
    }

    private void handleItemsElement(MUCRole senderRole, List<Element> itemsList, IQ reply) throws ForbiddenException, ConflictException, NotAllowedException, CannotBeInvitedException {
        boolean hasNick;
        boolean hasJID = itemsList.get(0).attributeValue("jid") != null;
        boolean bl = hasNick = itemsList.get(0).attributeValue("nick") != null;
        if (!hasJID && !hasNick) {
            Element result = reply.setChildElement("query", "http://jabber.org/protocol/muc#admin");
            Iterator<Element> iterator = itemsList.iterator();
            while (iterator.hasNext()) {
                Element metaData;
                Group group;
                Element anItem;
                Element item = anItem = iterator.next();
                String affiliation = item.attributeValue("affiliation");
                String roleAttribute = item.attributeValue("role");
                if ("outcast".equals(affiliation)) {
                    if (MUCRole.Affiliation.admin != senderRole.getAffiliation() && MUCRole.Affiliation.owner != senderRole.getAffiliation()) {
                        throw new ForbiddenException();
                    }
                    for (JID jid : this.room.getOutcasts()) {
                        if (GroupJID.isGroup(jid)) {
                            try {
                                group = GroupManager.getInstance().getGroup(jid);
                                for (JID groupMember : group.getAll()) {
                                    metaData = this.addAffiliationToResult(affiliation, result, groupMember);
                                }
                                continue;
                            }
                            catch (GroupNotFoundException gnfe) {
                                logger.warn("Invalid group JID in the outcast list: " + jid);
                                continue;
                            }
                        }
                        metaData = this.addAffiliationToResult(affiliation, result, jid);
                    }
                    continue;
                }
                if ("member".equals(affiliation)) {
                    if (!this.room.isMembersOnly() && MUCRole.Affiliation.admin != senderRole.getAffiliation() && MUCRole.Affiliation.owner != senderRole.getAffiliation()) {
                        throw new ForbiddenException();
                    }
                    for (JID jid : this.room.getMembers()) {
                        if (GroupJID.isGroup(jid)) {
                            try {
                                group = GroupManager.getInstance().getGroup(jid);
                                for (JID groupMember : group.getAll()) {
                                    metaData = this.addAffiliationToResult(affiliation, result, groupMember);
                                }
                                continue;
                            }
                            catch (GroupNotFoundException gnfe) {
                                logger.warn("Invalid group JID in the member list: " + jid);
                                continue;
                            }
                        }
                        metaData = this.addAffiliationToResult(affiliation, result, jid);
                    }
                    continue;
                }
                if ("moderator".equals(roleAttribute)) {
                    if (MUCRole.Affiliation.admin != senderRole.getAffiliation() && MUCRole.Affiliation.owner != senderRole.getAffiliation()) {
                        throw new ForbiddenException();
                    }
                    for (MUCRole role : this.room.getModerators()) {
                        metaData = result.addElement("item", "http://jabber.org/protocol/muc#admin");
                        metaData.addAttribute("role", "moderator");
                        metaData.addAttribute("jid", role.getUserAddress().toString());
                        metaData.addAttribute("nick", role.getNickname());
                        metaData.addAttribute("affiliation", role.getAffiliation().toString());
                    }
                    continue;
                }
                if ("participant".equals(roleAttribute)) {
                    if (MUCRole.Role.moderator != senderRole.getRole()) {
                        throw new ForbiddenException();
                    }
                    for (MUCRole role : this.room.getParticipants()) {
                        metaData = result.addElement("item", "http://jabber.org/protocol/muc#admin");
                        metaData.addAttribute("role", "participant");
                        metaData.addAttribute("jid", role.getUserAddress().toString());
                        metaData.addAttribute("nick", role.getNickname());
                        metaData.addAttribute("affiliation", role.getAffiliation().toString());
                    }
                    continue;
                }
                if ("owner".equals(affiliation)) {
                    for (JID jid : this.room.getOwners()) {
                        if (GroupJID.isGroup(jid)) {
                            try {
                                group = GroupManager.getInstance().getGroup(jid);
                                for (JID groupMember : group.getAll()) {
                                    metaData = this.addAffiliationToResult(affiliation, result, groupMember);
                                }
                                continue;
                            }
                            catch (GroupNotFoundException gnfe) {
                                logger.warn("Invalid group JID in the owner list: " + jid);
                                continue;
                            }
                        }
                        metaData = this.addAffiliationToResult(affiliation, result, jid);
                    }
                    continue;
                }
                if ("admin".equals(affiliation)) {
                    for (JID jid : this.room.getAdmins()) {
                        if (GroupJID.isGroup(jid)) {
                            try {
                                group = GroupManager.getInstance().getGroup(jid);
                                for (JID groupMember : group.getAll()) {
                                    metaData = this.addAffiliationToResult(affiliation, result, groupMember);
                                }
                                continue;
                            }
                            catch (GroupNotFoundException gnfe) {
                                logger.warn("Invalid group JID in the admin list: " + jid);
                                continue;
                            }
                        }
                        metaData = this.addAffiliationToResult(affiliation, result, jid);
                    }
                    continue;
                }
                reply.setError(PacketError.Condition.bad_request);
            }
        } else {
            ArrayList<Presence> presences = new ArrayList<Presence>(itemsList.size());
            for (Element anItem : itemsList) {
                try {
                    Element item = anItem;
                    String affiliation = item.attributeValue("affiliation");
                    boolean hasAffiliation = affiliation != null;
                    String target = hasAffiliation ? affiliation : item.attributeValue("role");
                    ArrayList<JID> jids = new ArrayList<JID>();
                    String nick = item.attributeValue("nick");
                    if (hasJID) {
                        jids.add(GroupJID.fromString(item.attributeValue("jid")));
                    } else {
                        for (MUCRole role : this.room.getOccupantsByNickname(nick)) {
                            if (jids.contains(role.getUserAddress())) continue;
                            jids.add(role.getUserAddress());
                        }
                    }
                    for (JID jid : jids) {
                        if ("moderator".equals(target)) {
                            presences.add(this.room.addModerator(jid, senderRole));
                            continue;
                        }
                        if ("owner".equals(target)) {
                            presences.addAll(this.room.addOwner(jid, senderRole));
                            continue;
                        }
                        if ("admin".equals(target)) {
                            presences.addAll(this.room.addAdmin(jid, senderRole));
                            continue;
                        }
                        if ("participant".equals(target)) {
                            presences.add(this.room.addParticipant(jid, item.elementTextTrim("reason"), senderRole));
                            continue;
                        }
                        if ("visitor".equals(target)) {
                            presences.add(this.room.addVisitor(jid, senderRole));
                            continue;
                        }
                        if ("member".equals(target)) {
                            boolean hadAffiliation = this.room.getAffiliation(jid) != MUCRole.Affiliation.none;
                            presences.addAll(this.room.addMember(jid, nick, senderRole));
                            if (this.skipInvite || hadAffiliation || !this.room.isMembersOnly()) continue;
                            ArrayList<JID> invitees = new ArrayList<JID>();
                            if (GroupJID.isGroup(jid)) {
                                try {
                                    Group group = GroupManager.getInstance().getGroup(jid);
                                    for (JID inGroup : group.getAll()) {
                                        invitees.add(inGroup);
                                    }
                                }
                                catch (GroupNotFoundException gnfe) {
                                    logger.error("Failed to send invitations for group members", (Throwable)gnfe);
                                }
                            } else {
                                invitees.add(jid);
                            }
                            for (JID invitee : invitees) {
                                this.room.sendInvitation(invitee, null, senderRole, null);
                            }
                            continue;
                        }
                        if ("outcast".equals(target)) {
                            presences.addAll(this.room.addOutcast(jid, item.elementTextTrim("reason"), senderRole));
                            continue;
                        }
                        if ("none".equals(target)) {
                            if (hasAffiliation) {
                                presences.addAll(this.room.addNone(jid, senderRole));
                                continue;
                            }
                            if (MUCRole.Role.moderator != senderRole.getRole()) {
                                throw new ForbiddenException();
                            }
                            presences.add(this.room.kickOccupant(jid, senderRole.getUserAddress(), senderRole.getNickname(), item.elementTextTrim("reason")));
                            continue;
                        }
                        reply.setError(PacketError.Condition.bad_request);
                    }
                }
                catch (UserNotFoundException userNotFoundException) {
                }
            }
            for (Presence presence : presences) {
                this.room.send((Packet)presence);
            }
        }
    }

    private Element addAffiliationToResult(String affiliation, Element parent, JID jid) {
        Element result = parent.addElement("item", "http://jabber.org/protocol/muc#admin");
        result.addAttribute("affiliation", affiliation);
        result.addAttribute("jid", jid.toString());
        try {
            List<MUCRole> roles = this.room.getOccupantsByBareJID(jid);
            MUCRole role = roles.get(0);
            result.addAttribute("role", role.getRole().toString());
            result.addAttribute("nick", role.getNickname());
        }
        catch (UserNotFoundException userNotFoundException) {
            // empty catch block
        }
        return result;
    }
}

