/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.muc.cluster;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.dom4j.Element;
import org.jivesoftware.openfire.muc.MUCRole;
import org.jivesoftware.openfire.muc.NotAllowedException;
import org.jivesoftware.openfire.muc.cluster.MUCRoomTask;
import org.jivesoftware.openfire.muc.spi.LocalMUCRoom;
import org.jivesoftware.util.cache.ExternalizableUtil;
import org.xmpp.packet.Presence;

public class UpdateOccupantRequest
extends MUCRoomTask<Element> {
    private Element answer;
    private String nickname;
    private int role;
    private MUCRole.Affiliation affiliation;

    public UpdateOccupantRequest() {
    }

    public UpdateOccupantRequest(LocalMUCRoom room, String nickname, MUCRole.Affiliation newAffiliation, MUCRole.Role newRole) {
        super(room);
        this.nickname = nickname;
        this.role = newRole.ordinal();
        this.affiliation = newAffiliation;
    }

    public String getNickname() {
        return this.nickname;
    }

    public MUCRole.Role getRole() {
        return MUCRole.Role.values()[this.role];
    }

    public MUCRole.Affiliation getAffiliation() {
        return this.affiliation;
    }

    public boolean isAffiliationChanged() {
        return this.affiliation != null;
    }

    @Override
    public Element getResult() {
        return this.answer;
    }

    @Override
    public void run() {
        try {
            Presence presence = this.getRoom().updateOccupant(this);
            if (presence != null) {
                this.answer = presence.getElement();
            }
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        ExternalizableUtil.getInstance().writeSafeUTF(out, this.nickname);
        ExternalizableUtil.getInstance().writeInt(out, this.role);
        ExternalizableUtil.getInstance().writeBoolean(out, this.affiliation != null);
        if (this.affiliation != null) {
            ExternalizableUtil.getInstance().writeInt(out, this.affiliation.ordinal());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.nickname = ExternalizableUtil.getInstance().readSafeUTF(in);
        this.role = ExternalizableUtil.getInstance().readInt(in);
        if (ExternalizableUtil.getInstance().readBoolean(in)) {
            this.affiliation = MUCRole.Affiliation.values()[ExternalizableUtil.getInstance().readInt(in)];
        }
    }
}

