/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.muc.cluster;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jivesoftware.openfire.muc.MUCRole;
import org.jivesoftware.openfire.muc.cluster.MUCRoomTask;
import org.jivesoftware.openfire.muc.spi.LocalMUCRoom;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.cache.ExternalizableUtil;

public class OccupantLeftEvent
extends MUCRoomTask<Void> {
    private MUCRole role;
    private String nickname;

    public OccupantLeftEvent() {
    }

    public OccupantLeftEvent(LocalMUCRoom room, MUCRole role) {
        super(room);
        this.role = role;
        this.nickname = role.getNickname();
    }

    public MUCRole getRole() {
        if (this.role == null) {
            try {
                this.role = this.getRoom().getOccupant(this.nickname);
            }
            catch (UserNotFoundException userNotFoundException) {
                // empty catch block
            }
        }
        return this.role;
    }

    @Override
    public Void getResult() {
        return null;
    }

    @Override
    public void run() {
        this.execute(new Runnable(){

            @Override
            public void run() {
                OccupantLeftEvent.this.getRoom().leaveRoom(OccupantLeftEvent.this);
            }
        });
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        ExternalizableUtil.getInstance().writeSafeUTF(out, this.nickname);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.nickname = ExternalizableUtil.getInstance().readSafeUTF(in);
    }
}

