/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.muc.cluster;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.dom4j.Element;
import org.dom4j.tree.DefaultElement;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.cluster.NodeID;
import org.jivesoftware.openfire.muc.MUCRole;
import org.jivesoftware.openfire.muc.cluster.MUCRoomTask;
import org.jivesoftware.openfire.muc.spi.LocalMUCRoom;
import org.jivesoftware.util.cache.ExternalizableUtil;
import org.xmpp.packet.JID;
import org.xmpp.packet.Presence;

public class OccupantAddedEvent
extends MUCRoomTask<Void> {
    private Presence presence;
    private int role;
    private int affiliation;
    private boolean voiceOnly;
    private JID roleAddress;
    private JID userAddress;
    private NodeID nodeID;
    private boolean sendPresence;

    public OccupantAddedEvent() {
    }

    public OccupantAddedEvent(LocalMUCRoom room, MUCRole occupant) {
        super(room);
        this.presence = occupant.getPresence();
        this.role = occupant.getRole().ordinal();
        this.affiliation = occupant.getAffiliation().ordinal();
        this.voiceOnly = occupant.isVoiceOnly();
        this.roleAddress = occupant.getRoleAddress();
        this.userAddress = occupant.getUserAddress();
        this.nodeID = XMPPServer.getInstance().getNodeID();
    }

    public Presence getPresence() {
        return this.presence;
    }

    public String getNickname() {
        return this.presence.getFrom().getResource().trim();
    }

    public MUCRole.Role getRole() {
        return MUCRole.Role.values()[this.role];
    }

    public MUCRole.Affiliation getAffiliation() {
        return MUCRole.Affiliation.values()[this.affiliation];
    }

    public boolean isVoiceOnly() {
        return this.voiceOnly;
    }

    public JID getRoleAddress() {
        return this.roleAddress;
    }

    public JID getUserAddress() {
        return this.userAddress;
    }

    public NodeID getNodeID() {
        return this.nodeID;
    }

    public void setSendPresence(boolean sendPresence) {
        this.sendPresence = sendPresence;
    }

    public boolean isSendPresence() {
        return this.sendPresence;
    }

    @Override
    public Void getResult() {
        return null;
    }

    @Override
    public void run() {
        this.execute(new Runnable(){

            @Override
            public void run() {
                OccupantAddedEvent.this.getRoom().occupantAdded(OccupantAddedEvent.this);
            }
        });
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        ExternalizableUtil.getInstance().writeSerializable(out, (Serializable)((DefaultElement)this.presence.getElement()));
        ExternalizableUtil.getInstance().writeInt(out, this.role);
        ExternalizableUtil.getInstance().writeInt(out, this.affiliation);
        ExternalizableUtil.getInstance().writeBoolean(out, this.voiceOnly);
        ExternalizableUtil.getInstance().writeSerializable(out, (Serializable)this.roleAddress);
        ExternalizableUtil.getInstance().writeSerializable(out, (Serializable)this.userAddress);
        ExternalizableUtil.getInstance().writeByteArray(out, this.nodeID.toByteArray());
        ExternalizableUtil.getInstance().writeBoolean(out, this.sendPresence);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        Element packetElement = (Element)ExternalizableUtil.getInstance().readSerializable(in);
        this.presence = new Presence(packetElement, true);
        this.role = ExternalizableUtil.getInstance().readInt(in);
        this.affiliation = ExternalizableUtil.getInstance().readInt(in);
        this.voiceOnly = ExternalizableUtil.getInstance().readBoolean(in);
        this.roleAddress = (JID)ExternalizableUtil.getInstance().readSerializable(in);
        this.userAddress = (JID)ExternalizableUtil.getInstance().readSerializable(in);
        this.nodeID = NodeID.getInstance(ExternalizableUtil.getInstance().readByteArray(in));
        this.sendPresence = ExternalizableUtil.getInstance().readBoolean(in);
    }
}

