/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.muc.cluster;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jivesoftware.openfire.muc.spi.MUCPersistenceManager;
import org.jivesoftware.util.cache.ClusterTask;
import org.jivesoftware.util.cache.ExternalizableUtil;

public class MUCServicePropertyClusterEventTask
implements ClusterTask<Void> {
    private Type event;
    private String service;
    private String key;
    private String value;

    public static MUCServicePropertyClusterEventTask createPutTask(String service, String key, String value) {
        MUCServicePropertyClusterEventTask task = new MUCServicePropertyClusterEventTask();
        task.event = Type.put;
        task.service = service;
        task.key = key;
        task.value = value;
        return task;
    }

    public static MUCServicePropertyClusterEventTask createDeleteTask(String service, String key) {
        MUCServicePropertyClusterEventTask task = new MUCServicePropertyClusterEventTask();
        task.event = Type.deleted;
        task.service = service;
        task.key = key;
        return task;
    }

    @Override
    public Void getResult() {
        return null;
    }

    @Override
    public void run() {
        if (Type.put == this.event) {
            MUCPersistenceManager.setLocalProperty(this.service, this.key, this.value);
        } else if (Type.deleted == this.event) {
            MUCPersistenceManager.deleteLocalProperty(this.service, this.key);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ExternalizableUtil.getInstance().writeInt(out, this.event.ordinal());
        ExternalizableUtil.getInstance().writeSafeUTF(out, this.service);
        ExternalizableUtil.getInstance().writeSafeUTF(out, this.key);
        ExternalizableUtil.getInstance().writeBoolean(out, this.value != null);
        if (this.value != null) {
            ExternalizableUtil.getInstance().writeSafeUTF(out, this.value);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.event = Type.values()[ExternalizableUtil.getInstance().readInt(in)];
        this.service = ExternalizableUtil.getInstance().readSafeUTF(in);
        this.key = ExternalizableUtil.getInstance().readSafeUTF(in);
        if (ExternalizableUtil.getInstance().readBoolean(in)) {
            this.value = ExternalizableUtil.getInstance().readSafeUTF(in);
        }
    }

    private static enum Type {
        put,
        deleted;

    }
}

