/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.muc.cluster;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.jivesoftware.openfire.muc.cluster.MUCRoomTask;
import org.jivesoftware.openfire.muc.spi.LocalMUCRoom;
import org.jivesoftware.util.cache.ExternalizableUtil;
import org.xmpp.packet.JID;

public class DestroyRoomRequest
extends MUCRoomTask<Void> {
    private JID alternateJID;
    private String reason;

    public DestroyRoomRequest() {
    }

    public DestroyRoomRequest(LocalMUCRoom room, JID alternateJID, String reason) {
        super(room);
        this.alternateJID = alternateJID;
        this.reason = reason;
    }

    public DestroyRoomRequest(LocalMUCRoom room, String alternateJID, String reason) {
        super(room);
        this.alternateJID = new JID(alternateJID);
        this.reason = reason;
    }

    @Override
    public Void getResult() {
        return null;
    }

    @Override
    public void run() {
        this.execute(new Runnable(){

            @Override
            public void run() {
                DestroyRoomRequest.this.getRoom().destroyRoom(DestroyRoomRequest.this);
            }
        });
    }

    public JID getAlternateJID() {
        return this.alternateJID;
    }

    public String getReason() {
        return this.reason;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        ExternalizableUtil.getInstance().writeBoolean(out, this.alternateJID != null);
        if (this.alternateJID != null) {
            ExternalizableUtil.getInstance().writeSerializable(out, (Serializable)this.alternateJID);
        }
        ExternalizableUtil.getInstance().writeBoolean(out, this.reason != null);
        if (this.reason != null) {
            ExternalizableUtil.getInstance().writeSafeUTF(out, this.reason);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        if (ExternalizableUtil.getInstance().readBoolean(in)) {
            this.alternateJID = (JID)ExternalizableUtil.getInstance().readSerializable(in);
        }
        if (ExternalizableUtil.getInstance().readBoolean(in)) {
            this.reason = ExternalizableUtil.getInstance().readSafeUTF(in);
        }
    }
}

