/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.muc;

import java.io.Reader;
import java.io.StringReader;
import java.util.Date;
import java.util.Iterator;
import java.util.ListIterator;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.io.SAXReader;
import org.jivesoftware.openfire.muc.HistoryStrategy;
import org.jivesoftware.openfire.muc.MUCRole;
import org.jivesoftware.openfire.muc.MUCRoom;
import org.jivesoftware.openfire.user.UserNotFoundException;
import org.jivesoftware.util.XMPPDateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;
import org.xmpp.packet.Message;

public final class MUCRoomHistory {
    private static final Logger Log = LoggerFactory.getLogger(MUCRoomHistory.class);
    private MUCRoom room;
    private HistoryStrategy historyStrategy;
    private boolean isNonAnonymousRoom;

    public MUCRoomHistory(MUCRoom mucRoom, HistoryStrategy historyStrategy) {
        this.room = mucRoom;
        this.isNonAnonymousRoom = mucRoom.canAnyoneDiscoverJID();
        this.historyStrategy = historyStrategy;
    }

    public void addMessage(Message packet) {
        boolean isSubjectChangeRequest = this.isSubjectChangeRequest(packet);
        JID fromJID = packet.getFrom();
        if (!isSubjectChangeRequest && (fromJID == null || fromJID.toString().length() == 0 || fromJID.equals((Object)this.room.getRole().getRoleAddress()))) {
            return;
        }
        if (!isSubjectChangeRequest && !this.historyStrategy.isHistoryEnabled()) {
            return;
        }
        if (!(isSubjectChangeRequest || packet.getBody() != null && packet.getBody().trim().length() != 0)) {
            return;
        }
        Message packetToAdd = packet.createCopy();
        if (this.isNonAnonymousRoom != this.room.canAnyoneDiscoverJID()) {
            this.isNonAnonymousRoom = this.room.canAnyoneDiscoverJID();
            Iterator<Message> it = this.getMessageHistory();
            while (it.hasNext()) {
                Message message = it.next();
                Element delayElement = message.getChildElement("delay", "urn:xmpp:delay");
                if (this.room.canAnyoneDiscoverJID()) {
                    try {
                        MUCRole role = this.room.getOccupant(message.getFrom().getResource());
                        delayElement.addAttribute("from", role.getUserAddress().toString());
                    }
                    catch (UserNotFoundException userNotFoundException) {}
                    continue;
                }
                delayElement.addAttribute("from", message.getFrom().toString());
            }
        }
        Element delayInformation = packetToAdd.addChildElement("delay", "urn:xmpp:delay");
        Date current = new Date();
        delayInformation.addAttribute("stamp", XMPPDateTimeFormat.format(current));
        if (this.room.canAnyoneDiscoverJID()) {
            try {
                MUCRole role = this.room.getOccupant(packet.getFrom().getResource());
                delayInformation.addAttribute("from", role.getUserAddress().toString());
            }
            catch (UserNotFoundException userNotFoundException) {}
        } else {
            delayInformation.addAttribute("from", packet.getFrom().toString());
        }
        this.historyStrategy.addMessage(packetToAdd);
    }

    public Iterator<Message> getMessageHistory() {
        return this.historyStrategy.getMessageHistory();
    }

    public ListIterator<Message> getReverseMessageHistory() {
        return this.historyStrategy.getReverseMessageHistory();
    }

    public void addOldMessage(String senderJID, String nickname, Date sentDate, String subject, String body, String stanza) {
        Message message = new Message();
        message.setType(Message.Type.groupchat);
        if (stanza != null) {
            SAXReader xmlReader = new SAXReader();
            xmlReader.setEncoding("UTF-8");
            try {
                Element element = xmlReader.read((Reader)new StringReader(stanza)).getRootElement();
                for (Element child : element.elements()) {
                    Namespace ns = child.getNamespace();
                    if (ns == null || ns.getURI().equals("jabber:client") || ns.getURI().equals("jabber:server")) continue;
                    Element added = message.addChildElement(child.getName(), child.getNamespaceURI());
                    if (!child.getText().isEmpty()) {
                        added.setText(child.getText());
                    }
                    for (Attribute attr : child.attributes()) {
                        added.addAttribute(attr.getQName(), attr.getValue());
                    }
                    for (Element el : child.elements()) {
                        added.add(el.createCopy());
                    }
                }
                if (element.attribute("id") != null) {
                    message.setID(element.attributeValue("id"));
                }
            }
            catch (Exception ex) {
                Log.error("Failed to parse payload XML", (Throwable)ex);
            }
        }
        message.setSubject(subject);
        message.setBody(body);
        if (nickname != null && nickname.trim().length() > 0) {
            JID roomJID = this.room.getRole().getRoleAddress();
            message.setFrom(new JID(roomJID.getNode(), roomJID.getDomain(), nickname, true));
        } else {
            message.setFrom(this.room.getRole().getRoleAddress());
        }
        Element delayInformation = message.addChildElement("delay", "urn:xmpp:delay");
        delayInformation.addAttribute("stamp", XMPPDateTimeFormat.format(sentDate));
        if (this.room.canAnyoneDiscoverJID()) {
            delayInformation.addAttribute("from", senderJID);
        } else {
            delayInformation.addAttribute("from", this.room.getRole().getRoleAddress().toString());
        }
        this.historyStrategy.addMessage(message);
    }

    public boolean hasChangedSubject() {
        return this.historyStrategy.hasChangedSubject();
    }

    public Message getChangedSubject() {
        return this.historyStrategy.getChangedSubject();
    }

    public boolean isSubjectChangeRequest(Message message) {
        return this.historyStrategy.isSubjectChangeRequest(message);
    }
}

