/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.muc;

import java.util.Map;
import org.jivesoftware.openfire.muc.ForbiddenException;
import org.jivesoftware.openfire.muc.MUCRoom;
import org.xmpp.packet.JID;

public abstract class MUCEventDelegate {
    public abstract boolean joiningRoom(MUCRoom var1, JID var2);

    public abstract InvitationResult sendingInvitation(MUCRoom var1, JID var2, JID var3, String var4);

    public abstract InvitationRejectionResult sendingInvitationRejection(MUCRoom var1, JID var2, JID var3, String var4);

    public abstract Map<String, String> getRoomConfig(String var1);

    public abstract boolean destroyingRoom(String var1, JID var2);

    public abstract boolean shouldRecreate(String var1, JID var2);

    public boolean loadConfig(MUCRoom room) {
        Map<String, String> roomConfig = this.getRoomConfig(room.getName());
        if (roomConfig != null) {
            room.setNaturalLanguageName(roomConfig.get("muc#roomconfig_roomname"));
            room.setDescription(roomConfig.get("muc#roomconfig_roomdesc"));
            room.setCanOccupantsChangeSubject("1".equals(roomConfig.get("muc#roomconfig_changesubject")));
            room.setMaxUsers(Integer.parseInt(roomConfig.get("muc#roomconfig_maxusers")));
            room.setPublicRoom("1".equals(roomConfig.get("muc#roomconfig_publicroom")));
            room.setCanOccupantsInvite("1".equals(roomConfig.get("muc#roomconfig_allowinvites")));
            room.setCanAnyoneDiscoverJID("anyone".equals(roomConfig.get("muc#roomconfig_whois")));
            room.setCanSendPrivateMessage(roomConfig.get("muc#roomconfig_allowpm"));
            room.setChangeNickname("1".equals(roomConfig.get("x-muc#roomconfig_canchangenick")));
            room.setRegistrationEnabled("1".equals(roomConfig.get("x-muc#roomconfig_registration")));
            room.setPersistent("1".equals(roomConfig.get("muc#roomconfig_persistentroom")));
            String property = roomConfig.get("muc#roomconfig_roomowners");
            if (property != null) {
                String[] jids;
                for (String jid : jids = property.split(",")) {
                    if (jid == null || jid.trim().length() == 0) continue;
                    room.addFirstOwner(new JID(jid.trim().toLowerCase()).asBareJID());
                }
            }
            try {
                room.unlock(room.getRole());
            }
            catch (ForbiddenException e) {
                return false;
            }
        }
        return roomConfig != null;
    }

    public static enum InvitationRejectionResult {
        HANDLED_BY_DELEGATE,
        HANDLED_BY_OPENFIRE;

    }

    public static enum InvitationResult {
        HANDLED_BY_DELEGATE,
        HANDLED_BY_OPENFIRE,
        REJECTED;

    }
}

