/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.muc;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jivesoftware.openfire.muc.cluster.UpdateHistoryStrategy;
import org.jivesoftware.openfire.muc.spi.MUCPersistenceManager;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.cache.CacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.Message;

public class HistoryStrategy {
    private static final Logger Log = LoggerFactory.getLogger(HistoryStrategy.class);
    private Type type = Type.number;
    private ConcurrentLinkedQueue<Message> history = new ConcurrentLinkedQueue();
    private static final int DEFAULT_MAX_NUMBER = 25;
    private int maxNumber;
    private HistoryStrategy parent;
    private Message roomSubject = null;
    private String contextPrefix = null;
    private String contextSubdomain = null;

    public HistoryStrategy(HistoryStrategy parentStrategy) {
        this.parent = parentStrategy;
        if (this.parent == null) {
            this.maxNumber = 25;
        } else {
            this.type = Type.defaulType;
            this.maxNumber = this.parent.getMaxNumber();
        }
    }

    public int getMaxNumber() {
        return this.maxNumber;
    }

    public void setMaxNumber(int max) {
        if (this.maxNumber == max) {
            return;
        }
        this.maxNumber = max;
        if (this.contextPrefix != null) {
            MUCPersistenceManager.setProperty(this.contextSubdomain, this.contextPrefix + ".maxNumber", Integer.toString(this.maxNumber));
        }
        if (this.parent == null) {
            CacheFactory.doClusterTask(new UpdateHistoryStrategy(this.contextSubdomain, this));
        }
    }

    public void setType(Type newType) {
        if (this.type == newType) {
            return;
        }
        if (newType != null) {
            this.type = newType;
        }
        if (this.contextPrefix != null) {
            MUCPersistenceManager.setProperty(this.contextSubdomain, this.contextPrefix + ".type", this.type.toString());
        }
        if (this.parent == null) {
            CacheFactory.doClusterTask(new UpdateHistoryStrategy(this.contextSubdomain, this));
        }
    }

    public Type getType() {
        return this.type;
    }

    public void addMessage(Message packet) {
        int strategyMaxNumber;
        Type strategyType;
        if (this.type == Type.defaulType && this.parent != null) {
            strategyType = this.parent.getType();
            strategyMaxNumber = this.parent.getMaxNumber();
        } else {
            strategyType = this.type;
            strategyMaxNumber = this.maxNumber;
        }
        boolean subjectChange = this.isSubjectChangeRequest(packet);
        if (subjectChange) {
            this.roomSubject = packet;
            return;
        }
        if (strategyType == Type.all) {
            this.history.add(packet);
        } else if (strategyType == Type.number) {
            if (this.history.size() >= strategyMaxNumber) {
                Iterator<Message> historyIter = this.history.iterator();
                while (historyIter.hasNext() && this.history.size() > strategyMaxNumber) {
                    if (historyIter.next() == this.roomSubject) continue;
                    historyIter.remove();
                }
            }
            this.history.add(packet);
        }
    }

    boolean isHistoryEnabled() {
        Type strategyType = this.type;
        if (this.type == Type.defaulType && this.parent != null) {
            strategyType = this.parent.getType();
        }
        return strategyType != Type.none;
    }

    public Iterator<Message> getMessageHistory() {
        LinkedList<Message> list = new LinkedList<Message>(this.history);
        Collections.sort(list, new MessageComparator());
        return list.iterator();
    }

    public ListIterator<Message> getReverseMessageHistory() {
        LinkedList<Message> list = new LinkedList<Message>(this.history);
        Collections.sort(list, new MessageComparator());
        return list.listIterator(list.size());
    }

    public void setTypeFromString(String typeName) {
        try {
            this.type = Type.valueOf(typeName);
        }
        catch (Exception e) {
            this.type = this.parent != null ? Type.defaulType : Type.number;
        }
    }

    public void setContext(String subdomain, String prefix) {
        this.contextSubdomain = subdomain;
        this.contextPrefix = prefix;
        this.setTypeFromString(MUCPersistenceManager.getProperty(subdomain, prefix + ".type"));
        String maxNumberString = MUCPersistenceManager.getProperty(subdomain, prefix + ".maxNumber");
        if (maxNumberString != null && maxNumberString.trim().length() > 0) {
            try {
                this.maxNumber = Integer.parseInt(maxNumberString);
            }
            catch (Exception e) {
                Log.info("Jive property " + prefix + ".maxNumber not a valid number.");
            }
        }
    }

    public boolean hasChangedSubject() {
        return this.roomSubject != null;
    }

    public Message getChangedSubject() {
        return this.roomSubject;
    }

    public boolean isSubjectChangeRequest(Message message) {
        return Message.Type.groupchat == message.getType() && message.getSubject() != null && (!this.isSubjectChangeStrict() || message.getBody() == null && message.getThread() == null);
    }

    private boolean isSubjectChangeStrict() {
        return JiveGlobals.getBooleanProperty("xmpp.muc.subject.change.strict", true);
    }

    private static class MessageComparator
    implements Comparator<Message> {
        private MessageComparator() {
        }

        @Override
        public int compare(Message o1, Message o2) {
            String stamp1 = o1.getChildElement("delay", "urn:xmpp:delay").attributeValue("stamp");
            String stamp2 = o2.getChildElement("delay", "urn:xmpp:delay").attributeValue("stamp");
            return stamp1.compareTo(stamp2);
        }
    }

    public static enum Type {
        defaulType,
        none,
        all,
        number;

    }
}

