/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.mediaproxy;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.openfire.mediaproxy.DatagramListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class Channel
implements Runnable {
    private static final Logger Log = LoggerFactory.getLogger(Channel.class);
    protected byte[] buf = new byte[5000];
    protected DatagramSocket dataSocket;
    protected DatagramPacket packet;
    protected boolean enabled = true;
    List<DatagramListener> listeners = new ArrayList<DatagramListener>();
    protected InetAddress host;
    protected int port;

    public Channel(DatagramSocket dataSocket, InetAddress host, int port) {
        this.dataSocket = dataSocket;
        this.host = host;
        this.port = port;
    }

    public InetAddress getHost() {
        return this.host;
    }

    protected void setHost(InetAddress host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    protected void setPort(int port) {
        this.port = port;
    }

    public void addListener(DatagramListener datagramListener) {
        this.listeners.add(datagramListener);
    }

    public void removeListener(DatagramListener datagramListener) {
        this.listeners.remove(datagramListener);
    }

    public void removeListeners() {
        this.listeners.removeAll(this.listeners);
    }

    public void cancel() {
        this.enabled = false;
        if (this.dataSocket != null) {
            this.dataSocket.close();
        }
    }

    @Override
    public void run() {
        block8: {
            try {
                while (this.enabled) {
                    this.packet = new DatagramPacket(this.buf, this.buf.length);
                    this.dataSocket.receive(this.packet);
                    if (!this.handle(this.packet)) continue;
                    boolean resend = true;
                    for (DatagramListener dl : this.listeners) {
                        boolean send = dl.datagramReceived(this.packet);
                        if (!resend || send) continue;
                        resend = false;
                    }
                    if (!resend) continue;
                    this.relayPacket(this.packet);
                }
            }
            catch (UnknownHostException uhe) {
                if (this.enabled) {
                    Log.error("Unknown Host", (Throwable)uhe);
                }
            }
            catch (SocketException se) {
                if (this.enabled) {
                    Log.error("Socket closed", (Throwable)se);
                }
            }
            catch (IOException ioe) {
                if (!this.enabled) break block8;
                Log.error("Communication error", (Throwable)ioe);
            }
        }
    }

    public void relayPacket(DatagramPacket packet) {
        try {
            DatagramPacket echo = new DatagramPacket(packet.getData(), packet.getLength(), this.host, this.port);
            this.dataSocket.send(echo);
        }
        catch (IOException e) {
            Log.error(e.getMessage(), (Throwable)e);
        }
    }

    abstract boolean handle(DatagramPacket var1);
}

