/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.lockout;

import java.util.Date;
import java.util.Map;
import org.jivesoftware.openfire.lockout.DefaultLockOutProvider;
import org.jivesoftware.openfire.lockout.LockOutEventDispatcher;
import org.jivesoftware.openfire.lockout.LockOutFlag;
import org.jivesoftware.openfire.lockout.LockOutProvider;
import org.jivesoftware.util.ClassUtils;
import org.jivesoftware.util.JiveGlobals;
import org.jivesoftware.util.PropertyEventDispatcher;
import org.jivesoftware.util.PropertyEventListener;
import org.jivesoftware.util.cache.Cache;
import org.jivesoftware.util.cache.CacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockOutManager {
    private static final Logger Log = LoggerFactory.getLogger(LockOutManager.class);
    private Cache<String, LockOutFlag> lockOutCache = CacheFactory.createCache("Locked Out Accounts");
    private LockOutProvider provider;

    public static LockOutProvider getLockOutProvider() {
        return LockOutManagerContainer.instance.provider;
    }

    public static LockOutManager getInstance() {
        return LockOutManagerContainer.instance;
    }

    private LockOutManager() {
        this.initProvider();
        PropertyEventListener propListener = new PropertyEventListener(){

            public void propertySet(String property, Map params) {
                if ("provider.lockout.className".equals(property)) {
                    LockOutManager.this.initProvider();
                }
            }

            public void propertyDeleted(String property, Map params) {
            }

            public void xmlPropertySet(String property, Map params) {
            }

            public void xmlPropertyDeleted(String property, Map params) {
            }
        };
        PropertyEventDispatcher.addListener(propListener);
    }

    private void initProvider() {
        JiveGlobals.migrateProperty("provider.lockout.className");
        String className = JiveGlobals.getProperty("provider.lockout.className", "org.jivesoftware.openfire.lockout.DefaultLockOutProvider");
        if (this.provider == null || !className.equals(this.provider.getClass().getName())) {
            try {
                Class c = ClassUtils.forName(className);
                this.provider = (LockOutProvider)c.newInstance();
            }
            catch (Exception e) {
                Log.error("Error loading lockout provider: " + className, (Throwable)e);
                this.provider = new DefaultLockOutProvider();
            }
        }
    }

    public LockOutFlag getDisabledStatus(String username) {
        if (username == null) {
            throw new UnsupportedOperationException("Null username not allowed!");
        }
        LockOutFlag lockOutFlag = this.getUserLockOut(username);
        return this.getUnExpiredLockout(lockOutFlag);
    }

    public boolean isAccountDisabled(String username) {
        LockOutFlag flag = this.getDisabledStatus(username);
        if (flag == null) {
            return false;
        }
        Date curDate = new Date();
        if (flag.getStartTime() != null && curDate.before(flag.getStartTime())) {
            return false;
        }
        return flag.getEndTime() == null || !curDate.after(flag.getEndTime());
    }

    public void disableAccount(String username, Date startTime, Date endTime) throws UnsupportedOperationException {
        if (this.provider.isReadOnly()) {
            throw new UnsupportedOperationException();
        }
        LockOutFlag flag = new LockOutFlag(username, startTime, endTime);
        this.provider.setDisabledStatus(flag);
        if (!this.provider.shouldNotBeCached()) {
            this.lockOutCache.put(username, flag);
        }
        LockOutEventDispatcher.accountLocked(flag);
    }

    public void enableAccount(String username) throws UnsupportedOperationException {
        if (this.provider.isReadOnly()) {
            throw new UnsupportedOperationException();
        }
        this.provider.unsetDisabledStatus(username);
        if (!this.provider.shouldNotBeCached()) {
            this.lockOutCache.remove(username);
        }
        LockOutEventDispatcher.accountUnlocked(username);
    }

    public void recordFailedLogin(String username) {
        LockOutEventDispatcher.lockedAccountDenied(username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LockOutFlag getUserLockOut(String username) {
        if (this.provider.shouldNotBeCached()) {
            return this.provider.getDisabledStatus(username);
        }
        LockOutFlag flag = (LockOutFlag)this.lockOutCache.get(username);
        if (flag == null) {
            String string = username.intern();
            synchronized (string) {
                flag = (LockOutFlag)this.lockOutCache.get(username);
                if (flag == null && (flag = this.provider.getDisabledStatus(username)) != null) {
                    this.lockOutCache.put(username, flag);
                }
            }
        }
        return flag;
    }

    private LockOutFlag getUnExpiredLockout(LockOutFlag flag) {
        if (flag != null) {
            Date curDate = new Date();
            if (flag.getEndTime() != null && curDate.after(flag.getEndTime())) {
                this.lockOutCache.remove(flag.getUsername());
                this.provider.unsetDisabledStatus(flag.getUsername());
                return null;
            }
        }
        return flag;
    }

    private static class LockOutManagerContainer {
        private static LockOutManager instance = new LockOutManager();

        private LockOutManagerContainer() {
        }
    }
}

