/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.keystore;

import java.io.IOException;
import java.security.KeyStoreException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import org.jivesoftware.openfire.keystore.CertificateStore;
import org.jivesoftware.openfire.keystore.CertificateStoreConfigException;
import org.jivesoftware.openfire.keystore.CertificateStoreConfiguration;
import org.jivesoftware.util.CertificateManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustStore
extends CertificateStore {
    private static final Logger Log = LoggerFactory.getLogger(TrustStore.class);

    public TrustStore(CertificateStoreConfiguration configuration, boolean createIfAbsent) throws CertificateStoreConfigException {
        super(configuration, createIfAbsent);
    }

    public void installCertificate(String alias, String pemRepresentation) throws CertificateStoreConfigException {
        if (alias == null || alias.trim().isEmpty()) {
            throw new IllegalArgumentException("Argument 'alias' cannot be null or an empty String.");
        }
        if (pemRepresentation == null) {
            throw new IllegalArgumentException("Argument 'pemRepresentation' cannot be null.");
        }
        alias = alias.trim();
        try {
            if (this.store.containsAlias(alias)) {
                throw new CertificateStoreConfigException("Certificate already exists for alias: " + alias);
            }
            Collection<X509Certificate> certificates = CertificateManager.parseCertificates(pemRepresentation);
            if (certificates.isEmpty()) {
                throw new CertificateStoreConfigException("No certificate was found in the input.");
            }
            if (certificates.size() != 1) {
                throw new CertificateStoreConfigException("More than one certificate was found in the input.");
            }
            X509Certificate certificate = certificates.iterator().next();
            this.store.setCertificateEntry(alias, certificate);
            this.persist();
        }
        catch (IOException | KeyStoreException | CertificateException e) {
            throw new CertificateStoreConfigException("Unable to install a certificate into a trust store.", e);
        }
        finally {
            this.reload();
        }
    }

    public boolean isTrusted(Certificate[] chain) {
        return this.getEndEntityCertificate(chain) != null;
    }

    public X509Certificate getEndEntityCertificate(Certificate[] chain) {
        if (chain == null || chain.length == 0) {
            return null;
        }
        X509Certificate first = (X509Certificate)chain[0];
        try {
            first.checkValidity();
        }
        catch (CertificateException e) {
            Log.warn("EE Certificate not valid: " + e.getMessage());
            return null;
        }
        if (chain.length == 1 && first.getSubjectX500Principal().equals(first.getIssuerX500Principal())) {
            try {
                if (this.store.getCertificateAlias(first) != null) {
                    return first;
                }
            }
            catch (KeyStoreException e) {
                Log.warn("Keystore error while looking for self-signed cert; assuming untrusted.");
            }
            return null;
        }
        ArrayList<Certificate> allCerts = new ArrayList<Certificate>();
        try {
            Enumeration<String> aliases = this.store.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!this.store.isCertificateEntry(alias)) continue;
                X509Certificate cert = (X509Certificate)this.store.getCertificate(alias);
                allCerts.add(cert);
            }
            allCerts.addAll(Arrays.asList(chain));
            CertStore cs = CertStore.getInstance("Collection", new CollectionCertStoreParameters(allCerts));
            X509CertSelector selector = new X509CertSelector();
            selector.setCertificate(first);
            PKIXBuilderParameters params = new PKIXBuilderParameters(this.store, (CertSelector)selector);
            params.addCertStore(cs);
            params.setDate(new Date());
            params.setRevocationEnabled(false);
            CertPathBuilder pathBuilder = CertPathBuilder.getInstance(CertPathBuilder.getDefaultType());
            CertPath cp = pathBuilder.build(params).getCertPath();
            CertPathValidator pathValidator = CertPathValidator.getInstance("PKIX");
            pathValidator.validate(cp, params);
            return (X509Certificate)cp.getCertificates().get(0);
        }
        catch (CertPathBuilderException e) {
            Log.warn("Path builder exception while validating certificate chain:", (Throwable)e);
        }
        catch (CertPathValidatorException e) {
            Log.warn("Path exception while validating certificate chain:", (Throwable)e);
        }
        catch (Exception e) {
            Log.warn("Unkown exception while validating certificate chain:" + e.getMessage());
        }
        return null;
    }
}

