/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.keystore;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jivesoftware.openfire.XMPPServer;
import org.jivesoftware.openfire.container.BasicModule;
import org.jivesoftware.openfire.keystore.CertificateStore;
import org.jivesoftware.openfire.keystore.CertificateStoreConfigException;
import org.jivesoftware.openfire.keystore.CertificateStoreConfiguration;
import org.jivesoftware.openfire.keystore.CertificateStoreWatcher;
import org.jivesoftware.openfire.keystore.IdentityStore;
import org.jivesoftware.openfire.keystore.TrustStore;
import org.jivesoftware.openfire.spi.ConnectionListener;
import org.jivesoftware.openfire.spi.ConnectionManagerImpl;
import org.jivesoftware.openfire.spi.ConnectionType;
import org.jivesoftware.util.JiveGlobals;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateStoreManager
extends BasicModule {
    private static final Logger Log = LoggerFactory.getLogger(CertificateStoreManager.class);
    private final ConcurrentMap<ConnectionType, CertificateStoreConfiguration> typeToTrustStore = new ConcurrentHashMap<ConnectionType, CertificateStoreConfiguration>();
    private final ConcurrentMap<ConnectionType, CertificateStoreConfiguration> typeToIdentityStore = new ConcurrentHashMap<ConnectionType, CertificateStoreConfiguration>();
    private final ConcurrentMap<CertificateStoreConfiguration, IdentityStore> identityStores = new ConcurrentHashMap<CertificateStoreConfiguration, IdentityStore>();
    private final ConcurrentMap<CertificateStoreConfiguration, TrustStore> trustStores = new ConcurrentHashMap<CertificateStoreConfiguration, TrustStore>();
    private CertificateStoreWatcher storeWatcher;

    public CertificateStoreManager() {
        super("Certificate Store Manager");
    }

    @Override
    public synchronized void initialize(XMPPServer server) {
        super.initialize(server);
        this.storeWatcher = new CertificateStoreWatcher();
        for (ConnectionType type : ConnectionType.values()) {
            CertificateStore store;
            try {
                Log.debug("(identity store for connection type '{}') Initializing store...", (Object)type);
                CertificateStoreConfiguration identityStoreConfiguration = this.getIdentityStoreConfiguration(type);
                if (!this.identityStores.containsKey(identityStoreConfiguration)) {
                    store = new IdentityStore(identityStoreConfiguration, false);
                    this.identityStores.put(identityStoreConfiguration, (IdentityStore)store);
                    this.storeWatcher.watch(store);
                }
                this.typeToIdentityStore.put(type, identityStoreConfiguration);
            }
            catch (IOException | CertificateStoreConfigException e) {
                Log.warn("(identity store for connection type '{}') Unable to instantiate store ", (Object)type, (Object)e);
            }
            try {
                Log.debug("(trust store for connection type '{}') Initializing store...", (Object)type);
                CertificateStoreConfiguration trustStoreConfiguration = this.getTrustStoreConfiguration(type);
                if (!this.trustStores.containsKey(trustStoreConfiguration)) {
                    store = new TrustStore(trustStoreConfiguration, false);
                    this.trustStores.put(trustStoreConfiguration, (TrustStore)store);
                    this.storeWatcher.watch(store);
                }
                this.typeToTrustStore.put(type, trustStoreConfiguration);
            }
            catch (IOException | CertificateStoreConfigException e) {
                Log.warn("(trust store for connection type '{}') Unable to instantiate store ", (Object)type, (Object)e);
            }
        }
    }

    @Override
    public synchronized void destroy() {
        this.storeWatcher.destroy();
        this.typeToIdentityStore.clear();
        this.typeToTrustStore.clear();
        this.identityStores.clear();
        this.trustStores.clear();
        super.destroy();
    }

    public IdentityStore getIdentityStore(ConnectionType type) {
        CertificateStoreConfiguration configuration = (CertificateStoreConfiguration)this.typeToIdentityStore.get((Object)type);
        if (configuration == null) {
            return null;
        }
        return (IdentityStore)this.identityStores.get(configuration);
    }

    public TrustStore getTrustStore(ConnectionType type) {
        CertificateStoreConfiguration configuration = (CertificateStoreConfiguration)this.typeToTrustStore.get((Object)type);
        if (configuration == null) {
            return null;
        }
        return (TrustStore)this.trustStores.get(configuration);
    }

    public void replaceIdentityStore(ConnectionType type, CertificateStoreConfiguration configuration, boolean createIfAbsent) throws CertificateStoreConfigException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 'type' cannot be null.");
        }
        if (configuration == null) {
            throw new IllegalArgumentException("Argument 'configuration' cannot be null.");
        }
        CertificateStoreConfiguration oldConfig = (CertificateStoreConfiguration)this.typeToIdentityStore.get((Object)type);
        if (oldConfig == null || !oldConfig.equals(configuration)) {
            IdentityStore store;
            if (!this.identityStores.containsKey(configuration)) {
                store = new IdentityStore(configuration, createIfAbsent);
                this.identityStores.put(configuration, store);
                this.storeWatcher.watch(store);
            }
            this.typeToIdentityStore.put(type, configuration);
            if (oldConfig != null && !this.typeToIdentityStore.containsValue(oldConfig) && (store = (IdentityStore)this.identityStores.remove(oldConfig)) != null) {
                this.storeWatcher.unwatch(store);
            }
            ConnectionManagerImpl connectionManager = (ConnectionManagerImpl)XMPPServer.getInstance().getConnectionManager();
            for (ConnectionListener connectionListener : connectionManager.getListeners(type)) {
                try {
                    connectionListener.setIdentityStoreConfiguration(configuration);
                }
                catch (RuntimeException e) {
                    Log.warn("An exception occurred while trying to update the identity store configuration for connection type '" + (Object)((Object)type) + "'", (Throwable)e);
                }
            }
        }
        JiveGlobals.setProperty(type.getPrefix() + "keystore", configuration.getFile().getPath());
        JiveGlobals.setProperty(type.getPrefix() + "keypass", new String(configuration.getPassword()));
    }

    public void replaceTrustStore(ConnectionType type, CertificateStoreConfiguration configuration, boolean createIfAbsent) throws CertificateStoreConfigException {
        if (type == null) {
            throw new IllegalArgumentException("Argument 'type' cannot be null.");
        }
        if (configuration == null) {
            throw new IllegalArgumentException("Argument 'configuration' cannot be null.");
        }
        CertificateStoreConfiguration oldConfig = (CertificateStoreConfiguration)this.typeToTrustStore.get((Object)type);
        if (oldConfig == null || !oldConfig.equals(configuration)) {
            TrustStore store;
            if (!this.trustStores.containsKey(configuration)) {
                store = new TrustStore(configuration, createIfAbsent);
                this.trustStores.put(configuration, store);
                this.storeWatcher.watch(store);
            }
            this.typeToTrustStore.put(type, configuration);
            if (oldConfig != null && !this.typeToTrustStore.containsValue(oldConfig) && (store = (TrustStore)this.trustStores.remove(oldConfig)) != null) {
                this.storeWatcher.unwatch(store);
            }
            ConnectionManagerImpl connectionManager = (ConnectionManagerImpl)XMPPServer.getInstance().getConnectionManager();
            for (ConnectionListener connectionListener : connectionManager.getListeners(type)) {
                try {
                    connectionListener.setTrustStoreConfiguration(configuration);
                }
                catch (RuntimeException e) {
                    Log.warn("An exception occurred while trying to update the trust store configuration for connection type '" + (Object)((Object)type) + "'", (Throwable)e);
                }
            }
        }
        JiveGlobals.setProperty(type.getPrefix() + "truststore", configuration.getFile().getPath());
        JiveGlobals.setProperty(type.getPrefix() + "trustpass", new String(configuration.getPassword()));
    }

    public CertificateStoreConfiguration getIdentityStoreConfiguration(ConnectionType type) throws IOException {
        String keyStoreType = CertificateStoreManager.getKeyStoreType(type);
        String password = CertificateStoreManager.getIdentityStorePassword(type);
        String location = CertificateStoreManager.getIdentityStoreLocation(type);
        File file = CertificateStoreManager.canonicalize(location);
        return new CertificateStoreConfiguration(keyStoreType, file, password.toCharArray());
    }

    public CertificateStoreConfiguration getTrustStoreConfiguration(ConnectionType type) throws IOException {
        String keyStoreType = CertificateStoreManager.getKeyStoreType(type);
        String password = CertificateStoreManager.getTrustStorePassword(type);
        String location = CertificateStoreManager.getTrustStoreLocation(type);
        File file = CertificateStoreManager.canonicalize(location);
        return new CertificateStoreConfiguration(keyStoreType, file, password.toCharArray());
    }

    static String getKeyStoreType(ConnectionType type) {
        String propertyName = type.getPrefix() + "storeType";
        String defaultValue = "jks";
        if (type.getFallback() == null) {
            return JiveGlobals.getProperty(propertyName, "jks").trim();
        }
        return JiveGlobals.getProperty(propertyName, CertificateStoreManager.getKeyStoreType(type.getFallback())).trim();
    }

    static void setKeyStoreType(ConnectionType type, String keyStoreType) {
        JiveGlobals.setProperty(type.getPrefix() + "storeType", keyStoreType);
        String oldKeyStoreType = CertificateStoreManager.getKeyStoreType(type);
        if (oldKeyStoreType.equals(keyStoreType)) {
            Log.debug("Ignoring KeyStore type change request (to '{}'): listener already in this state.", (Object)keyStoreType);
            return;
        }
        Log.debug("Changing KeyStore type from '{}' to '{}'.", (Object)oldKeyStoreType, (Object)keyStoreType);
    }

    static String getIdentityStorePassword(ConnectionType type) {
        String propertyName = type.getPrefix() + "keypass";
        String defaultValue = "changeit";
        if (type.getFallback() == null) {
            return JiveGlobals.getProperty(propertyName, "changeit").trim();
        }
        return JiveGlobals.getProperty(propertyName, CertificateStoreManager.getIdentityStorePassword(type.getFallback())).trim();
    }

    static String getTrustStorePassword(ConnectionType type) {
        String propertyName = type.getPrefix() + "trustpass";
        String defaultValue = "changeit";
        if (type.getFallback() == null) {
            return JiveGlobals.getProperty(propertyName, "changeit").trim();
        }
        return JiveGlobals.getProperty(propertyName, CertificateStoreManager.getTrustStorePassword(type.getFallback())).trim();
    }

    static String getIdentityStoreLocation(ConnectionType type) {
        String propertyName = type.getPrefix() + "keystore";
        String defaultValue = "resources" + File.separator + "security" + File.separator + "keystore";
        if (type.getFallback() == null) {
            return JiveGlobals.getProperty(propertyName, defaultValue).trim();
        }
        return JiveGlobals.getProperty(propertyName, CertificateStoreManager.getIdentityStoreLocation(type.getFallback())).trim();
    }

    static String getTrustStoreLocation(ConnectionType type) {
        String propertyName = type.getPrefix() + "truststore";
        String defaultValue = "resources" + File.separator + "security" + File.separator + "truststore";
        if (type.getFallback() == null) {
            return JiveGlobals.getProperty(propertyName, defaultValue).trim();
        }
        return JiveGlobals.getProperty(propertyName, CertificateStoreManager.getTrustStoreLocation(type.getFallback())).trim();
    }

    static File canonicalize(String path) throws IOException {
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(JiveGlobals.getHomeDirectory() + File.separator + path);
        }
        return file;
    }
}

